/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityHandler
extends DataRequestHandler {
    private final ActivityService service;
    private static final String ACTIVITY_ID_PATH = "/activities/{userId}+/{groupId}/{appId}/{activityId}+";

    @Inject
    public ActivityHandler(ActivityService service) {
        this.service = service;
    }

    @Override
    protected Future<?> handleDelete(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(ACTIVITY_ID_PATH);
        Set<UserId> userIds = request.getUsers();
        LinkedHashSet activityIds = Sets.newLinkedHashSet(request.getListParameter("activityId"));
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        DataRequestHandler.Preconditions.requireSingular(userIds, "Multiple userIds not supported");
        return this.service.deleteActivities(userIds.iterator().next(), request.getGroup(), request.getAppId(), activityIds, request.getToken());
    }

    @Override
    protected Future<?> handlePut(RequestItem request) throws SocialSpiException {
        return this.handlePost(request);
    }

    @Override
    protected Future<?> handlePost(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(ACTIVITY_ID_PATH);
        Set<UserId> userIds = request.getUsers();
        List<String> activityIds = request.getListParameter("activityId");
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        DataRequestHandler.Preconditions.requireSingular(userIds, "Multiple userIds not supported");
        DataRequestHandler.Preconditions.requireEmpty(activityIds, "Cannot specify activityId in create");
        return this.service.createActivity(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), request.getTypedParameter("activity", Activity.class), request.getToken());
    }

    @Override
    protected Future<?> handleGet(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(ACTIVITY_ID_PATH);
        Set<UserId> userIds = request.getUsers();
        LinkedHashSet optionalActivityIds = Sets.newLinkedHashSet(request.getListParameter("activityId"));
        CollectionOptions options = new CollectionOptions(request);
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        if (userIds.size() > 1 && !optionalActivityIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch same activityIds for multiple userIds");
        }
        if (!optionalActivityIds.isEmpty()) {
            if (optionalActivityIds.size() == 1) {
                return this.service.getActivity(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), (String)optionalActivityIds.iterator().next(), request.getToken());
            }
            return this.service.getActivities(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), options, optionalActivityIds, request.getToken());
        }
        return this.service.getActivities(userIds, request.getGroup(), request.getAppId(), request.getFields(), options, request.getToken());
    }
}

