/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialRequestItem
extends BaseRequestItem {
    String USER_ID = "userId";
    String GROUP_ID = "groupId";

    public SocialRequestItem(Map<String, String[]> parameters, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        super(parameters, token, converter, jsonConverter);
    }

    public SocialRequestItem(JSONObject parameters, Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        super(parameters, formItems, token, converter, jsonConverter);
    }

    public Set<UserId> getUsers() {
        List ids = this.getListParameter(this.USER_ID);
        if (ids.isEmpty()) {
            if (this.token.getViewerId() != null) {
                return ImmutableSet.of((Object)UserId.fromJson("@me"));
            }
            throw new IllegalArgumentException("No userId provided and viewer not available");
        }
        ImmutableSet.Builder userIds = ImmutableSet.builder();
        for (String id : ids) {
            userIds.add((Object)UserId.fromJson(id));
        }
        return userIds.build();
    }

    public GroupId getGroup() {
        return GroupId.fromJson(this.getParameter(this.GROUP_ID, "@self"));
    }

    public String getSortBy() {
        String sortBy = super.getSortBy();
        return sortBy == null ? "topFriends" : sortBy;
    }
}

