/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.mgt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.lang.util.Nameable;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.web.filter.PathConfigProcessor;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.NamedFilterList;
import org.apache.shiro.web.filter.mgt.SimpleNamedFilterList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterChainManager
implements FilterChainManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilterChainManager.class);
    private FilterConfig filterConfig;
    private Map<String, Filter> filters = new LinkedHashMap<String, Filter>();
    private List<String> globalFilterNames;
    private Map<String, NamedFilterList> filterChains = new LinkedHashMap<String, NamedFilterList>();

    public DefaultFilterChainManager() {
        this.globalFilterNames = new ArrayList<String>();
        this.addDefaultFilters(false);
    }

    public DefaultFilterChainManager(FilterConfig filterConfig) {
        this.globalFilterNames = new ArrayList<String>();
        this.setFilterConfig(filterConfig);
        this.addDefaultFilters(true);
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    @Override
    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Map<String, NamedFilterList> getFilterChains() {
        return this.filterChains;
    }

    public void setFilterChains(Map<String, NamedFilterList> filterChains) {
        this.filterChains = filterChains;
    }

    public Filter getFilter(String name) {
        return this.filters.get(name);
    }

    @Override
    public void addFilter(String name, Filter filter) {
        this.addFilter(name, filter, false);
    }

    @Override
    public void addFilter(String name, Filter filter, boolean init) {
        this.addFilter(name, filter, init, true);
    }

    @Override
    public void createDefaultChain(String chainName) {
        if (!this.getChainNames().contains(chainName) && !CollectionUtils.isEmpty(this.globalFilterNames)) {
            this.globalFilterNames.stream().forEach(filterName -> this.addToChain(chainName, (String)filterName));
        }
    }

    @Override
    public void createChain(String chainName, String chainDefinition) {
        String[] filterTokens;
        if (!StringUtils.hasText((String)chainName)) {
            throw new NullPointerException("chainName cannot be null or empty.");
        }
        if (!StringUtils.hasText((String)chainDefinition)) {
            throw new NullPointerException("chainDefinition cannot be null or empty.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating chain [" + chainName + "] with global filters " + String.valueOf(this.globalFilterNames) + " and from String definition [" + chainDefinition + "]");
        }
        if (!CollectionUtils.isEmpty(this.globalFilterNames)) {
            this.globalFilterNames.stream().forEach(filterName -> this.addToChain(chainName, (String)filterName));
        }
        for (String token : filterTokens = this.splitChainDefinition(chainDefinition)) {
            String[] nameConfigPair = this.toNameConfigPair(token);
            this.addToChain(chainName, nameConfigPair[0], nameConfigPair[1]);
        }
    }

    protected String[] splitChainDefinition(String chainDefinition) {
        return StringUtils.split((String)chainDefinition, (char)',', (char)'[', (char)']', (boolean)true, (boolean)true);
    }

    protected String[] toNameConfigPair(String token) throws ConfigurationException {
        try {
            String[] pair = token.split("\\[", 2);
            String name = StringUtils.clean((String)pair[0]);
            if (name == null) {
                throw new IllegalArgumentException("Filter name not found for filter chain definition token: " + token);
            }
            String config = null;
            if (pair.length == 2) {
                config = StringUtils.clean((String)pair[1]);
                config = config.substring(0, config.length() - 1);
                if ((config = StringUtils.clean((String)config)) != null && config.startsWith("\"") && config.endsWith("\"")) {
                    String stripped = config.substring(1, config.length() - 1);
                    if ((stripped = StringUtils.clean((String)stripped)) != null && stripped.indexOf(34) == -1) {
                        config = stripped;
                    }
                }
            }
            return new String[]{name, config};
        }
        catch (Exception e) {
            String msg = "Unable to parse filter chain definition token: " + token;
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    protected void addFilter(String name, Filter filter, boolean init, boolean overwrite) {
        Filter existing = this.getFilter(name);
        if (existing == null || overwrite) {
            if (filter instanceof Nameable) {
                ((Nameable)filter).setName(name);
            }
            if (init) {
                this.initFilter(filter);
            }
            this.filters.put(name, filter);
        }
    }

    @Override
    public void addToChain(String chainName, String filterName) {
        this.addToChain(chainName, filterName, null);
    }

    @Override
    public void addToChain(String chainName, String filterName, String chainSpecificFilterConfig) {
        if (!StringUtils.hasText((String)chainName)) {
            throw new IllegalArgumentException("chainName cannot be null or empty.");
        }
        Filter filter = this.getFilter(filterName);
        if (filter == null) {
            throw new IllegalArgumentException("There is no filter with name '" + filterName + "' to apply to chain [" + chainName + "] in the pool of available Filters.  Ensure a filter with that name/path has first been registered with the addFilter method(s).");
        }
        this.applyChainConfig(chainName, filter, chainSpecificFilterConfig);
        NamedFilterList chain = this.ensureChain(chainName);
        chain.add(filter);
    }

    @Override
    public void setGlobalFilters(List<String> globalFilterNames) throws ConfigurationException {
        if (!CollectionUtils.isEmpty(globalFilterNames)) {
            for (String filterName : globalFilterNames) {
                Filter filter = this.filters.get(filterName);
                if (filter == null) {
                    throw new ConfigurationException("There is no filter with name '" + filterName + "' to apply to the global filters in the pool of available Filters.  Ensure a filter with that name/path has first been registered with the addFilter method(s).");
                }
                this.globalFilterNames.add(filterName);
            }
        }
    }

    protected void applyChainConfig(String chainName, Filter filter, String chainSpecificFilterConfig) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempting to apply path [" + chainName + "] to filter [" + String.valueOf(filter) + "] with config [" + chainSpecificFilterConfig + "]");
        }
        if (filter instanceof PathConfigProcessor) {
            ((PathConfigProcessor)filter).processPathConfig(chainName, chainSpecificFilterConfig);
        } else if (StringUtils.hasText((String)chainSpecificFilterConfig)) {
            String msg = "chainSpecificFilterConfig was specified, but the underlying Filter instance is not an 'instanceof' " + PathConfigProcessor.class.getName() + ".  This is required if the filter is to accept chain-specific configuration.";
            throw new ConfigurationException(msg);
        }
    }

    protected NamedFilterList ensureChain(String chainName) {
        NamedFilterList chain = this.getChain(chainName);
        if (chain == null) {
            chain = new SimpleNamedFilterList(chainName);
            this.filterChains.put(chainName, chain);
        }
        return chain;
    }

    @Override
    public NamedFilterList getChain(String chainName) {
        return this.filterChains.get(chainName);
    }

    @Override
    public boolean hasChains() {
        return !CollectionUtils.isEmpty(this.filterChains);
    }

    @Override
    public Set<String> getChainNames() {
        return this.filterChains != null ? this.filterChains.keySet() : Collections.EMPTY_SET;
    }

    @Override
    public FilterChain proxy(FilterChain original, String chainName) {
        NamedFilterList configured = this.getChain(chainName);
        if (configured == null) {
            String msg = "There is no configured chain under the name/key [" + chainName + "].";
            throw new IllegalArgumentException(msg);
        }
        return configured.proxy(original);
    }

    protected void initFilter(Filter filter) {
        FilterConfig filterConfig = this.getFilterConfig();
        if (filterConfig == null) {
            throw new IllegalStateException("FilterConfig attribute has not been set.  This must occur before filter initialization can occur.");
        }
        try {
            filter.init(filterConfig);
        }
        catch (ServletException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void addDefaultFilters(boolean init) {
        for (DefaultFilter defaultFilter : DefaultFilter.values()) {
            this.addFilter(defaultFilter.name(), defaultFilter.newInstance(), init, false);
        }
    }
}

