/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging,
SQLConfHelper {
    public static final JdbcUtils$ MODULE$ = new JdbcUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean tableExists(Connection conn, JdbcOptionsInWrite options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ResultSet resultSet;
            try (PreparedStatement statement = conn.prepareStatement(dialect.getTableExistsQuery(options.table()));){
                statement.setQueryTimeout(options.queryTimeout());
                resultSet = statement.executeQuery();
            }
            return resultSet;
        }).isSuccess();
    }

    public void dropTable(Connection conn, String table, JDBCOptions options) {
        this.executeStatement(conn, options, new java.lang.StringBuilder(11).append("DROP TABLE ").append(table).toString());
    }

    public void truncateTable(Connection conn, JdbcOptionsInWrite options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            String truncateQuery = options.isCascadeTruncate().isDefined() ? dialect.getTruncateQuery(options.table(), options.isCascadeTruncate()) : dialect.getTruncateQuery(options.table());
            statement.executeUpdate(truncateQuery);
        }
    }

    public Option<Object> isCascadingTruncateTable(String url) {
        return JdbcDialects$.MODULE$.get(url).isCascadingTruncateTable();
    }

    public String getInsertStatement(String table, StructType rddSchema, Option<StructType> tableSchema, boolean isCaseSensitive, JdbcDialect dialect) {
        String string;
        if (tableSchema.isEmpty()) {
            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()), (Function1 & Serializable)x -> dialect.quoteIdentifier(x.name()), ClassTag$.MODULE$.apply(String.class))).mkString(",");
        } else {
            String[] tableColumnNames = ((StructType)tableSchema.get()).fieldNames();
            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()), (Function1 & Serializable)col -> {
                String normalizedName = (String)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])tableColumnNames), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$getInsertStatement$3(col, f))).getOrElse((Function0 & Serializable)() -> {
                    throw QueryCompilationErrors$.MODULE$.columnNotFoundInSchemaError(col, tableSchema);
                });
                return dialect.quoteIdentifier(normalizedName);
            }, ClassTag$.MODULE$.apply(String.class))).mkString(",");
        }
        String columns = string;
        String placeholders = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()), (Function1 & Serializable)x$1 -> "?", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return new java.lang.StringBuilder(25).append("INSERT INTO ").append(table).append(" (").append(columns).append(") VALUES (").append(placeholders).append(")").toString();
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        Option option;
        DataType dataType = dt;
        if (IntegerType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
        } else if (StringType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        } else if (DateType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            option = Option$.MODULE$.apply((Object)new JdbcType(new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 3));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public JdbcType getJdbcType(DataType dt, JdbcDialect dialect) {
        return (JdbcType)dialect.getJDBCType(dt).orElse((Function0 & Serializable)() -> MODULE$.getCommonJDBCType(dt)).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.cannotGetJdbcTypeError(dt);
        });
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                binaryType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(20, 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                binaryType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                binaryType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2012: {
                binaryType$ = null;
                break;
            }
            case -8: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case 2013: {
                binaryType$ = null;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case 2014: {
                binaryType$ = null;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                throw QueryExecutionErrors$.MODULE$.unrecognizedSqlTypeError(sqlType);
            }
        }
        BinaryType$ answer = binaryType$;
        if (answer == null) {
            throw QueryExecutionErrors$.MODULE$.unsupportedJdbcTypeError(JDBCType.valueOf(sqlType).getName());
        }
        return answer;
    }

    public Option<StructType> getSchemaOption(Connection conn, JDBCOptions options) {
        None$ none$;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (PreparedStatement statement = conn.prepareStatement(dialect.getSchemaQuery(options.tableOrQuery()));){
            try {
                statement.setQueryTimeout(options.queryTimeout());
                none$ = new Some((Object)this.getSchema(statement.executeQuery(), dialect, this.getSchema$default$3()));
            }
            catch (SQLException sQLException) {
                none$ = None$.MODULE$;
            }
        }
        catch (SQLException sQLException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public StructType getSchema(ResultSet resultSet, JdbcDialect dialect, boolean alwaysNullable) {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            boolean isSigned;
            boolean bl;
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            String typeName = rsmd.getColumnTypeName(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            try {
                bl = rsmd.isSigned(i + 1);
            }
            catch (Throwable throwable) {
                block10: {
                    block9: {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof SQLException)) break block9;
                        SQLException sQLException = (SQLException)throwable2;
                        String string = sQLException.getMessage();
                        String string2 = "Method not supported";
                        if (string != null ? !string.equals(string2) : string2 != null) break block9;
                        String string3 = rsmd.getClass().getName();
                        String string4 = "org.apache.hive.jdbc.HiveResultSetMetaData";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) break block10;
                    }
                    throw throwable;
                }
                boolean bl2 = true;
                bl = isSigned = bl2;
            }
            boolean nullable = alwaysNullable ? true : rsmd.isNullable(i + 1) != 0;
            MetadataBuilder metadata = new MetadataBuilder();
            metadata.putLong("scale", (long)fieldScale);
            int n = dataType;
            switch (n) {
                case 92: {
                    BoxedUnit boxedUnit = metadata.putBoolean("logical_time_type", true);
                    break;
                }
                case -8: {
                    BoxedUnit boxedUnit = metadata.putBoolean("rowid", true);
                    break;
                }
                default: {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
            }
            DataType columnType = (DataType)dialect.getCatalystType(dataType, typeName, fieldSize, metadata).getOrElse((Function0 & Serializable)() -> MODULE$.getCatalystType(dataType, fieldSize, fieldScale, isSigned));
            fields[i] = new StructField(columnName, columnType, nullable, metadata.build());
        }
        return new StructType(fields);
    }

    public boolean getSchema$default$3() {
        return false;
    }

    public Iterator<Row> resultSetToRows(ResultSet resultSet, StructType schema) {
        InputMetrics inputMetrics = (InputMetrics)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$2 -> x$2.taskMetrics().inputMetrics()).getOrElse((Function0 & Serializable)() -> new InputMetrics());
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$22 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder.Deserializer fromRow = qual$1.resolveAndBind(x$1, x$22).createDeserializer();
        Iterator<InternalRow> internalRows = this.resultSetToSparkInternalRows(resultSet, schema, inputMetrics);
        return internalRows.map((Function1)fromRow);
    }

    public Iterator<InternalRow> resultSetToSparkInternalRows(ResultSet resultSet, StructType schema, InputMetrics inputMetrics) {
        return new NextIterator<InternalRow>(resultSet, schema, inputMetrics){
            private final ResultSet rs;
            private final Function3<ResultSet, InternalRow, Object, BoxedUnit>[] getters;
            private final SpecificInternalRow mutableRow;
            private final InputMetrics inputMetrics$1;

            public void close() {
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    JdbcUtils$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception closing resultset", e);
                }
            }

            public InternalRow getNext() {
                SpecificInternalRow specificInternalRow;
                if (this.rs.next()) {
                    this.inputMetrics$1.incRecordsRead(1L);
                    for (int i = 0; i < this.getters.length; ++i) {
                        this.getters[i].apply((Object)this.rs, (Object)this.mutableRow, (Object)BoxesRunTime.boxToInteger((int)i));
                        if (!this.rs.wasNull()) continue;
                        this.mutableRow.setNullAt(i);
                    }
                    specificInternalRow = this.mutableRow;
                } else {
                    this.finished_$eq(true);
                    specificInternalRow = null;
                }
                return specificInternalRow;
            }
            {
                this.inputMetrics$1 = inputMetrics$1;
                this.rs = resultSet$1;
                this.getters = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(schema$1);
                this.mutableRow = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema$1.fields()), (Function1 & Serializable)x -> x.dataType(), ClassTag$.MODULE$.apply(DataType.class))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$1(), $anonfun$mutableRow$1(org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        };
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit>[] org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(StructType schema) {
        return (Function3[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)sf -> MODULE$.makeGetter(sf.dataType(), sf.metadata()), ClassTag$.MODULE$.apply(Function3.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function3<ResultSet, InternalRow, Object, BoxedUnit> makeGetter(DataType dt, Metadata metadata) {
        Function1 & Serializable intersect;
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        boolean bl2 = false;
        DataType dataType2 = null;
        boolean bl3 = false;
        DataType dataType3 = null;
        DataType dataType4 = dt;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setBoolean(BoxesRunTime.unboxToInt((Object)pos), rs.getBoolean(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$2(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (dataType4 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType4)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            int s = ((Tuple2)option.get())._2$mcI$sp();
            return (Function3 & Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$3(p, s, rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setDouble(BoxesRunTime.unboxToInt((Object)pos), rs.getDouble(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setFloat(BoxesRunTime.unboxToInt((Object)pos), rs.getFloat(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setInt(BoxesRunTime.unboxToInt((Object)pos), rs.getInt(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType = dataType4;
            if (metadata.contains("binarylong")) {
                return (Function3 & Serializable)(rs, row, pos) -> {
                    JdbcUtils$.$anonfun$makeGetter$8(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (bl) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setLong(BoxesRunTime.unboxToInt((Object)pos), rs.getLong(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setShort(BoxesRunTime.unboxToInt((Object)pos), rs.getShort(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.setByte(BoxesRunTime.unboxToInt((Object)pos), rs.getByte(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (StringType$.MODULE$.equals(dataType4)) {
            bl2 = true;
            dataType2 = dataType4;
            if (metadata.contains("rowid")) {
                return (Function3 & Serializable)(rs, row, pos) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)UTF8String.fromString((String)((Object)rs.getRowId(BoxesRunTime.unboxToInt((Object)pos) + 1)).toString()));
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (bl2) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)UTF8String.fromString((String)rs.getString(BoxesRunTime.unboxToInt((Object)pos) + 1)));
                return BoxedUnit.UNIT;
            };
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl3 = true;
            dataType3 = dataType4;
            if (metadata.contains("logical_time_type")) {
                return (Function3 & Serializable)(rs, row, pos) -> {
                    JdbcUtils$.$anonfun$makeGetter$14(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (bl3) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$15(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            return (Function3 & Serializable)(rs, row, pos) -> {
                row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)rs.getBytes(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (!(dataType4 instanceof ArrayType)) throw QueryExecutionErrors$.MODULE$.unsupportedJdbcTypeError(dt.catalogString());
        ArrayType arrayType = (ArrayType)dataType4;
        DataType et = arrayType.elementType();
        DataType dataType5 = et;
        if (TimestampType$.MODULE$.equals(dataType5)) {
            intersect = (Function1 & Serializable)array -> (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((Timestamp[])array)), (Function1 & Serializable)timestamp -> MODULE$.nullSafeConvert(timestamp, (Function1 & Serializable)t -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(t))), ClassTag$.MODULE$.Any());
        } else if (StringType$.MODULE$.equals(dataType5)) {
            intersect = (Function1 & Serializable)array -> (UTF8String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])array), (Function1 & Serializable)obj -> obj == null ? null : UTF8String.fromString((String)obj.toString()), ClassTag$.MODULE$.apply(UTF8String.class));
        } else if (DateType$.MODULE$.equals(dataType5)) {
            intersect = (Function1 & Serializable)array -> (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((Date[])array)), (Function1 & Serializable)date2 -> MODULE$.nullSafeConvert(date2, (Function1 & Serializable)date -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date))), ClassTag$.MODULE$.Any());
        } else if (dataType5 instanceof DecimalType) {
            DecimalType decimalType2 = (DecimalType)dataType5;
            intersect = (Function1 & Serializable)array -> (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((BigDecimal[])array)), (Function1 & Serializable)decimal -> MODULE$.nullSafeConvert(decimal, (Function1 & Serializable)d -> Decimal$.MODULE$.apply(d, decimalType2.precision(), decimalType2.scale())), ClassTag$.MODULE$.Any());
        } else {
            if (LongType$.MODULE$.equals(dataType5) && metadata.contains("binarylong")) {
                throw QueryExecutionErrors$.MODULE$.unsupportedArrayElementTypeBasedOnBinaryError(dt);
            }
            if (dataType5 instanceof ArrayType) {
                throw QueryExecutionErrors$.MODULE$.nestedArraysUnsupportedError();
            }
            intersect = (Function1 & Serializable)array -> (Object[])array;
        }
        Function1 & Serializable elementConversion = intersect;
        return (Function3 & Serializable)(rs, row, pos) -> {
            JdbcUtils$.$anonfun$makeGetter$29(elementConversion, rs, row, BoxesRunTime.unboxToInt((Object)pos));
            return BoxedUnit.UNIT;
        };
    }

    private <T> Object nullSafeConvert(T input, Function1<T, Object> f) {
        return input == null ? null : f.apply(input);
    }

    private Function3<PreparedStatement, Row, Object, BoxedUnit> makeSetter(Connection conn, JdbcDialect dialect, DataType dataType) {
        Function3 & Serializable intersect;
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getInt(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (LongType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setLong(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getLong(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setDouble(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getDouble(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setFloat(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getFloat(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getShort(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getByte(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setBoolean(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getBoolean(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (StringType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setString(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getString(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setBytes(BoxesRunTime.unboxToInt((Object)pos) + 1, (byte[])row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            intersect = this.conf().datetimeJava8ApiEnabled() ? (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setTimestamp(BoxesRunTime.unboxToInt((Object)pos) + 1, DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.instantToMicros((Instant)row.getAs(BoxesRunTime.unboxToInt((Object)pos)))));
                return BoxedUnit.UNIT;
            } : (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setTimestamp(BoxesRunTime.unboxToInt((Object)pos) + 1, (Timestamp)row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (DateType$.MODULE$.equals(dataType2)) {
            intersect = this.conf().datetimeJava8ApiEnabled() ? (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setDate(BoxesRunTime.unboxToInt((Object)pos) + 1, DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.localDateToDays((LocalDate)row.getAs(BoxesRunTime.unboxToInt((Object)pos)))));
                return BoxedUnit.UNIT;
            } : (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setDate(BoxesRunTime.unboxToInt((Object)pos) + 1, (Date)row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (dataType2 instanceof DecimalType) {
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                stmt.setBigDecimal(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getDecimal(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType et = arrayType.elementType();
            String typeName = this.getJdbcType(et, dialect).databaseTypeDefinition().toLowerCase(Locale.ROOT).split("\\(")[0];
            intersect = (Function3 & Serializable)(stmt, row, pos) -> {
                JdbcUtils$.$anonfun$makeSetter$15(conn, typeName, stmt, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = (Function3 & Serializable)(x$3, x$4, pos) -> JdbcUtils$.$anonfun$makeSetter$16(x$3, x$4, BoxesRunTime.unboxToInt((Object)pos));
        }
        return intersect;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void savePartition(String table, Iterator<Row> iterator, StructType rddSchema, String insertStmt, int batchSize, JdbcDialect dialect, int isolationLevel, JDBCOptions options) {
        if (iterator.isEmpty()) {
            return;
        }
        outMetrics = TaskContext$.MODULE$.get().taskMetrics().outputMetrics();
        conn = (Connection)dialect.createConnectionFactory(options).apply((Object)BoxesRunTime.boxToInteger((int)-1));
        committed = false;
        finalIsolationLevel = 0;
        if (isolationLevel != 0) {
            try {
                metadata = conn.getMetaData();
                if (metadata.supportsTransactions()) {
                    finalIsolationLevel = defaultIsolation = metadata.getDefaultTransactionIsolation();
                    if (metadata.supportsTransactionIsolationLevel(isolationLevel)) {
                        finalIsolationLevel = isolationLevel;
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$1(int int ), ()Ljava/lang/String;)((int)isolationLevel, (int)defaultIsolation));
                    }
                } else {
                    this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$2(int ), ()Ljava/lang/String;)((int)isolationLevel));
                }
            }
            catch (Throwable var16_15) {
                var17_16 = var16_15;
                if (var17_16 != null && !(var18_17 = NonFatal$.MODULE$.unapply(var17_16)).isEmpty()) {
                    e = (Throwable)var18_17.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$3(), ()Ljava/lang/String;)(), e);
                    var9_19 = BoxedUnit.UNIT;
                }
                throw var16_15;
            }
        }
        supportsTransactions = finalIsolationLevel != 0;
        totalRowCount = 0L;
        try {
            try {
                if (supportsTransactions) {
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(finalIsolationLevel);
                }
                stmt = conn.prepareStatement(insertStmt);
                setters = (Function3[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$savePartition$4(java.sql.Connection org.apache.spark.sql.jdbc.JdbcDialect org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lscala/Function3;)((Connection)conn, (JdbcDialect)dialect), ClassTag$.MODULE$.apply(Function3.class));
                nullTypes = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$savePartition$5$adapted(org.apache.spark.sql.jdbc.JdbcDialect org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((JdbcDialect)dialect), (ClassTag)ClassTag$.MODULE$.Int());
                numFields = rddSchema.fields().length;
                try {
                    rowCount = 0;
                    stmt.setQueryTimeout(options.queryTimeout());
                    while (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        for (i = 0; i < numFields; ++i) {
                            if (row.isNullAt(i)) {
                                stmt.setNull(i + 1, nullTypes[i]);
                                v0 = BoxedUnit.UNIT;
                                continue;
                            }
                            v0 = setters[i].apply((Object)stmt, (Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                        }
                        stmt.addBatch();
                        ++totalRowCount;
                        if (++rowCount % batchSize != 0) continue;
                        stmt.executeBatch();
                        rowCount = 0;
                    }
                    v1 = rowCount > 0 ? (Object)stmt.executeBatch() : BoxedUnit.UNIT;
                }
                finally {
                    stmt.close();
                }
                if (supportsTransactions) {
                    conn.commit();
                }
                committed = true;
            }
            catch (SQLException e) {
                cause = e.getNextException();
                if (cause == null) ** GOTO lbl-1000
                v2 = e.getCause();
                var33_32 = cause;
                if (v2 == null ? var33_32 != null : v2.equals(var33_32) == false) {
                    if (e.getCause() == null) {
                        try {
                            v3 /* !! */  = e.initCause(cause);
                        }
                        catch (IllegalStateException v4) {
                            e.addSuppressed(cause);
                            v3 /* !! */  = BoxedUnit.UNIT;
                        }
                    } else {
                        e.addSuppressed(cause);
                        v3 /* !! */  = BoxedUnit.UNIT;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    v3 /* !! */  = BoxedUnit.UNIT;
                }
                throw e;
            }
        }
        finally {
            if (!committed) {
                if (supportsTransactions) {
                    conn.rollback();
                } else {
                    outMetrics.setRecordsWritten(totalRowCount);
                }
                conn.close();
            } else {
                outMetrics.setRecordsWritten(totalRowCount);
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$6(), ()Ljava/lang/String;)(), e);
                }
            }
        }
    }

    public String schemaString(StructType schema, boolean caseSensitive, String url, Option<String> createTableColumnTypes) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        scala.collection.immutable.Map userSpecifiedColTypesMap = (scala.collection.immutable.Map)createTableColumnTypes.map((Function1 & Serializable)x$5 -> MODULE$.parseUserSpecifiedCreateTableColumnTypes(schema, caseSensitive, (String)x$5)).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            String name = dialect.quoteIdentifier(field.name());
            String typ = (String)userSpecifiedColTypesMap.getOrElse((Object)field.name(), (Function0 & Serializable)() -> MODULE$.getJdbcType(field.dataType(), dialect).databaseTypeDefinition());
            String nullable = field.nullable() ? "" : "NOT NULL";
            return sb.append(new java.lang.StringBuilder(4).append(", ").append(name).append(" ").append(typ).append(" ").append(nullable).toString());
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public Option<String> schemaString$default$4() {
        return None$.MODULE$;
    }

    private scala.collection.immutable.Map<String, String> parseUserSpecifiedCreateTableColumnTypes(StructType schema, boolean caseSensitive, String createTableColumnTypes) {
        StructType userSchema = CatalystSqlParser$.MODULE$.parseTableSchema(createTableColumnTypes);
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)userSchema.map((Function1 & Serializable)x$6 -> x$6.name()), "in the createTableColumnTypes option value", this.conf().resolver());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])userSchema.fieldNames()), (Function1 & Serializable)col -> (StructField)schema.find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$parseUserSpecifiedCreateTableColumnTypes$3(col, f))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.createTableColumnTypesOptionColumnNotFoundInSchemaError(col, schema);
        }));
        scala.collection.immutable.Map userSchemaMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])userSchema.fields()), (Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType().catalogString()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return caseSensitive ? userSchemaMap : CaseInsensitiveMap$.MODULE$.apply(userSchemaMap);
    }

    public StructType getCustomSchema(StructType tableSchema, String customSchema, Function2<String, String, Object> nameEquality) {
        StructType structType;
        if (customSchema != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(customSchema))) {
            StructType userSchema = CatalystSqlParser$.MODULE$.parseTableSchema(customSchema);
            SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication(userSchema, "in the customSchema option value", nameEquality);
            Seq newSchema = (Seq)tableSchema.map((Function1 & Serializable)col -> {
                StructField structField;
                Option option = userSchema.find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$getCustomSchema$2(nameEquality, col, f)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    StructField c = (StructField)some.value();
                    DataType x$1 = c.dataType();
                    String x$2 = col.copy$default$1();
                    boolean x$3 = col.copy$default$3();
                    Metadata x$4 = col.copy$default$4();
                    structField = col.copy(x$2, x$1, x$3, x$4);
                } else if (None$.MODULE$.equals(option)) {
                    structField = col;
                } else {
                    throw new MatchError((Object)option);
                }
                return structField;
            });
            structType = StructType$.MODULE$.apply(newSchema);
        } else {
            structType = tableSchema;
        }
        return structType;
    }

    public void saveTable(Dataset<Row> df, Option<StructType> tableSchema, boolean isCaseSensitive, JdbcOptionsInWrite options) {
        int n;
        String url = options.url();
        String table = options.table();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        StructType rddSchema = df.schema();
        int batchSize = options.batchSize();
        int isolationLevel = options.isolationLevel();
        String insertStmt = this.getInsertStatement(table, rddSchema, tableSchema, isCaseSensitive, dialect);
        boolean bl = false;
        Some some = null;
        Option<Object> option = options.numPartitions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n2 = BoxesRunTime.unboxToInt((Object)some.value());
            if (n2 <= 0) {
                throw QueryExecutionErrors$.MODULE$.invalidJdbcNumPartitionsError(n2, JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS());
            }
        }
        Dataset<Row> dataset = bl && (n = BoxesRunTime.unboxToInt((Object)some.value())) < df.rdd().getNumPartitions() ? df.coalesce(n) : df;
        Dataset<Row> repartitionedDF = dataset;
        repartitionedDF.rdd().foreachPartition((Function1 & Serializable)iterator -> {
            JdbcUtils$.MODULE$.savePartition(table, (Iterator<Row>)iterator, rddSchema, insertStmt, batchSize, dialect, isolationLevel, options);
            return BoxedUnit.UNIT;
        });
    }

    public void createTable(Connection conn, String tableName, StructType schema, boolean caseSensitive, JdbcOptionsInWrite options) {
        block2: {
            JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
            String strSchema = this.schemaString(schema, caseSensitive, options.url(), options.createTableColumnTypes());
            String createTableOptions = options.createTableOptions();
            String sql = new java.lang.StringBuilder(17).append("CREATE TABLE ").append(tableName).append(" (").append(strSchema).append(") ").append(createTableOptions).toString();
            this.executeStatement(conn, options, sql);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(options.tableComment()))) break block2;
            try {
                this.executeStatement(conn, options, dialect.getTableCommentQuery(tableName, options.tableComment()));
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot create JDBC table comment. The table comment will be ignored.");
            }
        }
    }

    public void renameTable(Connection conn, String oldTable, String newTable, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.renameTable(oldTable, newTable));
    }

    public void alterTable(Connection conn, String tableName, Seq<TableChange> changes, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        DatabaseMetaData metaData = conn.getMetaData();
        if (changes.length() == 1) {
            this.executeStatement(conn, options, dialect.alterTable(tableName, changes, metaData.getDatabaseMajorVersion())[0]);
        } else {
            if (!metaData.supportsTransactions()) {
                throw QueryExecutionErrors$.MODULE$.transactionUnsupportedByJdbcServerError();
            }
            conn.setAutoCommit(false);
            Statement statement = conn.createStatement();
            try {
                try {
                    statement.setQueryTimeout(options.queryTimeout());
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dialect.alterTable(tableName, changes, metaData.getDatabaseMajorVersion())), (Function1 & Serializable)sql -> BoxesRunTime.boxToInteger((int)statement.executeUpdate(sql)));
                    conn.commit();
                }
                catch (Exception e) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw e;
                }
            }
            finally {
                statement.close();
                conn.setAutoCommit(true);
            }
        }
    }

    public void createSchema(Connection conn, JDBCOptions options, String schema, String comment) {
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
            dialect.createSchema(statement, schema, comment);
        }
    }

    public boolean schemaExists(Connection conn, JDBCOptions options, String schema) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return dialect.schemasExists(conn, options, schema);
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return dialect.listSchemas(conn, options);
    }

    public void alterSchemaComment(Connection conn, JDBCOptions options, String schema, String comment) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.getSchemaCommentQuery(schema, comment));
    }

    public void removeSchemaComment(Connection conn, JDBCOptions options, String schema) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.removeSchemaCommentQuery(schema));
    }

    public void dropSchema(Connection conn, JDBCOptions options, String schema, boolean cascade) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.dropSchema(schema, cascade));
    }

    public void createIndex(Connection conn, String indexName, String tableName, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.createIndex(indexName, tableName, columns, columnsProperties, properties));
    }

    public boolean indexExists(Connection conn, String indexName, String tableName, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return dialect.indexExists(conn, indexName, tableName, options);
    }

    public void dropIndex(Connection conn, String indexName, String tableName, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        this.executeStatement(conn, options, dialect.dropIndex(indexName, tableName));
    }

    public TableIndex[] listIndexes(Connection conn, String tableName, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return dialect.listIndexes(conn, tableName, options);
    }

    private void executeStatement(Connection conn, JDBCOptions options, String sql) {
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            statement.executeUpdate(sql);
        }
    }

    public boolean checkIfIndexExists(Connection conn, String sql, JDBCOptions options) {
        boolean bl;
        try (Statement statement = conn.createStatement();){
            try {
                statement.setQueryTimeout(options.queryTimeout());
                ResultSet rs = statement.executeQuery(sql);
                bl = rs.next();
            }
            catch (Exception exception) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
                bl = false;
            }
        }
        return bl;
    }

    public Tuple2<String, String[]> processIndexProperties(Map<String, String> properties, String catalogName) {
        ObjectRef indexType = ObjectRef.create((Object)"");
        ArrayBuffer indexPropertyList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String[] supportedIndexTypeList = this.getSupportedIndexTypeList(catalogName);
        if (!properties.isEmpty()) {
            ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                Buffer buffer;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k.equals("type")) {
                    if (!MODULE$.containsIndexTypeIgnoreCase(supportedIndexTypeList, v)) throw new UnsupportedOperationException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(29).append("Index Type ").append(v).append(" is not supported.").toString()).append(new java.lang.StringBuilder(32).append(" The supported Index Types are: ").append(Predef$.MODULE$.wrapRefArray((Object[])supportedIndexTypeList).mkString(" AND ")).toString()).toString());
                    indexType$1.elem = new java.lang.StringBuilder(6).append("USING ").append(v).toString();
                    buffer = BoxedUnit.UNIT;
                    return buffer;
                } else {
                    buffer = indexPropertyList.append((Object)new java.lang.StringBuilder(3).append(k).append(" = ").append(v).toString());
                }
                return buffer;
            });
        }
        return new Tuple2((Object)((String)indexType.elem), indexPropertyList.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean containsIndexTypeIgnoreCase(String[] supportedIndexTypeList, String value) {
        boolean bl;
        Object object = new Object();
        try {
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])supportedIndexTypeList))) {
                throw new UnsupportedOperationException("Cannot specify 'USING index_type' in 'CREATE INDEX'");
            }
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])supportedIndexTypeList), (Function1 & Serializable)indexType -> {
                JdbcUtils$.$anonfun$containsIndexTypeIgnoreCase$1(value, object, indexType);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public String[] getSupportedIndexTypeList(String catalogName) {
        String[] stringArray;
        block4: {
            String string = catalogName;
            switch (string == null ? 0 : string.hashCode()) {
                case -2105481388: {
                    if (!"postgresql".equals(string)) break;
                    stringArray = (String[])((Object[])new String[]{"BTREE", "HASH", "BRIN"});
                    break block4;
                }
                case 104382626: {
                    if (!"mysql".equals(string)) break;
                    stringArray = (String[])((Object[])new String[]{"BTREE", "HASH"});
                    break block4;
                }
            }
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public void executeQuery(Connection conn, JDBCOptions options, String sql, Function1<ResultSet, BoxedUnit> f) {
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            try (ResultSet rs = statement.executeQuery(sql);){
                f.apply((Object)rs);
            }
        }
    }

    public <T> T classifyException(String message, JdbcDialect dialect, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable e) {
            throw dialect.classifyException(message, e);
        }
        return (T)object;
    }

    public <T> T withConnection(JDBCOptions options, Function1<Connection, T> f) {
        Object object;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (Connection conn = (Connection)dialect.createConnectionFactory(options).apply((Object)BoxesRunTime.boxToInteger((int)-1));){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$getInsertStatement$3(StructField col$1, String f) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)f, (Object)col$1.name()));
    }

    public static final /* synthetic */ void $anonfun$makeGetter$2(ResultSet rs, InternalRow row, int pos) {
        Date dateVal = rs.getDate(pos + 1);
        if (dateVal != null) {
            row.setInt(pos, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
        } else {
            row.update(pos, null);
        }
    }

    public static final /* synthetic */ void $anonfun$makeGetter$3(int p$1, int s$1, ResultSet rs, InternalRow row, int pos) {
        Object decimal = MODULE$.nullSafeConvert(rs.getBigDecimal(pos + 1), (Function1 & Serializable)d -> Decimal$.MODULE$.apply(d, p$1, s$1));
        row.update(pos, decimal);
    }

    public static final /* synthetic */ void $anonfun$makeGetter$8(ResultSet rs, InternalRow row, int pos) {
        byte[] bytes = rs.getBytes(pos + 1);
        long ans = 0L;
        for (int j = 0; j < bytes.length; ++j) {
            ans = 256L * ans + (long)(0xFF & bytes[j]);
        }
        row.setLong(pos, ans);
    }

    public static final /* synthetic */ void $anonfun$makeGetter$14(ResultSet rs, InternalRow row, int pos) {
        Time rawTime = rs.getTime(pos + 1);
        if (rawTime != null) {
            long localTimeMicro = TimeUnit.NANOSECONDS.toMicros(rawTime.toLocalTime().toNanoOfDay());
            long utcTimeMicro = DateTimeUtils$.MODULE$.toUTCTime(localTimeMicro, MODULE$.conf().sessionLocalTimeZone());
            row.setLong(pos, utcTimeMicro);
        } else {
            row.update(pos, null);
        }
    }

    public static final /* synthetic */ void $anonfun$makeGetter$15(ResultSet rs, InternalRow row, int pos) {
        Timestamp t = rs.getTimestamp(pos + 1);
        if (t != null) {
            row.setLong(pos, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
        } else {
            row.update(pos, null);
        }
    }

    public static final /* synthetic */ void $anonfun$makeGetter$29(Function1 elementConversion$1, ResultSet rs, InternalRow row, int pos) {
        Object array2 = MODULE$.nullSafeConvert(rs.getArray(pos + 1), (Function1 & Serializable)array -> new GenericArrayData(elementConversion$1.apply(array.getArray())));
        row.update(pos, array2);
    }

    public static final /* synthetic */ void $anonfun$makeSetter$15(Connection conn$2, String typeName$1, PreparedStatement stmt, Row row, int pos) {
        Array array = conn$2.createArrayOf(typeName$1, (Object[])row.getSeq(pos).toArray(ClassTag$.MODULE$.AnyRef()));
        stmt.setArray(pos + 1, array);
    }

    public static final /* synthetic */ Nothing$ $anonfun$makeSetter$16(PreparedStatement x$3, Row x$4, int pos) {
        throw QueryExecutionErrors$.MODULE$.cannotTranslateNonNullValueForFieldError(pos);
    }

    public static final /* synthetic */ String $anonfun$savePartition$1(int isolationLevel$1, int defaultIsolation$1) {
        return new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(45).append("Requested isolation level ").append(isolationLevel$1).append(" is not supported; ").toString()).append(new java.lang.StringBuilder(40).append("falling back to default isolation level ").append(defaultIsolation$1).toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$savePartition$2(int isolationLevel$1) {
        return new java.lang.StringBuilder(60).append("Requested isolation level ").append(isolationLevel$1).append(", but transactions are unsupported").toString();
    }

    public static final /* synthetic */ String $anonfun$savePartition$3() {
        return "Exception while detecting transaction support";
    }

    public static final /* synthetic */ Function3 $anonfun$savePartition$4(Connection conn$3, JdbcDialect dialect$3, StructField f) {
        return MODULE$.makeSetter(conn$3, dialect$3, f.dataType());
    }

    public static final /* synthetic */ int $anonfun$savePartition$5(JdbcDialect dialect$3, StructField f) {
        return MODULE$.getJdbcType(f.dataType(), dialect$3).jdbcNullType();
    }

    public static final /* synthetic */ String $anonfun$savePartition$6() {
        return "Transaction succeeded, but closing failed";
    }

    public static final /* synthetic */ boolean $anonfun$parseUserSpecifiedCreateTableColumnTypes$3(String col$2, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)f.name(), (Object)col$2));
    }

    public static final /* synthetic */ boolean $anonfun$getCustomSchema$2(Function2 nameEquality$1, StructField col$3, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$3.name()));
    }

    public static final /* synthetic */ void $anonfun$containsIndexTypeIgnoreCase$1(String value$1, Object nonLocalReturnKey1$1, String indexType) {
        if (value$1.equalsIgnoreCase(indexType)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    private JdbcUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$savePartition$5$adapted(JdbcDialect dialect$3, StructField f) {
        return BoxesRunTime.boxToInteger((int)JdbcUtils$.$anonfun$savePartition$5(dialect$3, f));
    }
}

