/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B\u0013'\u0001EB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"1\u0011\n\u0001C\u0001Q)C\u0001b\u0014\u0001C\u0002\u0013\u0005\u0001\u0006\u0015\u0005\u00075\u0002\u0001\u000b\u0011B)\t\u000fm\u0003!\u0019!C\u00059\"1\u0011\r\u0001Q\u0001\nuCqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004x\u0001\u0001\u0006I\u0001\u001a\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"a\u0007\u0001A\u0003%\u0011q\u0002\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"a\b\u0001A\u0003%\u0011q\u0002\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003GA\u0011\"!\r\u0001\u0001\u0004%I!a\r\t\u0011\u0005}\u0002\u0001)Q\u0005\u0003KAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005=\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA9\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003#\u0004A\u0011AA:\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002h\u0002!\t!!;\t\u0011\u00055\b\u0001\"\u0001)\u0003_DqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0005\u0003\u0018\u0002\t\n\u0011\"\u0003\u0003\u001a\"A!Q\u0016\u0001\u0005\u0002!\u0012y\u000b\u0003\u0006\u0003`\u0002\t\n\u0011\"\u0001)\u0005CD!B!:\u0001#\u0003%\t\u0001\u000bBq\u0011)\u00119\u000fAI\u0001\n\u0003A#\u0011\u001e\u0005\u000b\u0005[\u0004\u0011\u0013!C\u0001Q\t=\bB\u0003Bz\u0001E\u0005I\u0011\u0001\u0015\u0003\u001a\"A!Q\u001f\u0001\u0005\u0002!\u00129\u0010C\u0004\u0003~\u0002!IAa@\u0003+M#(/Z1nS:<\u0017+^3ss6\u000bg.Y4fe*\u0011q\u0005K\u0001\ngR\u0014X-Y7j]\u001eT!!\u000b\u0016\u0002\u0007M\fHN\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u001a9!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019\te.\u001f*fMB\u0011\u0011\bP\u0007\u0002u)\u00111HK\u0001\tS:$XM\u001d8bY&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u0001\u0015)D\u0001)\u0013\t\u0011\u0005F\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0004tc2\u001cuN\u001c4\u0011\u0005\u0015;U\"\u0001$\u000b\u0005mB\u0013B\u0001%G\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\fa\u0001P5oSRtDcA&N\u001dB\u0011A\nA\u0007\u0002M!)ah\u0001a\u0001\u007f!)1i\u0001a\u0001\t\u0006)2\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014X#A)\u0011\u0005ICV\"A*\u000b\u0005Q+\u0016!B:uCR,'BA\u0014W\u0015\t9\u0006&A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0011l\u0015\u0002\u0019'R\fG/Z*u_J,7i\\8sI&t\u0017\r^8s%\u00164\u0017AF:uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002;B\u0011alX\u0007\u0002+&\u0011\u0001-\u0016\u0002\u001a'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\n+8/\u0001\u0007mSN$XM\\3s\u0005V\u001c\b%A\u0007bGRLg/Z)vKJLWm]\u000b\u0002IB!QM\u001b7u\u001b\u00051'BA4i\u0003\u001diW\u000f^1cY\u0016T!!\u001b\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lM\n9\u0001*Y:i\u001b\u0006\u0004\bCA7s\u001b\u0005q'BA8q\u0003\u0011)H/\u001b7\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u0005+VKE\t\u0005\u0002Mk&\u0011aO\n\u0002\u000f'R\u0014X-Y7j]\u001e\fV/\u001a:z\u00039\t7\r^5wKF+XM]5fg\u0002Bc!C=\u0002\b\u0005%\u0001c\u0001>\u0002\u00045\t1P\u0003\u0002}{\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005y|\u0018AC1o]>$\u0018\r^5p]*\u0011\u0011\u0011A\u0001\u0006U\u00064\u0018\r_\u0005\u0004\u0003\u000bY(!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\tY!A\fbGRLg/Z)vKJLWm]*iCJ,G\rT8dWV\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u00039\u0002\t1\fgnZ\u0005\u0005\u00033\t\u0019B\u0001\u0004PE*,7\r^\u0001\u0019C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:TQ\u0006\u0014X\r\u001a'pG.\u0004\u0013\u0001F1xC&$H+\u001a:nS:\fG/[8o\u0019>\u001c7.A\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m\u001b\u0011\u000291\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]V\u0011\u0011Q\u0005\t\u0006g\u0005\u001d\u00121F\u0005\u0004\u0003S!$AB(qi&|g\u000eE\u0002M\u0003[I1!a\f'\u0005]\u0019FO]3b[&tw-U;fef,\u0005pY3qi&|g.\u0001\u0011mCN$H+\u001a:nS:\fG/\u001a3Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c8`I\u0015\fH\u0003BA\u001b\u0003w\u00012aMA\u001c\u0013\r\tI\u0004\u000e\u0002\u0005+:LG\u000fC\u0005\u0002>=\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002;1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]\u0002Bc\u0001E=\u0002\b\u0005\r\u0013EAA\u000f\u0003\u0019\t7\r^5wKV\u0011\u0011\u0011\n\t\u0005g\u0005-C/C\u0002\u0002NQ\u0012Q!\u0011:sCf\f1aZ3u)\r!\u00181\u000b\u0005\u0007\u0003+\u0012\u0002\u0019\u00017\u0002\u0005%$Gc\u0001;\u0002Z!9\u0011QK\nA\u0002\u0005m\u0003\u0003BA/\u0003WrA!a\u0018\u0002hA\u0019\u0011\u0011\r\u001b\u000e\u0005\u0005\r$bAA3a\u00051AH]8pizJ1!!\u001b5\u0003\u0019\u0001&/\u001a3fM&!\u0011QNA8\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u000e\u001b\u0002'\u0005<\u0018-\u001b;B]f$VM]7j]\u0006$\u0018n\u001c8\u0015\u0005\u0005U\u0002&\u0002\u000b\u0002x\u0005u\u0004#B\u001a\u0002z\u0005-\u0012bAA>i\t1A\u000f\u001b:poN\ftAHA.\u0003\u007f\n\t,M\u0005$\u0003\u0003\u000bI)a*\u0002\fV!\u00111QAC+\t\tY\u0006B\u0004\u0002\bB\u0012\r!!%\u0003\u0003QKA!a#\u0002\u000e\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!a$5\u0003\u0019!\bN]8xgF!\u00111SAM!\r\u0019\u0014QS\u0005\u0004\u0003/#$a\u0002(pi\"Lgn\u001a\t\u0005\u00037\u000b\tKD\u00024\u0003;K1!a(5\u0003\u001d\u0001\u0018mY6bO\u0016LA!a)\u0002&\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003?#\u0014'C\u0012\u0002*\u0006-\u0016QVAH\u001d\r\u0019\u00141V\u0005\u0004\u0003\u001f#\u0014'\u0002\u00124i\u0005=&!B:dC2\f\u0017g\u0001\u0014\u0002,Q!\u0011QWA^!\r\u0019\u0014qW\u0005\u0004\u0003s#$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003{+\u0002\u0019AA`\u0003%!\u0018.\\3pkRl5\u000fE\u00024\u0003\u0003L1!a15\u0005\u0011auN\\4)\u000bU\t9(a22\u000fy\tY&!3\u0002PFJ1%!!\u0002\n\u0006-\u00171R\u0019\nG\u0005%\u00161VAg\u0003\u001f\u000bTAI\u001a5\u0003_\u000b4AJA\u0016\u0003=\u0011Xm]3u)\u0016\u0014X.\u001b8bi\u0016$\u0017aC1eI2K7\u000f^3oKJ$B!!\u000e\u0002X\"9\u0011\u0011\\\fA\u0002\u0005m\u0017\u0001\u00037jgR,g.\u001a:\u0011\u00071\u000bi.C\u0002\u0002`\u001a\u0012ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\u0011\t)$!:\t\u000f\u0005e\u0007\u00041\u0001\u0002\\\u0006iA.[:u\u0019&\u001cH/\u001a8feN$\"!a;\u0011\u000bM\nY%a7\u0002#A|7\u000f\u001e'jgR,g.\u001a:Fm\u0016tG\u000f\u0006\u0003\u00026\u0005E\bbBAz5\u0001\u0007\u0011Q_\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003o\fiPD\u0002M\u0003sL1!a?'\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BA\u0000\u0005\u0003\u0011Q!\u0012<f]RT1!a?'\u0003-\u0019'/Z1uKF+XM]=\u00151\t\u001d!Q\u0002B\n\u0005/\u00119D!\u0011\u0003V\t}#1\rB4\u0005c\u0012y\bE\u0002_\u0005\u0013I1Aa\u0003V\u0005U\u0019FO]3b[&tw-U;fef<&/\u00199qKJDqAa\u0004\u001c\u0001\u0004\u0011\t\"A\tvg\u0016\u00148\u000b]3dS\u001aLW\r\u001a(b[\u0016\u0004RaMA\u0014\u00037BqA!\u0006\u001c\u0001\u0004\u0011\t\"A\u0010vg\u0016\u00148\u000b]3dS\u001aLW\rZ\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqA!\u0007\u001c\u0001\u0004\u0011Y\"\u0001\u0002eMB!!Q\u0004B\u0019\u001d\u0011\u0011yBa\f\u000f\t\t\u0005\"Q\u0006\b\u0005\u0005G\u0011YC\u0004\u0003\u0003&\t%b\u0002BA1\u0005OI\u0011aL\u0005\u0003[9J!a\u000b\u0017\n\u0005%R\u0013bAAPQ%!!1\u0007B\u001b\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002 \"BqA!\u000f\u001c\u0001\u0004\u0011Y$\u0001\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\u0005\u0005\u0002^\tu\u00121LA.\u0013\u0011\u0011y$a\u001c\u0003\u00075\u000b\u0007\u000fC\u0004\u0003Dm\u0001\rA!\u0012\u0002\tMLgn\u001b\t\u0005\u0005\u000f\u0012\t&\u0004\u0002\u0003J)!!1\nB'\u0003\u001d\u0019\u0017\r^1m_\u001eT1Aa\u0014)\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0003T\t%#!\u0002+bE2,\u0007b\u0002B,7\u0001\u0007!\u0011L\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007c\u0001'\u0003\\%\u0019!Q\f\u0014\u0003\u0015=+H\u000f];u\u001b>$W\rC\u0004\u0003bm\u0001\r!!.\u00023U\u001cX\rV3na\u000eCWmY6q_&tG\u000fT8dCRLwN\u001c\u0005\b\u0005KZ\u0002\u0019AA[\u0003u\u0011XmY8wKJ4%o\\7DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007b\u0002B57\u0001\u0007!1N\u0001\biJLwmZ3s!\ra%QN\u0005\u0004\u0005_2#a\u0002+sS\u001e<WM\u001d\u0005\b\u0005gZ\u0002\u0019\u0001B;\u00031!(/[4hKJ\u001cEn\\2l!\u0011\u00119Ha\u001f\u000e\u0005\te$BA8+\u0013\u0011\u0011iH!\u001f\u0003\u000b\rcwnY6\t\u0013\t\u00055\u0004%AA\u0002\t\r\u0015aD2bi\u0006dwnZ!oI&#WM\u001c;\u0011\u000bM\n9C!\"\u0011\u000fM\u00129Ia#\u0003\u0012&\u0019!\u0011\u0012\u001b\u0003\rQ+\b\u000f\\33!\u0011\u00119E!$\n\t\t=%\u0011\n\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0005\u0005\u000f\u0012\u0019*\u0003\u0003\u0003\u0016\n%#AC%eK:$\u0018NZ5fe\u000612M]3bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0002\u0003\u001c*\"!1\u0011BOW\t\u0011y\n\u0005\u0003\u0003\"\n%VB\u0001BR\u0015\u0011\u0011)Ka*\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@5\u0013\u0011\u0011YKa)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006ti\u0006\u0014H/U;fef$r\u0003\u001eBY\u0005g\u0013)La.\u0003:\nm&Q\u0018B`\u0005\u0003\u0014\u0019M!2\t\u000f\t=Q\u00041\u0001\u0003\u0012!9!QC\u000fA\u0002\tE\u0001b\u0002B\r;\u0001\u0007!1\u0004\u0005\b\u0005si\u0002\u0019\u0001B\u001e\u0011\u001d\u0011\u0019%\ba\u0001\u0005\u000bBqAa\u0016\u001e\u0001\u0004\u0011I\u0006C\u0005\u0003bu\u0001\n\u00111\u0001\u00026\"I!QM\u000f\u0011\u0002\u0003\u0007\u0011Q\u0017\u0005\n\u0005Sj\u0002\u0013!a\u0001\u0005WB\u0011Ba\u001d\u001e!\u0003\u0005\rA!\u001e\t\u0013\t\u0005U\u0004%AA\u0002\t\r\u0005&B\u000f\u0003J\nU\u0007#B\u001a\u0002z\t-\u0007\u0003\u0002Bg\u0005#l!Aa4\u000b\u0005qt\u0017\u0002\u0002Bj\u0005\u001f\u0014\u0001\u0003V5nK>,H/\u0012=dKB$\u0018n\u001c82\u000fy\tYFa6\u0003^FJ1%!!\u0002\n\ne\u00171R\u0019\nG\u0005%\u00161\u0016Bn\u0003\u001f\u000bTAI\u001a5\u0003_\u000b4A\nBf\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u001d\u0016\u0005\u0003k\u0013i*\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H\u0005O\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t-(\u0006\u0002B6\u0005;\u000bQc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0003r*\"!Q\u000fBO\u0003U\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%cE\naC\\8uS\u001aL\u0018+^3ssR+'/\\5oCRLwN\u001c\u000b\u0005\u0003k\u0011I\u0010\u0003\u0004\u0003|\u000e\u0002\r\u0001^\u0001\u0010i\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0006QRO\u001c:fO&\u001cH/\u001a:UKJl\u0017N\\1uK\u0012\u001cFO]3b[R!\u0011QGB\u0001\u0011\u0019\u0011Y\u0010\na\u0001i\"\u001a\u0001a!\u0002\u0011\t\r\u001d11B\u0007\u0003\u0007\u0013Q!A \u0016\n\t\r51\u0011\u0002\u0002\t\u000bZ|GN^5oO\u0002")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final SQLConf sqlConf;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent) {
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger instanceof ContinuousTrigger, analyzedPlan, catalogAndIdent);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(tuple2._1() instanceof SupportsWrite)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException(new StringBuilder(25).append(new StringBuilder(61).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").toString()).append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active. You may stop the old query by setting the SQL ").append("configuration: ").append(new StringBuilder(25).append("spark.conf.set(\"").append(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key()).append("\", true) ").toString()).append("and retry.").toString());
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(40).append("Stopping existing streaming query [id=").append(query.id()).append(", ").toString()).append(new StringBuilder(39).append("runId=").append(oldQuery.runId()).append("], as a new run is being started.").toString()).toString());
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq(terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            HashMap cfr_ignored_0 = (HashMap)this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(41).append("Cannot start query with name ").append(name).append(" as a query ").toString()).append("with that name is already active in this SparkSession").toString());
        }
    }

    public StreamingQueryManager(SparkSession sparkSession, SQLConf sqlConf) {
        this.sparkSession = sparkSession;
        this.sqlConf = sqlConf;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQueryException = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable)classNames -> {
                SQLConf$.MODULE$.withExistingConf(this.sqlConf, (Function0)(JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable)listener -> {
                    StreamingQueryManager.$anonfun$new$3($this, listener);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

