/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import java.util.Map;
import javax.naming.NamingException;
import org.apache.sshd.server.auth.LdapAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;

public class LdapPasswordAuthenticator
extends LdapAuthenticator
implements PasswordAuthenticator {
    public static final String DEFAULT_PASSWORD_ATTR_NAME = "userPassword";
    public static final String DEFAULT_SEARCH_FILTER_PATTERN = "(&(uid={0})(userPassword={1}))";

    public LdapPasswordAuthenticator() {
        this.setRetrievedAttributes(null);
        this.setSearchFilterPattern(DEFAULT_SEARCH_FILTER_PATTERN);
    }

    public boolean authenticate(String username, String password, ServerSession session) throws PasswordChangeRequiredException {
        try {
            Map<String, Object> attrs = this.resolveAttributes(username, password, session);
            return this.authenticate(username, password, session, attrs);
        }
        catch (RuntimeException | NamingException e) {
            this.log.warn("authenticate({}@{}) failed ({}) to query: {}", new Object[]{username, session, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + "@" + session + ") query failure details", (Throwable)e);
            }
            return false;
        }
    }

    protected boolean authenticate(String username, String password, ServerSession session, Map<String, ?> attrs) {
        return true;
    }
}

