/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.emulator.core.AbstractEmulatorContext;
import org.apache.synapse.commons.emulator.core.EmulatorType;
import org.apache.synapse.commons.emulator.http.HTTPProtocolEmulator;

public class Emulator
extends Thread {
    private static final Log log = LogFactory.getLog(Emulator.class);
    private HTTPProtocolEmulator httpProtocolEmulator = new HTTPProtocolEmulator(this);
    private EmulatorType emulatorType;

    public HTTPProtocolEmulator getHttpProtocolEmulator() {
        return this.httpProtocolEmulator;
    }

    @Override
    public void run() {
        try {
            if (EmulatorType.HTTP_CONSUMER.equals((Object)this.emulatorType)) {
                this.validateInput(this.httpProtocolEmulator.getConsumerContext());
                this.httpProtocolEmulator.getHttpEmulatorConsumerInitializer().initialize();
            } else if (EmulatorType.HTTP_PRODUCER.equals((Object)this.emulatorType)) {
                this.validateInput(this.httpProtocolEmulator.getHttpProducerContext());
                this.httpProtocolEmulator.getHttpEmulatorProducerInitializer().initialize();
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while initialize the Emulator", (Throwable)e);
        }
    }

    public void shutdown(EmulatorType emulatorType) {
        if (EmulatorType.HTTP_CONSUMER.equals((Object)emulatorType)) {
            this.httpProtocolEmulator.getHttpEmulatorConsumerInitializer().shutdown();
        } else if (EmulatorType.HTTP_PRODUCER.equals((Object)emulatorType)) {
            this.httpProtocolEmulator.getHttpEmulatorProducerInitializer().shutdown();
        }
        log.info((Object)"Emulator shutdown successfully.......");
    }

    private void validateInput(AbstractEmulatorContext abstractEmulatorContext) {
        if (abstractEmulatorContext.getHost() == null || abstractEmulatorContext.getPort() == null) {
            log.error((Object)("Invalid host [" + abstractEmulatorContext.getHost() + "] and port [" + abstractEmulatorContext.getPort() + "]"));
        }
    }

    void setEmulatorType(EmulatorType emulatorType) {
        this.emulatorType = emulatorType;
    }
}

