/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.consumer;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.util.Map;
import org.apache.synapse.commons.emulator.http.consumer.HttpRequestContext;

public class HttpRequestInformationProcessor {
    public void process(HttpRequest request, HttpRequestContext requestContext) {
        this.populateRequestHeaders(request, requestContext);
        this.populateQueryParameters(request, requestContext);
        this.populateRequestContext(request, requestContext);
        this.populateHttpMethod(request, requestContext);
        this.populateHttpVersion(request, requestContext);
        this.populateConnectionKeepAlive(request, requestContext);
    }

    private void populateRequestHeaders(HttpRequest request, HttpRequestContext requestContext) {
        HttpHeaders headers = request.headers();
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entries()) {
                requestContext.addHeaderParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    void appendDecoderResult(HttpRequestContext requestContext, HttpObject httpObject, ByteBuf content) {
        requestContext.appendResponseContent(content.toString(CharsetUtil.UTF_8));
        DecoderResult result = httpObject.getDecoderResult();
        if (result.isSuccess()) {
            return;
        }
        requestContext.appendResponseContent(result.cause());
    }

    private void populateQueryParameters(HttpRequest request, HttpRequestContext requestContext) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
        Map params = queryStringDecoder.parameters();
        requestContext.setQueryParameters(params);
    }

    private void populateRequestContext(HttpRequest request, HttpRequestContext requestContext) {
        requestContext.setUri(request.getUri());
    }

    private void populateHttpMethod(HttpRequest request, HttpRequestContext requestContext) {
        requestContext.setHttpMethod(request.getMethod());
    }

    private void populateHttpVersion(HttpRequest request, HttpRequestContext requestContext) {
        requestContext.setHttpVersion(request.getProtocolVersion());
    }

    private void populateConnectionKeepAlive(HttpRequest request, HttpRequestContext requestContext) {
        requestContext.setKeepAlive(HttpHeaders.isKeepAlive((HttpMessage)request));
    }
}

