/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.producer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import org.apache.synapse.commons.emulator.http.dsl.dto.producer.OutgoingMessage;
import org.apache.synapse.commons.emulator.http.producer.HttpResponseAssertProcessor;
import org.apache.synapse.commons.emulator.http.producer.HttpResponseContext;
import org.apache.synapse.commons.emulator.http.producer.HttpResponseInformationProcessor;

public class HttpResponseProcessHandler
extends ChannelInboundHandlerAdapter {
    private HttpResponseContext responseContext;
    private HttpResponseInformationProcessor responseInformationProcessor;
    private HttpResponseAssertProcessor responseAssertProcessor;
    private OutgoingMessage outgoingMessage;

    public HttpResponseProcessHandler(OutgoingMessage outgoingMessage) {
        this.outgoingMessage = outgoingMessage;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            this.responseContext = new HttpResponseContext();
            this.responseInformationProcessor = new HttpResponseInformationProcessor();
            this.responseAssertProcessor = new HttpResponseAssertProcessor();
            HttpResponse response = (HttpResponse)msg;
            this.responseInformationProcessor.process(response, this.responseContext);
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                this.responseInformationProcessor.appendDecoderResult(this.responseContext, (HttpObject)httpContent, content);
            }
            if (content instanceof LastHttpContent) {
                ctx.fireChannelReadComplete();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.responseAssertProcessor != null) {
            this.responseAssertProcessor.process(this.responseContext, this.outgoingMessage);
        }
        ctx.close();
    }
}

