/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class XmlReaderDelegate
extends StreamReaderDelegate {
    private static final Log logger = LogFactory.getLog((String)XmlReaderDelegate.class.getName());
    private boolean processNCNames;

    public XmlReaderDelegate(XMLStreamReader reader, boolean processNCNames) {
        super(reader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#XmlReaderDelegate. Setting XMLStreamReader: " + reader.getClass().getName()));
        }
        this.processNCNames = processNCNames;
    }

    @Override
    public String getLocalName() {
        String localName;
        String newName = localName = super.getLocalName();
        if (localName == null || "".equals(localName)) {
            return localName;
        }
        boolean checked = false;
        if (localName.charAt(0) == '_') {
            if (localName.startsWith("_JsonReader_PD_")) {
                String subStr = localName.substring("_JsonReader_PD_".length(), localName.length());
                if (this.processNCNames) {
                    newName = this.toOrigJsonKey(subStr);
                    checked = true;
                } else {
                    newName = subStr;
                }
            } else if (localName.startsWith("_JsonReader_PS_")) {
                String subStr = localName.substring("_JsonReader_PS_".length(), localName.length());
                if (this.processNCNames) {
                    newName = '$' + this.toOrigJsonKey(subStr);
                    checked = true;
                } else {
                    newName = '$' + subStr;
                }
            }
        }
        if (!checked && this.processNCNames) {
            newName = this.toOrigJsonKey(newName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#getLocalName. old=" + localName + ", new=" + newName));
        }
        return newName;
    }

    @Override
    public QName getName() {
        String newNameP;
        QName qName = super.getName();
        String localName = qName.getLocalPart();
        QName newName = qName;
        if (localName == null || "".equals(localName)) {
            return qName;
        }
        boolean checked = false;
        if (localName.charAt(0) == '_') {
            if (localName.startsWith("_JsonReader_PD_")) {
                String subStr = localName.substring("_JsonReader_PD_".length(), localName.length());
                if (this.processNCNames) {
                    localName = this.toOrigJsonKey(subStr);
                    checked = true;
                } else {
                    localName = subStr;
                }
                newName = new QName(qName.getNamespaceURI(), localName, qName.getPrefix());
            } else if (localName.startsWith("_JsonReader_PS_")) {
                String subStr = localName.substring("_JsonReader_PS_".length(), localName.length());
                if (this.processNCNames) {
                    localName = '$' + this.toOrigJsonKey(subStr);
                    checked = true;
                } else {
                    localName = '$' + subStr;
                }
                newName = new QName(qName.getNamespaceURI(), localName, qName.getPrefix());
            }
        }
        if (!checked && this.processNCNames && !localName.equals(newNameP = this.toOrigJsonKey(localName))) {
            newName = new QName(qName.getNamespaceURI(), newNameP, qName.getPrefix());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#getName. old=" + localName + ", new=" + newName.getLocalPart()));
        }
        return newName;
    }

    private String toOrigJsonKey(String src) {
        int indexN = 0;
        int indexO = 0;
        int length = "_JsonReader_".length();
        StringBuilder newStr = new StringBuilder(src.length());
        int[] index = new int[1];
        while (indexN < src.length()) {
            indexN = src.indexOf("_JsonReader_", indexO);
            if (indexN == -1) {
                if (indexO == 0) {
                    return src;
                }
                XmlReaderDelegate.copyChars(src, indexO, src.length(), newStr);
                break;
            }
            XmlReaderDelegate.copyChars(src, indexO, indexN, newStr);
            index[0] = indexO = indexN + length;
            int character = XmlReaderDelegate.readInt(src, index);
            if (character != -1) {
                newStr.append((char)character);
                indexO = index[0] + 1;
                continue;
            }
            XmlReaderDelegate.copyChars(src, indexO - length, indexO, newStr);
        }
        return newStr.toString();
    }

    private static void copyChars(String src, int low, int high, StringBuilder newStr) {
        for (int i = low; i < high; ++i) {
            newStr.append(src.charAt(i));
        }
    }

    private static int readInt(String s, int[] index) {
        int value = 0;
        int l = s.length();
        while (index[0] < l && index[0] != -1 && s.charAt(index[0]) != '_') {
            int n = index[0];
            index[0] = n + 1;
            int n2 = s.charAt(n) - 48;
            int n3 = n2 = n2 >= 0 && n2 <= 9 ? n2 : -1;
            if (n2 == -1) {
                return -1;
            }
            value = value * 10 + n2;
        }
        if (value <= 0) {
            return -1;
        }
        return value;
    }
}

