/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.validators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.synapse.commons.json.jsonprocessor.constants.ValidatorConstants;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.DataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.GSONDataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;
import org.apache.synapse.commons.json.jsonprocessor.validators.ArrayValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.BooleanValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NullValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NumericValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.StringValidator;

public class ObjectValidator {
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String MAX_PROPERTIES = "maxProperties";
    private static final String MIN_PROPERTIES = "minProperties";
    private static final String PATTERN_PROPERTIES = "patternProperties";
    private static final String REQUIRED = "required";

    private ObjectValidator() {
    }

    public static JsonObject validateObject(JsonObject object, JsonObject schema) throws ParserException, ValidatorException {
        String maxPropertiesString;
        String minPropertiesString;
        int minimumProperties = -1;
        int maximumProperties = -1;
        if (schema.has(REQUIRED)) {
            JsonArray requiredArray = schema.getAsJsonArray(REQUIRED);
            for (JsonElement element : requiredArray) {
                if (object.has(element.getAsString())) continue;
                throw new ValidatorException("Input object : " + object.toString() + " does not contains all the elements required in the schema : " + schema.toString());
            }
        }
        if (schema.has(MIN_PROPERTIES) && !(minPropertiesString = JsonProcessorUtils.replaceEnclosingQuotes(schema.get(MIN_PROPERTIES).getAsString())).isEmpty()) {
            minimumProperties = DataTypeConverter.convertToInt(minPropertiesString);
        }
        if (schema.has(MAX_PROPERTIES) && !(maxPropertiesString = JsonProcessorUtils.replaceEnclosingQuotes(schema.get(MAX_PROPERTIES).getAsString())).isEmpty()) {
            maximumProperties = DataTypeConverter.convertToInt(maxPropertiesString);
        }
        JsonObject schemaObject = null;
        if (schema.has("properties")) {
            schemaObject = (JsonObject)schema.get("properties");
        }
        Set entryInput = object.entrySet();
        ObjectValidator.doStructuralValidation(maximumProperties, minimumProperties, entryInput);
        ArrayList<String> inputProperties = new ArrayList<String>();
        ArrayList<String> patternProperties = new ArrayList<String>();
        ArrayList<String> schemaProperties = new ArrayList<String>();
        if (schemaObject != null && !schemaObject.entrySet().isEmpty()) {
            for (Map.Entry entry : schemaObject.entrySet()) {
                if (!object.has((String)entry.getKey())) continue;
                schemaProperties.add((String)entry.getKey());
            }
        }
        ObjectValidator.processSchemaProperties(schemaObject, entryInput, inputProperties);
        if (schema.has(PATTERN_PROPERTIES)) {
            ObjectValidator.processPatternProperties(object, schema, patternProperties);
        }
        ObjectValidator.processAdditionalProperties(object, schema, inputProperties, patternProperties, schemaProperties);
        return object;
    }

    private static void processSchemaProperties(JsonObject schemaObject, Set<Map.Entry<String, JsonElement>> entryInput, ArrayList<String> inputProperties) throws ValidatorException, ParserException {
        if (schemaObject != null) {
            for (Map.Entry<String, JsonElement> entry : entryInput) {
                JsonObject schemaObj;
                String keyValue = entry.getKey();
                inputProperties.add(keyValue);
                if (!schemaObject.has(keyValue) || !schemaObject.get(keyValue).isJsonObject() || !(schemaObj = schemaObject.getAsJsonObject(keyValue)).has("type")) continue;
                JsonElement typeElement = schemaObj.get("type");
                if (typeElement.isJsonArray()) {
                    ArrayList<String> types = new ArrayList<String>();
                    JsonArray array = (JsonArray)typeElement;
                    for (JsonElement element : array) {
                        types.add(JsonProcessorUtils.replaceEnclosingQuotes(element.toString()));
                    }
                    ObjectValidator.validateAndUpdateEntriesMap(schemaObject, entry, types);
                    continue;
                }
                ObjectValidator.validateAndUpdateEntriesMap(schemaObject, entry, JsonProcessorUtils.replaceEnclosingQuotes(typeElement.toString()));
            }
        }
    }

    private static void validateAndUpdateEntriesMap(JsonObject schemaObject, Map.Entry<String, JsonElement> entry, ArrayList<String> types) throws ValidatorException, ParserException {
        if (schemaObject.has(entry.getKey()) && schemaObject.get(entry.getKey()).isJsonObject()) {
            JsonObject schema = schemaObject.get(entry.getKey()).getAsJsonObject();
            if (entry.getValue().isJsonObject()) {
                ObjectValidator.multiTypeCheckObject(entry, types, schema);
            } else if (entry.getValue().isJsonArray()) {
                ObjectValidator.multiTypeCheckArray(entry, types, schema);
            } else if (entry.getValue().isJsonNull()) {
                ObjectValidator.multiTypeCheckNull(entry, types, schema);
            } else if (entry.getValue().isJsonPrimitive()) {
                ObjectValidator.multiTypeCheckPrimitive(entry, types, schema);
            }
        }
    }

    private static void multiTypeCheckObject(Map.Entry<String, JsonElement> entry, ArrayList<String> types, JsonObject schema) throws ParserException, ValidatorException {
        boolean validated = false;
        for (String type : types) {
            if (!ValidatorConstants.OBJECT_KEYS.contains(type)) continue;
            entry.setValue((JsonElement)ObjectValidator.validateObject(entry.getValue().getAsJsonObject(), schema));
            validated = true;
        }
        if (!validated) {
            for (String type : types) {
                if (!ValidatorConstants.ARRAY_KEYS.contains(type)) continue;
                JsonArray array = new JsonArray();
                array.add((JsonElement)entry.getValue().getAsJsonObject());
                entry.setValue((JsonElement)array);
                entry.setValue((JsonElement)ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(entry.getValue().toString()), schema));
                validated = true;
            }
        }
        if (!validated) {
            throw new ValidatorException("JSON object found " + entry.getValue() + " without matching schema " + schema.toString());
        }
    }

    private static void multiTypeCheckArray(Map.Entry<String, JsonElement> entry, ArrayList<String> types, JsonObject schema) throws ParserException, ValidatorException {
        boolean validated = false;
        for (String type : types) {
            if (!ValidatorConstants.ARRAY_KEYS.contains(type)) continue;
            entry.setValue((JsonElement)ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(entry.getValue().toString()), schema));
            validated = true;
        }
        if (!validated) {
            throw new ValidatorException("JSON array found " + entry.getValue() + " without matching schema " + schema.toString());
        }
    }

    private static void multiTypeCheckNull(Map.Entry<String, JsonElement> entry, ArrayList<String> types, JsonObject schema) throws ParserException, ValidatorException {
        boolean validated = false;
        for (String type : types) {
            if (!ValidatorConstants.NULL_KEYS.contains(type)) continue;
            entry.setValue((JsonElement)JsonNull.INSTANCE);
            validated = true;
        }
        if (!validated) {
            throw new ValidatorException("JSON null found " + entry.getValue() + " without matching schema " + schema.toString());
        }
    }

    private static void multiTypeCheckPrimitive(Map.Entry<String, JsonElement> entry, ArrayList<String> types, JsonObject schema) throws ParserException, ValidatorException {
        String value = entry.getValue().getAsString();
        boolean validated = false;
        if ("true".equals(value) || "false".equals(value)) {
            for (String type : types) {
                if (!ValidatorConstants.BOOLEAN_KEYS.contains(type)) continue;
                entry.setValue((JsonElement)BooleanValidator.validateBoolean(schema, entry.getValue().getAsString()));
                validated = true;
            }
            if (!validated) {
                for (String type : types) {
                    if (!ValidatorConstants.NOMINAL_KEYS.contains(type)) continue;
                    entry.setValue((JsonElement)StringValidator.validateNominal(schema, entry.getValue().getAsString()));
                    validated = true;
                }
            }
            if (!validated) {
                throw new ValidatorException("Boolean found " + entry.getValue() + " without matching schema " + schema.toString());
            }
        } else if (NumberUtils.isParsable((String)value)) {
            for (String type : types) {
                if (!ValidatorConstants.NUMERIC_KEYS.contains(type)) continue;
                entry.setValue((JsonElement)NumericValidator.validateNumeric(schema, entry.getValue().getAsString()));
                validated = true;
            }
            if (!validated) {
                for (String type : types) {
                    if (!ValidatorConstants.NOMINAL_KEYS.contains(type)) continue;
                    entry.setValue((JsonElement)StringValidator.validateNominal(schema, entry.getValue().getAsString()));
                    validated = true;
                }
            }
            if (!validated) {
                throw new ValidatorException("Number found " + entry.getValue() + " without matching schema " + schema.toString());
            }
        } else {
            for (String type : types) {
                if (!ValidatorConstants.NOMINAL_KEYS.contains(type)) continue;
                entry.setValue((JsonElement)StringValidator.validateNominal(schema, entry.getValue().getAsString()));
                validated = true;
            }
            if (!validated) {
                for (String type : types) {
                    if (!ValidatorConstants.BOOLEAN_KEYS.contains(type)) continue;
                    entry.setValue((JsonElement)BooleanValidator.validateBoolean(schema, entry.getValue().getAsString()));
                    validated = true;
                }
            }
            if (!validated) {
                for (String type : types) {
                    if (!ValidatorConstants.NUMERIC_KEYS.contains(type)) continue;
                    entry.setValue((JsonElement)NumericValidator.validateNumeric(schema, entry.getValue().getAsString()));
                    validated = true;
                }
            }
            if (!validated) {
                throw new ValidatorException(entry.getValue() + " not matching with the schema " + schema.toString());
            }
        }
    }

    private static void validateAndUpdateEntriesMap(JsonObject schemaObject, Map.Entry<String, JsonElement> entry, String type) throws ValidatorException, ParserException {
        if (schemaObject.has(entry.getKey()) && schemaObject.get(entry.getKey()).isJsonObject()) {
            JsonObject schema = schemaObject.get(entry.getKey()).getAsJsonObject();
            if (ValidatorConstants.BOOLEAN_KEYS.contains(type)) {
                entry.setValue((JsonElement)BooleanValidator.validateBoolean(schema, entry.getValue().getAsString()));
            } else if (ValidatorConstants.NOMINAL_KEYS.contains(type)) {
                entry.setValue((JsonElement)StringValidator.validateNominal(schema, entry.getValue().getAsString()));
            } else if (ValidatorConstants.NUMERIC_KEYS.contains(type)) {
                entry.setValue((JsonElement)NumericValidator.validateNumeric(schema, entry.getValue().getAsString()));
            } else if (ValidatorConstants.ARRAY_KEYS.contains(type)) {
                entry.setValue((JsonElement)ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(entry.getValue().toString()), schema));
            } else if (ValidatorConstants.OBJECT_KEYS.contains(type)) {
                entry.setValue((JsonElement)ObjectValidator.validateObject(entry.getValue().getAsJsonObject(), schema));
            } else if (ValidatorConstants.NULL_KEYS.contains(type)) {
                if (entry.getValue() != null) {
                    NullValidator.validateNull(schema, entry.getValue().toString());
                }
                entry.setValue((JsonElement)JsonNull.INSTANCE);
            }
        }
    }

    private static void processAdditionalProperties(JsonObject object, JsonObject schema, ArrayList<String> inputProperties, ArrayList<String> patternProperties, ArrayList<String> schemaProperties) throws ParserException, ValidatorException {
        if (schema.has(ADDITIONAL_PROPERTIES)) {
            inputProperties.removeAll(schemaProperties);
            inputProperties.removeAll(patternProperties);
            if (schema.get(ADDITIONAL_PROPERTIES).isJsonPrimitive()) {
                boolean allowAdditional = DataTypeConverter.convertToBoolean(schema.get(ADDITIONAL_PROPERTIES).getAsString());
                if (!allowAdditional && !inputProperties.isEmpty()) {
                    throw new ValidatorException("Input object " + object.toString() + " has additional properties than schema " + schema.toString() + " and additional properties are not allowed");
                }
            } else if (schema.get(ADDITIONAL_PROPERTIES).isJsonObject()) {
                JsonObject additionalSchema = schema.get(ADDITIONAL_PROPERTIES).getAsJsonObject();
                ObjectValidator.validateMultipleObjectsUsingOneSchema(inputProperties, object, additionalSchema);
            }
        }
    }

    private static void processPatternProperties(JsonObject object, JsonObject schema, ArrayList<String> patternProperties) throws ParserException, ValidatorException {
        Set inputObjectKeyset = object.keySet();
        JsonObject patternsObject = schema.getAsJsonObject(PATTERN_PROPERTIES);
        Set patterns = patternsObject.entrySet();
        for (Map.Entry pattern : patterns) {
            String regex = (String)pattern.getKey();
            JsonObject tempSchema = ((JsonElement)pattern.getValue()).getAsJsonObject();
            if (tempSchema.has("type")) {
                String type = JsonProcessorUtils.replaceEnclosingQuotes(tempSchema.get("type").getAsString());
                ArrayList<String> matchingKeys = ObjectValidator.getMatchRegexAgainstStringSet(inputObjectKeyset, regex);
                for (String key : matchingKeys) {
                    if (!patternProperties.contains(key)) {
                        patternProperties.add(key);
                    }
                    ObjectValidator.parseAndReplaceValues(object, tempSchema, type, key);
                }
                continue;
            }
            throw new ValidatorException("Schema for object must have a type declaration : " + tempSchema.toString());
        }
    }

    private static ArrayList<String> getMatchRegexAgainstStringSet(Set<String> keyset, String regex) {
        ArrayList<String> matchingKeys = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        for (String item : keyset) {
            Matcher matcher = pattern.matcher(item);
            if (!matcher.find()) continue;
            matchingKeys.add(item);
        }
        return matchingKeys;
    }

    private static void doStructuralValidation(int maximumProperties, int minimumProperties, Set<Map.Entry<String, JsonElement>> entryInput) throws ValidatorException {
        int numOfProperties = entryInput.size();
        if (minimumProperties != -1 && numOfProperties < minimumProperties) {
            throw new ValidatorException("Object violates the minimum number of properties constraint. Input object has less number of properties than allowed minimum " + minimumProperties);
        }
        if (maximumProperties != -1 && numOfProperties > maximumProperties) {
            throw new ValidatorException("Object violates the maximum number of properties constraint. Input object has higher number of properties than allowed maximum " + maximumProperties);
        }
    }

    private static void validateMultipleObjectsUsingOneSchema(ArrayList<String> keysArray, JsonObject input, JsonObject schema) throws ValidatorException, ParserException {
        if (!schema.entrySet().isEmpty() && !keysArray.isEmpty()) {
            if (schema.has("type")) {
                String type = JsonProcessorUtils.replaceEnclosingQuotes(schema.get("type").toString());
                for (String key : keysArray) {
                    ObjectValidator.parseAndReplaceValues(input, schema, type, key);
                }
            } else {
                throw new ValidatorException("Schema for array must have a type declaration : " + schema.toString());
            }
        }
    }

    private static void parseAndReplaceValues(JsonObject input, JsonObject schema, String type, String key) throws ParserException, ValidatorException {
        JsonPrimitive result = null;
        if (ValidatorConstants.NUMERIC_KEYS.contains(type)) {
            result = NumericValidator.validateNumeric(schema, input.get(key).toString());
        } else if (ValidatorConstants.NOMINAL_KEYS.contains(type)) {
            result = StringValidator.validateNominal(schema, input.get(key).toString());
        } else if (ValidatorConstants.BOOLEAN_KEYS.contains(type)) {
            result = BooleanValidator.validateBoolean(schema, input.get(key).toString());
        } else if (ValidatorConstants.ARRAY_KEYS.contains(type)) {
            result = ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(input.get(key).toString()), schema);
        } else if (ValidatorConstants.OBJECT_KEYS.contains(type)) {
            result = ObjectValidator.validateObject(input.get(key).getAsJsonObject(), schema);
        } else if (ValidatorConstants.NULL_KEYS.contains(type)) {
            if (input.get(key) != null) {
                NullValidator.validateNull(schema, input.get(key).toString());
            }
            result = JsonNull.INSTANCE;
        }
        input.remove(key);
        input.add(key, (JsonElement)result);
    }
}

