/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.logger;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.commons.logger.CorrelationMDCAwareLogger;
import org.apache.synapse.commons.logger.CorrelationMDCImmediateLogger;

public class ContextAwareLogger {
    private static Boolean correlationLoggingEnabled = false;

    public static Log getLogger(MessageContext axis2MessageContext, Log log, boolean removeFromMDC) {
        return ContextAwareLogger.getLogger(axis2MessageContext.getProperty("correlation_id"), log, removeFromMDC);
    }

    public static Log getLogger(HttpContext httpContext, Log log, boolean removeFromMDC) {
        return ContextAwareLogger.getLogger(httpContext.getAttribute("correlation_id"), log, removeFromMDC);
    }

    private static Log getLogger(Object correlationId, Log log, boolean removeFromMDC) {
        if (correlationLoggingEnabled.booleanValue() && correlationId != null && correlationId instanceof String && StringUtils.isNotEmpty((CharSequence)((String)correlationId))) {
            if (removeFromMDC) {
                return new CorrelationMDCImmediateLogger((String)correlationId, log);
            }
            return new CorrelationMDCAwareLogger((String)correlationId, log);
        }
        return log;
    }

    public static void setCorrelationLoggingEnabled(Boolean correlationLoggingEnabled) {
        ContextAwareLogger.correlationLoggingEnabled = correlationLoggingEnabled;
    }

    static {
        String sysCorrelationStatus = System.getProperty("enableCorrelationLogs");
        correlationLoggingEnabled = "true".equalsIgnoreCase(sysCorrelationStatus);
    }
}

