/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.logger;

import org.apache.commons.logging.Log;
import org.apache.logging.log4j.ThreadContext;

public class CorrelationMDCAwareLogger
implements Log {
    private final String correlationId;
    private final Log log;

    public CorrelationMDCAwareLogger(String correlationId, Log log) {
        this.log = log;
        this.correlationId = correlationId;
    }

    public void trace(Object o) {
        this.addCorrelationIdToMDC();
        this.log.trace(o);
    }

    public void trace(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.trace(o, throwable);
    }

    public void debug(Object o) {
        this.addCorrelationIdToMDC();
        this.log.debug(o);
    }

    public void debug(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.debug(o, throwable);
    }

    public void info(Object o) {
        this.addCorrelationIdToMDC();
        this.log.info(o);
    }

    public void info(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.info(o, throwable);
    }

    public void warn(Object o) {
        this.addCorrelationIdToMDC();
        this.log.warn(o);
    }

    public void warn(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.warn(o, throwable);
    }

    public void error(Object o) {
        this.addCorrelationIdToMDC();
        this.log.error(o);
    }

    public void error(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.error(o, throwable);
    }

    public void fatal(Object o) {
        this.addCorrelationIdToMDC();
        this.log.fatal(o);
    }

    public void fatal(Object o, Throwable throwable) {
        this.addCorrelationIdToMDC();
        this.log.fatal(o, throwable);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    private void addCorrelationIdToMDC() {
        ThreadContext.put((String)"Correlation-ID", (String)this.correlationId);
    }
}

