/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.resolvers;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.resolvers.ConfigResolver;
import org.apache.synapse.commons.resolvers.DefaultResolver;
import org.apache.synapse.commons.resolvers.FilePropertyResolver;
import org.apache.synapse.commons.resolvers.Resolver;
import org.apache.synapse.commons.resolvers.ResolverException;
import org.apache.synapse.commons.resolvers.SystemResolver;

public class ResolverFactory {
    private static final Log LOG = LogFactory.getLog(ResolverFactory.class);
    private static final int RESOLVER_INDEX = 2;
    private static final ResolverFactory resolverFactory = new ResolverFactory();
    private final Pattern rePattern = Pattern.compile("(\\$)([_a-zA-Z0-9]+):([_a-zA-Z0-9]+)");
    private final Pattern configPattern = Pattern.compile("(\\$\\{)([_a-zA-Z0-9]+).([_a-zA-Z0-9]+)(})");
    private static final String SYSTEM_VARIABLE_PREFIX = "$SYSTEM";
    private static final String FILE_PROPERTY_VARIABLE_PREFIX = "$FILE";
    private static final String CUSTOM_PROPERTY_VARIABLE_PREFIX = "$CUSTOM_";
    private static final String CONFIGURABLE_VARIABLE_PREFIX = "${configs.";
    private final Map<String, Class<? extends Resolver>> resolverMap = new HashMap<String, Class<? extends Resolver>>();

    public static ResolverFactory getInstance() {
        return resolverFactory;
    }

    private ResolverFactory() {
        this.registerResolvers();
        this.registerExterns();
    }

    public Resolver getResolver(String input) {
        Matcher matcher;
        if (input == null) {
            return null;
        }
        if (input.startsWith(CONFIGURABLE_VARIABLE_PREFIX)) {
            Matcher matcher2 = this.configPattern.matcher(input);
            if (matcher2.find()) {
                return this.getResolver(matcher2.group(2).toLowerCase(), matcher2);
            }
        } else if (input.startsWith(SYSTEM_VARIABLE_PREFIX)) {
            Matcher matcher3 = this.rePattern.matcher(input);
            if (matcher3.find()) {
                return this.getResolver(matcher3.group(2).toLowerCase(), matcher3);
            }
        } else if (input.startsWith(FILE_PROPERTY_VARIABLE_PREFIX)) {
            Matcher matcher4 = this.rePattern.matcher(input);
            if (matcher4.find()) {
                return this.getResolver(matcher4.group(2).toLowerCase(), matcher4);
            }
        } else if (input.startsWith(CUSTOM_PROPERTY_VARIABLE_PREFIX) && (matcher = this.rePattern.matcher(input)).find()) {
            String nameWithPlaceholder = matcher.group(2).toLowerCase();
            String className = nameWithPlaceholder.substring(CUSTOM_PROPERTY_VARIABLE_PREFIX.length() - 1);
            if (matcher.find()) {
                return this.getResolver(className, matcher);
            }
        }
        DefaultResolver resolver = new DefaultResolver();
        resolver.setVariable(input);
        return resolver;
    }

    private void registerResolvers() {
        this.resolverMap.put("system", SystemResolver.class);
        this.resolverMap.put("file", FilePropertyResolver.class);
        this.resolverMap.put("configs", ConfigResolver.class);
    }

    private void registerExterns() {
        ServiceLoader<Resolver> loaders = ServiceLoader.load(Resolver.class);
        for (Resolver resolver : loaders) {
            String className = resolver.getClass().getName();
            String[] packageList = className.split("\\.");
            if (this.resolverMap.get((className = packageList[packageList.length - 1]).toLowerCase()) == null) {
                this.resolverMap.put(className.toLowerCase(), resolver.getClass());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Added Resolver " + className + " to resolver factory "));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Failed to Resolver " + className + " to resolver factory. Already exist"));
        }
    }

    private Resolver getResolver(String className, Matcher matcher) {
        Class<? extends Resolver> resolverClass = this.resolverMap.get(className);
        if (resolverClass != null) {
            try {
                Resolver resolverObject = resolverClass.newInstance();
                resolverObject.setVariable(matcher.group(3));
                return resolverObject;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResolverException("Resolver could not be initialized", e);
            }
        }
        throw new ResolverException("Resolver could not be found");
    }
}

