/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.util;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.StreamTargetDelegate;

public class RemoveRootTarget
extends StreamTargetDelegate {
    private final QName root;
    private final char namespaceSeparator;
    private int depth;

    public RemoveRootTarget(JsonStreamTarget delegate, QName root, char namespaceSeparator) {
        super(delegate);
        this.root = root;
        this.namespaceSeparator = namespaceSeparator;
    }

    @Override
    public void name(String name) throws IOException {
        if (this.depth > 1) {
            super.name(name);
        } else {
            String localPart = name.substring(name.indexOf(this.namespaceSeparator) + 1);
            if (!localPart.equals(this.root.getLocalPart())) {
                throw new IOException("Unexpected root: " + name);
            }
        }
    }

    @Override
    public void startObject() throws IOException {
        if (this.depth++ > 0) {
            super.startObject();
        }
    }

    @Override
    public void endObject() throws IOException {
        if (--this.depth > 0) {
            super.endObject();
        }
    }
}

