/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import java.util.Map;
import org.apache.synapse.commons.templates.uri.URITemplateException;
import org.apache.synapse.commons.templates.uri.parser.Node;

public class Literal
extends Node {
    private int tokenLength = 0;

    public Literal(String token) throws URITemplateException {
        super(token);
        this.tokenLength = token.length();
        if (this.tokenLength == 0) {
            throw new URITemplateException("Invalid literal token with zero length");
        }
        this.hasQueryTemplate = token.contains("?");
    }

    @Override
    String expand(Map<String, String> variables) {
        return this.token;
    }

    @Override
    int match(String uriFragment, Map<String, String> variables) {
        if (!this.token.endsWith("*")) {
            if (uriFragment.length() < this.tokenLength) {
                return -1;
            }
            for (int i = 0; i < this.tokenLength; ++i) {
                if (this.token.charAt(i) == uriFragment.charAt(i)) continue;
                if (this.token.charAt(i) == '*' && i == this.token.length() - 1) {
                    return uriFragment.length();
                }
                return -1;
            }
            return this.tokenLength;
        }
        if (uriFragment.length() < this.tokenLength - 1) {
            return -1;
        }
        for (int i = 0; i < this.tokenLength - 1; ++i) {
            if (this.token.charAt(i) == uriFragment.charAt(i)) continue;
            if (i == this.token.length() - 1) {
                return uriFragment.length();
            }
            return -1;
        }
        return uriFragment.length();
    }

    @Override
    String getToken() {
        return this.token;
    }

    @Override
    char getFirstCharacter() {
        return this.token.charAt(0);
    }
}

