/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.commons.throttle.core.CallerConfiguration;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.Throttle;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleConstants;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.core.ThrottlePolicyProcessor;
import org.apache.synapse.commons.throttle.core.factory.CallerConfigurationFactory;
import org.apache.synapse.commons.throttle.core.factory.ThrottleConfigurationFactory;
import org.apache.synapse.commons.throttle.core.factory.ThrottleContextFactory;

public class ThrottleFactory {
    private static Log log = LogFactory.getLog(ThrottleFactory.class);

    private ThrottleFactory() {
    }

    public static Throttle createModuleThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createServiceThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createOperationThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createMediatorThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME);
    }

    private static Throttle createThrottle(Policy policy, QName forceRoot) throws ThrottleException {
        if (policy == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Policy cannot be found");
            }
            return null;
        }
        if (forceRoot == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given root assertion QName is null");
            }
            return null;
        }
        Iterator iterator = policy.getAlternatives();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof List)) continue;
            List list = (List)object;
            for (Object assertObj : list) {
                if (!(assertObj instanceof XmlPrimtiveAssertion)) continue;
                XmlPrimtiveAssertion primitiveAssertion = (XmlPrimtiveAssertion)assertObj;
                QName qName = primitiveAssertion.getName();
                if (qName == null) {
                    ThrottleFactory.handleException("Invalid Throttle Policy - QName of the assertion cannot be null.");
                }
                Policy throttlePolicy = PolicyEngine.getPolicy((OMElement)primitiveAssertion.getValue());
                if (ThrottleConstants.THROTTLE_ASSERTION_QNAME.equals(qName)) {
                    return ThrottlePolicyProcessor.processPolicy(throttlePolicy);
                }
                if (forceRoot.equals(qName)) {
                    return ThrottleFactory.buildThrottle(throttlePolicy);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("There is no throttle policy for given QName : " + forceRoot));
            }
        }
        return null;
    }

    private static Throttle buildThrottle(Policy throtlePolicy) throws ThrottleException {
        Throttle throttle = new Throttle();
        ThrottleConfiguration configuration = null;
        List list = throtlePolicy.getPolicyComponents();
        if (list == null || list != null && list.isEmpty()) {
            ThrottleFactory.handleException("Empty the policy components as ThrottleAssertion's children");
        }
        for (Object object : list) {
            if (object instanceof Policy) {
                CallerConfiguration callerConfiguration = null;
                Policy policy = null;
                List assertList = ((Policy)object).getAssertions();
                if (assertList != null) {
                    for (Object ca : assertList) {
                        if (ca instanceof XmlPrimtiveAssertion) {
                            XmlPrimtiveAssertion id = (XmlPrimtiveAssertion)ca;
                            configuration = ThrottleFactory.createThrottleConfiguration(id, throttle);
                            if (configuration == null) {
                                ThrottleFactory.handleException("Invalid throttle - Throttle configuration cannot be created from given policy");
                            }
                            if (configuration.getType() == 0) {
                                callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(0);
                            } else if (configuration.getType() == 1) {
                                callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(1);
                            } else if (configuration.getType() == 2) {
                                callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(2);
                            } else {
                                ThrottleFactory.handleException("Invalid throttle type - Only support IP ,DOMAIN and ROLE as types ");
                            }
                            if (callerConfiguration == null) continue;
                            OMElement element = id.getValue();
                            String name = element.getLocalName();
                            String value = element.getText();
                            if (name == null || value == null) {
                                ThrottleFactory.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (name.equals("ID")) {
                                if (!value.equals("")) {
                                    callerConfiguration.setID(value);
                                    continue;
                                }
                                ThrottleFactory.handleException("Value of ID cannot find - invalid configuration");
                                continue;
                            }
                            ThrottleFactory.handleException("Undefined policy property for throttle - Expect ID  ");
                            continue;
                        }
                        if (!(ca instanceof Policy)) continue;
                        policy = (Policy)ca;
                    }
                }
                if (callerConfiguration != null) {
                    if (policy == null) continue;
                    ThrottleFactory.fillCallerConfiguration(policy, callerConfiguration);
                    configuration.addCallerConfiguration(callerConfiguration);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Couldn't find a callerConfiguration for a throttle configuration for an one caller  ");
                continue;
            }
            if (!(object instanceof XmlPrimtiveAssertion)) continue;
            XmlPrimtiveAssertion xmlPrimitiveAssertion = (XmlPrimtiveAssertion)object;
            OMElement element = xmlPrimitiveAssertion.getValue();
            String name = element.getLocalName();
            String value = element.getText();
            if (name == null || value == null) {
                ThrottleFactory.handleException("Either value or name of the policy cannot be null");
                continue;
            }
            if (name.equals("MaximumConcurrentAccess")) {
                int intValue = 0;
                try {
                    intValue = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException ignored) {
                    log.error((Object)"Error occurred - Invalid number for maximum concurrent access ", (Throwable)ignored);
                }
                if (intValue <= 0) continue;
                throttle.setConcurrentAccessController(new ConcurrentAccessController(intValue));
                continue;
            }
            ThrottleFactory.handleException("Invalid throttle policy configuration : unexpected policy element with name " + name);
        }
        return throttle;
    }

    private static ThrottleConfiguration createThrottleConfiguration(XmlPrimtiveAssertion id, Throttle throttle) throws ThrottleException {
        OMElement element = id.getValue();
        ThrottleConfiguration configuration = null;
        String type = element.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME);
        if (type == null) {
            ThrottleFactory.handleException("Type of Throttle in the policy cannot be null");
        }
        if ("IP".equals(type)) {
            configuration = throttle.getThrottleConfiguration("key_of_ip_based_throttle");
            if (configuration == null) {
                configuration = ThrottleConfigurationFactory.createThrottleConfiguration(0);
                throttle.addThrottleContext("key_of_ip_based_throttle", ThrottleContextFactory.createThrottleContext(0, configuration));
                throttle.addThrottleConfiguration("key_of_ip_based_throttle", configuration);
            }
        } else if ("DOMAIN".equals(type)) {
            configuration = throttle.getThrottleConfiguration("key_of_domain_based_throttle");
            if (configuration == null) {
                configuration = ThrottleConfigurationFactory.createThrottleConfiguration(1);
                throttle.addThrottleContext("key_of_domain_based_throttle", ThrottleContextFactory.createThrottleContext(1, configuration));
                throttle.addThrottleConfiguration("key_of_domain_based_throttle", configuration);
            }
        } else if ("ROLE".equals(type)) {
            configuration = throttle.getThrottleConfiguration("key_of_role_based_throttle");
            if (configuration == null) {
                configuration = ThrottleConfigurationFactory.createThrottleConfiguration(2);
                throttle.addThrottleContext("key_of_role_based_throttle", ThrottleContextFactory.createThrottleContext(2, configuration));
                throttle.addThrottleConfiguration("key_of_role_based_throttle", configuration);
            }
        } else {
            ThrottleFactory.handleException("Unsupported throttle type : " + type);
        }
        return configuration;
    }

    private static void fillCallerConfiguration(Policy policy, CallerConfiguration callerConfiguration) throws ThrottleException {
        List list = policy.getPolicyComponents();
        for (Object object : list) {
            XmlPrimtiveAssertion primitiveAssertion = (XmlPrimtiveAssertion)object;
            OMElement element = primitiveAssertion.getValue();
            String name = element.getLocalName();
            if (name.equals("Allow")) {
                callerConfiguration.setAccessState(2);
                continue;
            }
            if (name.equals("Deny")) {
                callerConfiguration.setAccessState(1);
                continue;
            }
            if (name.equals("Control")) {
                Policy controlPolicy;
                callerConfiguration.setAccessState(0);
                OMElement controlElement = primitiveAssertion.getValue();
                if (controlElement == null) {
                    ThrottleFactory.handleException("Invalid throttle configuration - Control assertion cannot be empty");
                }
                if ((controlPolicy = PolicyEngine.getPolicy((OMElement)controlElement)) != null) {
                    ThrottleFactory.fillControlConfiguration(controlPolicy, callerConfiguration);
                    continue;
                }
                ThrottleFactory.handleException("Invalid throttle configuration - Cannot create a policy object(Control Assertion ) form given policy file ");
                continue;
            }
            ThrottleFactory.handleException("Invalid Throttle Policy configuration");
        }
    }

    private static void fillControlConfiguration(Policy policy, CallerConfiguration callerConfiguration) throws ThrottleException {
        boolean isFoundMaxCount = false;
        boolean isFoundUnitTime = false;
        List list = policy.getPolicyComponents();
        for (Object obj : list) {
            if (obj instanceof Policy) {
                List controlList = ((Policy)obj).getPolicyComponents();
                for (Object object : controlList) {
                    if (!(object instanceof XmlPrimtiveAssertion)) continue;
                    XmlPrimtiveAssertion primitiveAssertion = (XmlPrimtiveAssertion)object;
                    OMElement element = primitiveAssertion.getValue();
                    String name = element.getLocalName();
                    String value = element.getText();
                    if (name == null || value == null) {
                        ThrottleFactory.handleException("Either Value or Name of the policy cannot be null");
                    }
                    if (!value.equals("")) {
                        String resolvedValue = ResolverFactory.getInstance().getResolver(value.trim()).resolve();
                        if (name.equals("MaximumCount")) {
                            isFoundMaxCount = true;
                            try {
                                callerConfiguration.setMaximumRequestPerUnitTime(Integer.parseInt(resolvedValue));
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for maximum request number ", (Throwable)ignored);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Access will be fully allowed");
                                }
                                callerConfiguration.setAccessState(2);
                            }
                            continue;
                        }
                        if (name.equals("UnitTime")) {
                            long timeInMilliSec = 0L;
                            try {
                                timeInMilliSec = Long.parseLong(resolvedValue);
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for unit time", (Throwable)ignored);
                            }
                            if (timeInMilliSec == 0L) {
                                ThrottleFactory.handleException("Unit Time cannot find - invalid throttle policy configuration");
                            }
                            isFoundUnitTime = true;
                            callerConfiguration.setUnitTime(timeInMilliSec);
                            continue;
                        }
                        if (name.equals("ProhibitTimePeriod")) {
                            try {
                                callerConfiguration.setProhibitTimePeriod(Long.parseLong(resolvedValue));
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for prohibit time ", (Throwable)ignored);
                            }
                            continue;
                        }
                        ThrottleFactory.handleException("Undefined Policy property for Throttle Policy");
                        continue;
                    }
                    if (name.equals("ProhibitTimePeriod")) continue;
                    ThrottleFactory.handleException("The policy which have  defined as optional should have value ");
                }
                continue;
            }
            ThrottleFactory.handleException("Invalid policy - Control Assertion must contain a wsp:Policy as child ");
        }
        if (!isFoundUnitTime && !isFoundMaxCount) {
            ThrottleFactory.handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");
        }
    }

    private static void handleException(String message) throws ThrottleException {
        String msg = "Error was occurred during throttle policy processing :  " + message;
        log.error((Object)msg);
        throw new ThrottleException(msg);
    }
}

