/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.SharedParamManager;
import org.apache.synapse.commons.throttle.core.ThrottleDataHolder;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class ThrottleReplicator {
    private static final Log log = LogFactory.getLog(ThrottleReplicator.class);
    private static final int MAX_KEYS_TO_REPLICATE = 1000;
    private static int keysToReplicate = 1000;
    private static final int REPLICATOR_THREAD_POOL_SIZE = 1;
    private static int replicatorPoolSize = 1;
    private ConfigurationContext configContext;
    private ThrottleProperties throttleProperties;
    private int replicatorCount;
    private Set<String> set = new ConcurrentSkipListSet<String>();

    public ThrottleReplicator() {
        this.throttleProperties = ThrottleServiceDataHolder.getInstance().getThrottleProperties();
        replicatorPoolSize = Integer.parseInt(this.throttleProperties.getThrottlingPoolSize());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replicator pool size set to " + replicatorPoolSize));
        }
        if (ThrottleServiceDataHolder.getInstance().getThrottleProperties().isThrottleSyncAsyncHybridModeEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Throttle Sync Async Hybrid Mode is enabled. So throttle replicator task will not be scheduled.");
            }
            return;
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(replicatorPoolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Throttle Replicator - " + ThrottleReplicator.this.replicatorCount++);
                return t;
            }
        });
        String throttleFrequency = this.throttleProperties.getThrottlingReplicationFrequency();
        log.debug((Object)("Throttling Frequency set to " + throttleFrequency));
        keysToReplicate = Integer.parseInt(this.throttleProperties.getThrottlingKeysToReplicates());
        log.debug((Object)("Max keys to Replicate " + keysToReplicate));
        for (int i = 0; i < replicatorPoolSize; ++i) {
            executor.scheduleAtFixedRate(new ReplicatorTask(), Integer.parseInt(throttleFrequency), Integer.parseInt(throttleFrequency), TimeUnit.MILLISECONDS);
        }
    }

    public void setConfigContext(ConfigurationContext configContext) {
        if (this.configContext == null) {
            this.configContext = configContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key) {
        if (this.configContext == null) {
            throw new IllegalStateException("ConfigurationContext has not been set");
        }
        String string = key.intern();
        synchronized (string) {
            this.set.add(key);
        }
        if (log.isDebugEnabled()) {
            log.trace((Object)("Adding key " + key + " to replication list"));
        }
    }

    private class ReplicatorTask
    implements Runnable {
        private ReplicatorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            log.debug((Object)"Start running ThrottleReplicatorTask.");
            try {
                if (ThrottleReplicator.this.set.isEmpty()) return;
                for (String key : ThrottleReplicator.this.set) {
                    String string = key.intern();
                    synchronized (string) {
                        ThrottleDataHolder dataHolder = (ThrottleDataHolder)ThrottleReplicator.this.configContext.getProperty("throttle_info");
                        CallerContext callerContext = dataHolder.getCallerContext(key);
                        if (callerContext != null && callerContext.getLocalCounter() > 0L && callerContext.getNextTimeWindow() > System.currentTimeMillis()) {
                            String id = callerContext.getId();
                            long localCounter = callerContext.getLocalCounter();
                            callerContext.resetLocalCounter();
                            Long distributedCounter = SharedParamManager.asyncGetAndAddDistributedCounter(id, localCounter);
                            callerContext.setGlobalCounter(distributedCounter + localCounter);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Increasing counters of context :" + callerContext.getId() + " Replicated Count After  Update : distributedCounter =" + distributedCounter + " localCounter=" + localCounter + " total=" + (distributedCounter + localCounter)));
                            }
                        }
                        ThrottleReplicator.this.set.remove(key);
                    }
                }
                return;
            }
            catch (Throwable t) {
                log.error((Object)"Could not replicate throttle data", t);
            }
        }
    }
}

