/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.module.handler;

import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.AccessInformation;
import org.apache.synapse.commons.throttle.core.AccessRateController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.RoleBasedAccessRateController;
import org.apache.synapse.commons.throttle.core.Throttle;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.module.utils.StatCollector;
import org.apache.synapse.commons.throttle.module.utils.impl.DummyAuthenticator;
import org.apache.synapse.commons.throttle.module.utils.impl.DummyHandler;

public abstract class ThrottleHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog((String)ThrottleHandler.class.getName());
    private AccessRateController accessRateController;
    private RoleBasedAccessRateController roleBasedAccessController;
    public static final String THROTTLING_CACHE_MANAGER = "throttling.cache.manager";
    public static final String THROTTLING_CACHE = "throttling.cache";
    private boolean debugOn = log.isDebugEnabled();

    public ThrottleHandler() {
        this.accessRateController = new AccessRateController();
        this.roleBasedAccessController = new RoleBasedAccessRateController();
    }

    protected abstract int getThrottleType();

    public Throttle loadThrottle(MessageContext messageContext, int throttleType) throws ThrottleException {
        Throttle throttle = null;
        ConfigurationContext configContext = messageContext.getConfigurationContext();
        Map throttles = (Map)configContext.getPropertyNonReplicable("local_throttle_map");
        if (throttles == null) {
            if (this.debugOn) {
                log.debug((Object)"Couldn't find throttles object map .. thottlling will not be occurred ");
            }
            return null;
        }
        switch (throttleType) {
            case 0: {
                throttle = (Throttle)throttles.get("key_of_global_throttle");
                break;
            }
            case 2: {
                AxisOperation axisOperation = messageContext.getAxisOperation();
                if (axisOperation != null) {
                    String currentServiceName;
                    AxisService service;
                    QName opName = axisOperation.getName();
                    if (opName == null || (service = (AxisService)axisOperation.getParent()) == null || (currentServiceName = service.getName()) == null) break;
                    throttle = (Throttle)throttles.get(currentServiceName + opName.getLocalPart());
                    break;
                }
                if (this.debugOn) {
                    log.debug((Object)"Couldn't find axis operation ");
                }
                return null;
            }
            case 1: {
                AxisService axisService = messageContext.getAxisService();
                if (axisService != null) {
                    throttle = (Throttle)throttles.get(axisService.getName());
                    break;
                }
                if (this.debugOn) {
                    log.debug((Object)"Couldn't find axis service ");
                }
                return null;
            }
            default: {
                throw new ThrottleException("Unsupported Throttle type");
            }
        }
        return throttle;
    }

    public void process(Throttle throttle, MessageContext messageContext) throws ThrottleException, AxisFault {
        String throttleId = throttle.getId();
        ConfigurationContext cc = messageContext.getConfigurationContext();
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(THROTTLING_CACHE_MANAGER);
        Cache cache = cacheManager != null ? cacheManager.getCache(THROTTLING_CACHE) : Caching.getCacheManager().getCache(THROTTLING_CACHE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created throttling cache : " + cache));
        }
        String key = null;
        key = "throttle_" + throttleId + "_cac_key";
        ConcurrentAccessController cac = (ConcurrentAccessController)cache.get((Object)key);
        boolean canAccess = this.doConcurrentThrottling(cac, messageContext);
        if (canAccess) {
            if (messageContext.getFLOW() == 1) {
                String domain = null;
                HttpServletRequest request = (HttpServletRequest)messageContext.getPropertyNonReplicable(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                if (request != null) {
                    domain = request.getRemoteHost();
                }
                String callerId = null;
                if (domain != null) {
                    ThrottleConfiguration throttleConfig;
                    ThrottleContext throttleCtxt = throttle.getThrottleContext("key_of_domain_based_throttle");
                    if (throttleCtxt != null && (throttleConfig = throttleCtxt.getThrottleConfiguration()) != null) {
                        callerId = throttleConfig.getConfigurationKeyOfCaller(domain);
                        if (callerId != null) {
                            throttleCtxt.setThrottleId(throttleId);
                            AccessInformation infor = this.accessRateController.canAccess(throttleCtxt, callerId, 1);
                            StatCollector.collect(infor, domain, 1);
                            if (!infor.isAccessAllowed()) {
                                if (cac != null) {
                                    cac.incrementAndGet();
                                    cache.put((Object)key, (Object)cac);
                                    if (this.debugOn) {
                                        log.debug((Object)("Added the state of ConcurrentAccessController to cache with key : " + key));
                                    }
                                }
                                throw new AxisFault(" Access deny for a caller with Domain " + domain + "  : Reason : " + infor.getFaultReason());
                            }
                        } else if (this.debugOn) {
                            log.debug((Object)("Could not find the Throttle Context for domain-Based Throttling for domain name " + domain + " Throttling for this domain name may not be configured from policy"));
                        }
                    }
                } else if (this.debugOn) {
                    log.debug((Object)"Could not find the domain of the caller - IP-based throttling may occur");
                }
                if (callerId == null) {
                    String ip = (String)messageContext.getProperty("REMOTE_ADDR");
                    if (ip != null) {
                        ThrottleContext context = throttle.getThrottleContext("key_of_ip_based_throttle");
                        if (context != null) {
                            ThrottleConfiguration config = context.getThrottleConfiguration();
                            if (config != null && (callerId = config.getConfigurationKeyOfCaller(ip)) != null) {
                                context.setThrottleId(throttleId);
                                AccessInformation infor = this.accessRateController.canAccess(context, callerId, 0);
                                StatCollector.collect(infor, ip, 0);
                                if (!infor.isAccessAllowed()) {
                                    if (cac != null) {
                                        cac.incrementAndGet();
                                        cache.put((Object)key, (Object)cac);
                                        if (this.debugOn) {
                                            log.debug((Object)("Added the state of ConcurrentAccessController to cache with key : " + key));
                                        }
                                    }
                                    throw new AxisFault(" Access deny for a caller with IP " + ip + "  : Reason : " + infor.getFaultReason());
                                }
                            }
                        } else if (this.debugOn) {
                            log.debug((Object)"Could not find the throttle Context for IP-Based throttling");
                        }
                    } else if (this.debugOn) {
                        log.debug((Object)"Could not find the IP address of the caller - throttling will not occur");
                    }
                }
            }
            if (cac != null) {
                cache.put((Object)key, (Object)cac);
                if (this.debugOn) {
                    log.debug((Object)("Added the state of ConcurrentAccessController to cache with key : " + key));
                }
            }
        } else {
            if (cac != null) {
                cache.put((Object)key, (Object)cac);
                if (this.debugOn) {
                    log.debug((Object)("Added the state of ConcurrentAccessController to cache with key : " + key));
                }
            }
            throw new AxisFault("Access has currently been denied since  maximum concurrent access have exceeded");
        }
        this.doRoleBasedAccessThrottling(throttle, messageContext);
    }

    private boolean doConcurrentThrottling(ConcurrentAccessController concurrentAccessController, MessageContext messageContext) {
        boolean canAccess = true;
        if (concurrentAccessController != null) {
            if (messageContext.getFLOW() == 1) {
                int available = concurrentAccessController.getAndDecrement();
                boolean bl = canAccess = available > 0;
                if (this.debugOn) {
                    log.debug((Object)("Concurrency Throttle : Access " + (canAccess ? "allowed" : "denied") + " :: " + available + " of available of " + concurrentAccessController.getLimit() + " connections"));
                }
                if (this.debugOn && !canAccess) {
                    log.debug((Object)"Concurrency Throttle : Access has currently been denied since allowed maximum concurrent access have exceeded");
                }
            } else if (messageContext.getFLOW() == 2) {
                int available = concurrentAccessController.incrementAndGet();
                if (this.debugOn) {
                    log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentAccessController.getLimit() + " connections"));
                }
            }
        }
        return canAccess;
    }

    private boolean doRoleBasedAccessThrottling(Throttle throttle, MessageContext messageContext) throws AxisFault, ThrottleException {
        boolean canAccess = true;
        if (throttle.getThrottleContext("key_of_role_based_throttle") == null) {
            return canAccess;
        }
        ConfigurationContext cc = messageContext.getConfigurationContext();
        String throttleId = throttle.getId();
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(THROTTLING_CACHE_MANAGER);
        Cache cache = cacheManager != null ? cacheManager.getCache(THROTTLING_CACHE) : Caching.getCacheManager().getCache(THROTTLING_CACHE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created throttling cache : " + cache));
        }
        String key = null;
        ConcurrentAccessController cac = null;
        key = "throttle_" + throttleId + "_cac_key";
        cac = (ConcurrentAccessController)cache.get((Object)key);
        if (messageContext.getFLOW() == 1) {
            String consumerKey = null;
            boolean isAuthenticated = false;
            String roleID = null;
            HttpServletRequest request = (HttpServletRequest)messageContext.getPropertyNonReplicable(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (request != null) {
                String oAuthHeader = request.getHeader("OAuth");
                DummyAuthenticator authFuture = new DummyAuthenticator(oAuthHeader);
                consumerKey = authFuture.getAPIKey();
                new DummyHandler().authenticateUser(authFuture);
                roleID = (String)authFuture.getAuthorizedRoles().get(0);
                isAuthenticated = authFuture.isAuthenticated();
            }
            if (!isAuthenticated) {
                throw new AxisFault(" Access deny for a caller with consumer Key: " + consumerKey + "  : Reason : Authentication failure");
            }
            String consumerRoleID = null;
            if (consumerKey != null && isAuthenticated) {
                ThrottleConfiguration config;
                ThrottleContext context = throttle.getThrottleContext("key_of_role_based_throttle");
                if (context != null && (config = context.getThrottleConfiguration()) != null) {
                    consumerRoleID = config.getConfigurationKeyOfCaller(roleID);
                    if (consumerRoleID != null) {
                        context.setThrottleId(throttleId);
                        AccessInformation infor = this.roleBasedAccessController.canAccess(context, consumerKey, consumerRoleID);
                        StatCollector.collect(infor, consumerKey, 2);
                        if (!infor.isAccessAllowed()) {
                            if (cac != null) {
                                cac.incrementAndGet();
                                cache.put((Object)key, (Object)cac);
                                if (this.debugOn) {
                                    log.debug((Object)("Added the state of ConcurrentAccessController to cache with key : " + key));
                                }
                            }
                            throw new AxisFault(" Access deny for a caller with Domain " + consumerKey + "  : Reason : " + infor.getFaultReason());
                        }
                    } else if (this.debugOn) {
                        log.debug((Object)("Could not find the Throttle Context for role-Based Throttling for role name " + consumerKey + " Throttling for this role name may not be configured from policy"));
                    }
                }
            } else if (this.debugOn) {
                log.debug((Object)"Could not find the role of the caller - role based throttling NOT applied");
            }
        }
        return canAccess;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            Throttle throttle = this.loadThrottle(msgContext, this.getThrottleType());
            if (throttle != null) {
                this.process(throttle, msgContext);
            }
        }
        catch (ThrottleException e) {
            log.error((Object)e.getMessage());
            throw new AxisFault(e.getMessage());
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

