/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.crypto;

import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.crypto.EncodeDecodeHelper;
import org.apache.synapse.commons.crypto.EncodeDecodeTypes;
import org.apache.synapse.commons.crypto.Util;
import org.wso2.securevault.CipherFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.DecryptionProvider;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.KeyStoreInformationFactory;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.KeyStoreWrapper;

public class CryptoUtil {
    private static Log log = LogFactory.getLog(CryptoUtil.class);
    private DecryptionProvider baseCipher;
    private boolean isInitialized = false;
    private EncodeDecodeTypes inType = null;
    private EncodeDecodeTypes outType = null;
    private String algorithm = null;

    public CryptoUtil(Properties secureVaultProperties) throws AxisFault {
        this.init(secureVaultProperties);
    }

    public void init(Properties secureVaultProperties) throws AxisFault {
        IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation((Properties)secureVaultProperties);
        String identityKeyPass = null;
        String identityStorePass = null;
        if (identityInformation != null) {
            identityKeyPass = identityInformation.getKeyPasswordProvider().getResolvedSecret();
            identityStorePass = identityInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        if (!Util.validatePasswords(identityStorePass, identityKeyPass)) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Either Identity or Trust keystore password is mandatory in order to initialized secret manager.");
            }
            throw new AxisFault("Error inititialising cryptoutil, required parameters not provided");
        }
        IdentityKeyStoreWrapper identityKeyStoreWrapper = new IdentityKeyStoreWrapper();
        identityKeyStoreWrapper.init(identityInformation, identityKeyPass);
        this.algorithm = MiscellaneousUtil.getProperty((Properties)secureVaultProperties, (String)"cipher.algorithm", (String)"RSA");
        String provider = MiscellaneousUtil.getProperty((Properties)secureVaultProperties, (String)"security.provider", null);
        String cipherType = MiscellaneousUtil.getProperty((Properties)secureVaultProperties, (String)"cipher.type", null);
        String inTypeString = MiscellaneousUtil.getProperty((Properties)secureVaultProperties, (String)"input.encode.type", null);
        this.inType = Util.getEncodeDecodeType(inTypeString, EncodeDecodeTypes.BASE64);
        String outTypeString = MiscellaneousUtil.getProperty((Properties)secureVaultProperties, (String)"output.encode.type", null);
        this.outType = Util.getEncodeDecodeType(outTypeString, null);
        CipherInformation cipherInformation = new CipherInformation();
        cipherInformation.setAlgorithm(this.algorithm);
        cipherInformation.setCipherOperationMode(CipherOperationMode.DECRYPT);
        cipherInformation.setType(cipherType);
        cipherInformation.setInType(null);
        cipherInformation.setOutType(null);
        if (provider != null && !provider.isEmpty()) {
            String providerClass;
            if ("BC".equals(provider)) {
                providerClass = "org.bouncycastle.jce.provider.BouncyCastleProvider";
            } else if ("BCFIPS".equals(provider)) {
                providerClass = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
            } else {
                throw new AxisFault("Unsupported JCE Provider: " + provider);
            }
            try {
                Security.addProvider((Provider)Class.forName(providerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new AxisFault("Error while initializing the JCE Provider: " + provider, (Throwable)e);
            }
            cipherInformation.setProvider(provider);
        }
        this.baseCipher = CipherFactory.createCipher((CipherInformation)cipherInformation, (KeyStoreWrapper)identityKeyStoreWrapper);
        this.isInitialized = true;
    }

    public byte[] decrypt(byte[] encryptedBytes) {
        if (this.inType != null) {
            encryptedBytes = EncodeDecodeHelper.decode(encryptedBytes, this.inType);
        }
        byte[] response = this.baseCipher.decrypt(encryptedBytes);
        if (this.outType != null) {
            response = EncodeDecodeHelper.encode(response, this.outType);
        }
        return response;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

