/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.crypto;

import java.math.BigInteger;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.mail.util.Hex;
import org.apache.synapse.commons.crypto.EncodeDecodeTypes;

public class EncodeDecodeHelper {
    private static Log log = LogFactory.getLog(EncodeDecodeHelper.class);

    public static byte[] encode(byte[] input, EncodeDecodeTypes encodingType) {
        switch (encodingType) {
            case BASE64: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"base64 encoding on output ");
                }
                return Base64Utils.encode((byte[])input).getBytes();
            }
            case BIGINTEGER16: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BigInteger 16 encoding on output ");
                }
                return new BigInteger(input).toByteArray();
            }
            case HEX: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Hex encoding on output ");
                }
                return Hex.encode((byte[])input);
            }
        }
        throw new IllegalArgumentException("Unsupported encoding type");
    }

    public static byte[] decode(byte[] input, EncodeDecodeTypes decodingType) {
        switch (decodingType) {
            case BASE64: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"base64 decoding on input  ");
                }
                return Base64Utils.decode((String)new String(input));
            }
            case BIGINTEGER16: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BigInteger 16 decoding on output ");
                }
                BigInteger n = new BigInteger(new String(input), 16);
                return n.toByteArray();
            }
            case HEX: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Hex decoding on output ");
                }
                return Hex.decode((byte[])input);
            }
        }
        throw new IllegalArgumentException("Unsupported encoding type");
    }
}

