/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.secret.SecretInformation;

public class DataSourceInformationRepository {
    private static final Log log = LogFactory.getLog(DataSourceInformationRepository.class);
    private final Map<String, DataSourceInformation> dataSourceInformationMap = new HashMap<String, DataSourceInformation>();
    private DataSourceInformationRepositoryListener listener;
    private SecretResolver secretResolver;

    public void configure(Properties configurationProperties) {
        if (this.listener != null) {
            this.listener.reConfigure(configurationProperties);
        }
        this.secretResolver = SecretResolverFactory.create((Properties)configurationProperties, (String)"synapse.datasources");
    }

    public void addDataSourceInformation(DataSourceInformation dataSourceInformation) {
        if (dataSourceInformation == null) {
            throw new SynapseCommonsException("DataSource information is null", log);
        }
        SecretInformation secretInformation = dataSourceInformation.getSecretInformation();
        if (secretInformation != null) {
            secretInformation.setGlobalSecretResolver(this.secretResolver);
        }
        this.dataSourceInformationMap.put(dataSourceInformation.getAlias(), dataSourceInformation);
        if (this.assertListerNotNull()) {
            this.listener.addDataSourceInformation(dataSourceInformation);
        }
    }

    public DataSourceInformation getDataSourceInformation(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("Name of the datasource information instance to be returned is null", log);
        }
        return this.dataSourceInformationMap.get(name);
    }

    public DataSourceInformation removeDataSourceInformation(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("Name of the datasource information instance to be removed is null", log);
        }
        DataSourceInformation information = this.dataSourceInformationMap.remove(name);
        if (information == null) {
            throw new SynapseCommonsException("There is no datasource information instance for given name :" + name, log);
        }
        if (this.assertListerNotNull()) {
            this.listener.removeDataSourceInformation(information);
        }
        return information;
    }

    public Iterator<DataSourceInformation> getAllDataSourceInformation() {
        return this.dataSourceInformationMap.values().iterator();
    }

    public void setRepositoryListener(DataSourceInformationRepositoryListener listener) {
        if (listener == null) {
            throw new SynapseCommonsException("Provided DataSourceInformationRepositoryListener instance is null", log);
        }
        if (this.listener != null) {
            throw new SynapseCommonsException("There is already a DataSourceInformationRepositoryListener associated with 'DataSourceInformationRepository", log);
        }
        this.listener = listener;
    }

    public void removeRepositoryListener() {
        this.listener = null;
    }

    public DataSourceInformationRepositoryListener getRepositoryListener() {
        return this.listener;
    }

    private boolean assertListerNotNull() {
        if (this.listener == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find a DataSourceInformationRepositoryListener.");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using DataSourceInformationRepositoryListener as :" + this.listener));
        }
        return true;
    }
}

