/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.emulator.core.AbstractEmulatorContext;
import org.apache.synapse.commons.emulator.core.Emulator;
import org.apache.synapse.commons.emulator.core.EmulatorType;

public abstract class AbstractProtocolEmulator {
    private Emulator emulator;
    private EmulatorType emulatorType;
    private static final Log log = LogFactory.getLog(AbstractProtocolEmulator.class);

    public AbstractProtocolEmulator(Emulator emulator) {
        this.emulator = emulator;
    }

    public abstract AbstractEmulatorContext consumer();

    public abstract AbstractEmulatorContext producer();

    public AbstractProtocolEmulator start() {
        try {
            this.emulator.setEmulatorType(this.emulatorType);
            this.emulator.start();
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while initialize the emulator", (Throwable)e);
        }
        return this;
    }

    public AbstractProtocolEmulator send() {
        try {
            this.emulator.setEmulatorType(this.emulatorType);
            this.emulator.run();
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while initialize the emulator", (Throwable)e);
        }
        return this;
    }

    public void shutdown() {
        try {
            this.emulator.shutdown(this.emulatorType);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while shutdown the emulator", (Throwable)e);
        }
    }

    protected void setEmulatorType(EmulatorType emulatorType) {
        this.emulatorType = emulatorType;
    }
}

