/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.producer;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;
import java.util.Map;
import org.apache.synapse.commons.emulator.http.producer.HttpResponseContext;

public class HttpResponseInformationProcessor {
    public void process(HttpResponse httpResponse, HttpResponseContext responseContext) {
        this.populateRequestHeaders(httpResponse, responseContext);
    }

    private void populateRequestHeaders(HttpResponse httpResponse, HttpResponseContext responseContext) {
        HttpHeaders headers = httpResponse.headers();
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entries()) {
                responseContext.addHeaderParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void appendDecoderResult(HttpResponseContext responseContext, HttpObject httpObject, ByteBuf content) {
        responseContext.appendResponseContent(content.toString(CharsetUtil.UTF_8));
        DecoderResult result = httpObject.getDecoderResult();
        if (result.isSuccess()) {
            return;
        }
        responseContext.appendResponseContent(result.cause());
    }
}

