/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.json.JsonDataSource;
import org.apache.synapse.commons.json.JsonReaderDelegate;
import org.apache.synapse.commons.json.XmlReaderDelegate;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfig;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfigBuilder;
import org.apache.synapse.commons.staxon.core.json.JsonXMLInputFactory;
import org.apache.synapse.commons.staxon.core.json.JsonXMLOutputFactory;
import org.apache.synapse.commons.staxon.core.json.stream.impl.Constants;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public final class JsonUtil {
    private static Log logger = LogFactory.getLog((String)JsonUtil.class.getName());
    private static final String ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT = "org.apache.synapse.commons.json.JsonInputStream.IsJsonObject";
    private static final QName JSON_OBJECT = new QName("jsonObject");
    private static final QName JSON_ARRAY = new QName("jsonArray");
    private static final QName JSON_VALUE = new QName("jsonValue");
    public static final String PRESERVE_JSON_STREAM = "preserve.json.stream";
    private static boolean isJsonToXmlPiEnabled = false;
    private static final JsonXMLOutputFactory jsonOutputFactory;
    private static final JsonXMLInputFactory jsonInputFactory;
    private static final JsonXMLInputFactory xmlInputFactoryNoPIs;
    private static final XMLInputFactory xmlInputFactory;

    public static JsonXMLInputFactory generateJsonXMLInputFactory(Properties props) {
        boolean xmlNilReadWriteEnabled;
        boolean xmloutAutoArray;
        boolean xmloutMultiplePI;
        if (props == null) {
            xmloutMultiplePI = false;
            xmloutAutoArray = true;
            xmlNilReadWriteEnabled = false;
        } else {
            xmloutMultiplePI = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.xmloutMultiplePI", "false"));
            xmloutAutoArray = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.xmloutAutoArray", "true"));
            xmlNilReadWriteEnabled = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNilReadWrite", "false"));
        }
        JsonXMLConfig xmlOutputConfigNoPIs = new JsonXMLConfigBuilder().multiplePI(xmloutMultiplePI).autoArray(xmloutAutoArray).autoPrimitive(true).namespaceDeclarations(false).namespaceSeparator('\u0d89').readWriteXmlNil(xmlNilReadWriteEnabled).build();
        return new JsonXMLInputFactory(xmlOutputConfigNoPIs);
    }

    public static JsonXMLInputFactory generateJSONInputFactory(Properties props) {
        boolean xmlNilReadWriteEnabled;
        String jsonoutcustomRegex;
        if (props == null) {
            jsonoutcustomRegex = null;
            xmlNilReadWriteEnabled = false;
        } else {
            jsonoutcustomRegex = props.getProperty("synapse.commons.json.output.disableAutoPrimitive.regex", null);
            xmlNilReadWriteEnabled = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNilReadWrite", "false"));
        }
        JsonXMLConfig xmlOutputConfig = new JsonXMLConfigBuilder().multiplePI(true).autoArray(true).autoPrimitive(true).namespaceDeclarations(false).namespaceSeparator('\u0d89').customRegex(jsonoutcustomRegex).readWriteXmlNil(xmlNilReadWriteEnabled).build();
        return new JsonXMLInputFactory(xmlOutputConfig);
    }

    public static JsonXMLOutputFactory generateJSONOutputFactory(Properties props) {
        boolean processNCNames;
        boolean xmlWriteNullForEmptyElements;
        boolean xmlNilReadWriteEnabled;
        String jsonoutcustomRegex;
        String jsonoutCustomReplaceSequence;
        String jsonoutCustomReplaceRegex;
        char jsonOutNamespaceSepChar;
        boolean jsonOutEnableNsDeclarations;
        boolean jsonOutAutoPrimitive;
        boolean jsonoutAutoArray;
        boolean jsonoutMultiplePI;
        boolean preserverNamespacesForJson;
        if (props == null) {
            preserverNamespacesForJson = false;
            jsonoutMultiplePI = true;
            jsonoutAutoArray = true;
            jsonOutAutoPrimitive = true;
            jsonOutEnableNsDeclarations = false;
            jsonOutNamespaceSepChar = '_';
            jsonoutCustomReplaceRegex = null;
            jsonoutCustomReplaceSequence = "";
            jsonoutcustomRegex = null;
            xmlNilReadWriteEnabled = false;
            xmlWriteNullForEmptyElements = true;
            processNCNames = false;
        } else {
            preserverNamespacesForJson = Boolean.parseBoolean(props.getProperty("synapse.commons.json.preserve.namespace", "false").trim().toLowerCase());
            jsonoutMultiplePI = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.jsonoutMultiplePI", "true"));
            jsonoutAutoArray = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.jsonoutAutoArray", "true"));
            jsonOutAutoPrimitive = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.autoPrimitive", "true").trim().toLowerCase());
            jsonOutEnableNsDeclarations = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.enableNSDeclarations", "false").trim().toLowerCase());
            jsonOutNamespaceSepChar = props.getProperty("synapse.commons.json.output.namespaceSepChar", "_").trim().charAt(0);
            jsonoutCustomReplaceRegex = props.getProperty("synapse.commons.json.json.output.disableAutoPrimitive.customReplaceRegex", null);
            jsonoutCustomReplaceSequence = props.getProperty("synapse.commons.json.json.output.disableAutoPrimitive.customReplaceSequence", "");
            jsonoutcustomRegex = props.getProperty("synapse.commons.json.output.disableAutoPrimitive.regex", null);
            xmlNilReadWriteEnabled = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNilReadWrite", "false"));
            xmlWriteNullForEmptyElements = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNullForEmptyElement", "true"));
            processNCNames = Boolean.parseBoolean(props.getProperty("synapse.commons.json.buildValidNCNames", "false").trim().toLowerCase());
        }
        JsonXMLConfig jsonOutputConfig = new JsonXMLConfigBuilder().multiplePI(jsonoutMultiplePI).autoArray(jsonoutAutoArray).autoPrimitive(jsonOutAutoPrimitive).namespaceDeclarations(jsonOutEnableNsDeclarations).namespaceSeparator(jsonOutNamespaceSepChar).customReplaceRegex(jsonoutCustomReplaceRegex).customReplaceSequence(jsonoutCustomReplaceSequence).customRegex(jsonoutcustomRegex).readWriteXmlNil(xmlNilReadWriteEnabled).writeNullForEmptyElement(xmlWriteNullForEmptyElements).preserverNamespacesForJson(preserverNamespacesForJson).processNCNames(processNCNames).build();
        return new JsonXMLOutputFactory(jsonOutputConfig);
    }

    public static JsonXMLOutputFactory generateJSONOutputFactoryWithOveride(Properties props) {
        boolean preserverNamespacesForJson = Boolean.parseBoolean(props.getProperty("synapse.commons.json.preserve.namespace", Boolean.toString(jsonOutputFactory.getConfig().isPreserverNamespacesForJson())));
        boolean jsonoutMultiplePI = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.jsonoutMultiplePI", Boolean.toString(jsonOutputFactory.getConfig().isMultiplePI())));
        boolean jsonoutAutoArray = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.jsonoutAutoArray", Boolean.toString(jsonOutputFactory.getConfig().isAutoArray())));
        boolean jsonOutAutoPrimitive = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.autoPrimitive", Boolean.toString(jsonOutputFactory.getConfig().isAutoPrimitive())).trim().toLowerCase());
        boolean jsonOutEnableNsDeclarations = Boolean.parseBoolean(props.getProperty("synapse.commons.json.output.enableNSDeclarations", Boolean.toString(jsonOutputFactory.getConfig().isNamespaceDeclarations())).trim().toLowerCase());
        char jsonOutNamespaceSepChar = props.getProperty("synapse.commons.json.output.namespaceSepChar", Character.toString(jsonOutputFactory.getConfig().getNamespaceSeparator())).trim().charAt(0);
        String jsonoutCustomReplaceRegex = props.getProperty("synapse.commons.json.json.output.disableAutoPrimitive.customReplaceRegex", jsonOutputFactory.getConfig().getCustomReplaceRegex());
        String jsonoutCustomReplaceSequence = props.getProperty("synapse.commons.json.json.output.disableAutoPrimitive.customReplaceSequence", jsonOutputFactory.getConfig().getCustomReplaceSequence());
        String jsonoutcustomRegex = props.getProperty("synapse.commons.json.output.disableAutoPrimitive.regex", jsonOutputFactory.getConfig().getCustomRegex());
        boolean xmlNilReadWriteEnabled = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNilReadWrite", Boolean.toString(jsonOutputFactory.getConfig().isReadWriteXmlNil())));
        boolean xmlWriteNullForEmptyElements = Boolean.parseBoolean(props.getProperty("synapse.commons.enableXmlNullForEmptyElement", Boolean.toString(jsonOutputFactory.getConfig().isWriteNullForEmptyElements())));
        boolean processNCNames = Boolean.parseBoolean(props.getProperty("synapse.commons.json.buildValidNCNames", Boolean.toString(jsonOutputFactory.getConfig().isProcessNCNames())).trim().toLowerCase());
        JsonXMLConfig jsonOutputConfig = new JsonXMLConfigBuilder().multiplePI(jsonoutMultiplePI).autoArray(jsonoutAutoArray).autoPrimitive(jsonOutAutoPrimitive).namespaceDeclarations(jsonOutEnableNsDeclarations).namespaceSeparator(jsonOutNamespaceSepChar).customReplaceRegex(jsonoutCustomReplaceRegex).customReplaceSequence(jsonoutCustomReplaceSequence).customRegex(jsonoutcustomRegex).readWriteXmlNil(xmlNilReadWriteEnabled).writeNullForEmptyElement(xmlWriteNullForEmptyElements).preserverNamespacesForJson(preserverNamespacesForJson).processNCNames(processNCNames).build();
        return new JsonXMLOutputFactory(jsonOutputConfig);
    }

    public static void writeAsJson(MessageContext messageContext, OutputStream out) throws AxisFault {
        JsonUtil.writeAsJson(messageContext, out, null);
    }

    public static void writeAsJson(MessageContext messageContext, OutputStream out, String encoding) throws AxisFault {
        if (messageContext == null || out == null) {
            return;
        }
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        Object o = JsonUtil.jsonStream(messageContext, false);
        InputStream json = null;
        if (o != null) {
            json = o;
        }
        o = messageContext.getProperty("JSON_STRING");
        String jsonStr = null;
        if (o instanceof String) {
            jsonStr = (String)o;
        }
        if (json != null) {
            try {
                if (element instanceof OMSourcedElementImpl) {
                    if (JsonUtil.isAJsonPayloadElement(element)) {
                        JsonUtil.writeJsonStream(json, messageContext, out);
                    }
                    JsonUtil.writeAsJson(element, out, encoding);
                }
                if (element != null) {
                    JsonUtil.writeAsJson(element, out, encoding);
                }
                JsonUtil.writeJsonStream(json, messageContext, out);
            }
            catch (Exception e) {
                IOUtils.closeQuietly((InputStream)json);
                throw new AxisFault("Could not write JSON stream.", (Throwable)e);
            }
        } else if (element != null) {
            JsonUtil.writeAsJson(element, out, JsonUtil.populateRequiredProperties(messageContext), jsonOutputFactory, encoding);
        } else if (jsonStr != null) {
            try {
                out.write(jsonStr.getBytes());
            }
            catch (IOException e) {
                logger.error((Object)("#writeAsJson. Could not write JSON string. MessageID: " + messageContext.getMessageID() + ". Error>> " + e.getLocalizedMessage()));
                throw new AxisFault("Could not write JSON string.", (Throwable)e);
            }
        } else {
            logger.error((Object)("#writeAsJson. Payload could not be written as JSON. MessageID: " + messageContext.getMessageID()));
            throw new AxisFault("Payload could not be written as JSON.");
        }
    }

    private static Map populateRequiredProperties(MessageContext msgCtx) {
        HashMap<String, String> requiredProperties = new HashMap<String, String>();
        requiredProperties.put("PRESERVE_SPACES", (String)msgCtx.getProperty("PRESERVE_SPACES"));
        return requiredProperties;
    }

    public static OMElement toXml(InputStream jsonStream, boolean pIs) throws AxisFault {
        if (jsonStream == null) {
            logger.error((Object)"#toXml. Could not convert JSON Stream to XML. JSON input stream is null.");
            return null;
        }
        try {
            XMLStreamReader streamReader = JsonUtil.getReader(jsonStream, pIs);
            return new StAXOMBuilder(streamReader).getDocumentElement();
        }
        catch (XMLStreamException e) {
            logger.error((Object)("#toXml. Could not convert JSON Stream to XML. Cannot handle JSON input. Error>>> " + e.getLocalizedMessage()));
            throw new AxisFault("Could not convert JSON Stream to XML. Cannot handle JSON input.", (Throwable)e);
        }
    }

    public static XMLStreamReader getReader(InputStream jsonStream, boolean pIs) throws XMLStreamException {
        if (jsonStream == null) {
            logger.error((Object)"#getReader. Could not create XMLStreamReader from [null] input stream.");
            return null;
        }
        return pIs ? JsonUtil.getReader(jsonStream) : new JsonReaderDelegate(xmlInputFactoryNoPIs.createXMLStreamReader(jsonStream, Constants.SCANNER.SCANNER_1), jsonOutputFactory.getConfig().isProcessNCNames());
    }

    public static XMLStreamReader getReader(InputStream jsonStream) throws XMLStreamException {
        if (jsonStream == null) {
            logger.error((Object)"#getReader. Could not create XMLStreamReader from [null] input stream.");
            return null;
        }
        return new JsonReaderDelegate(jsonInputFactory.createXMLStreamReader(jsonStream, Constants.SCANNER.SCANNER_1), jsonOutputFactory.getConfig().isProcessNCNames());
    }

    public static void writeAsJson(OMElement element, OutputStream outputStream) throws AxisFault {
        JsonUtil.writeAsJson(element, outputStream, null, null, null);
    }

    public static void writeAsJson(OMElement element, OutputStream outputStream, String encoding) throws AxisFault {
        JsonUtil.writeAsJson(element, outputStream, null, null, encoding);
    }

    public static void writeAsJson(OMElement element, OutputStream outputStream, Map properties, JsonXMLOutputFactory jsonOutputFactory) throws AxisFault {
        JsonUtil.writeAsJson(element, outputStream, properties, jsonOutputFactory, null);
    }

    public static void writeAsJson(OMElement element, OutputStream outputStream, Map properties, JsonXMLOutputFactory jsonOutputFactory, String encoding) throws AxisFault {
        JsonXMLOutputFactory jsonXMLOutputFactory = jsonOutputFactory = jsonOutputFactory == null ? JsonUtil.jsonOutputFactory : jsonOutputFactory;
        if (element == null) {
            throw new AxisFault("OMElement is null. Cannot convert to JSON.");
        }
        if (outputStream == null) {
            return;
        }
        JsonUtil.transformElement(element, true, properties, jsonOutputFactory);
        JsonUtil.convertOMElementToJson(element, outputStream, jsonOutputFactory, encoding);
    }

    private static void convertOMElementToJson(OMElement element, OutputStream outputStream, JsonXMLOutputFactory jsonOutputFactory) throws AxisFault {
        JsonUtil.convertOMElementToJson(element, outputStream, jsonOutputFactory, null);
    }

    private static void convertOMElementToJson(OMElement element, OutputStream outputStream, JsonXMLOutputFactory jsonOutputFactory, String encoding) throws AxisFault {
        XMLEventReader xmlEventReader = null;
        XMLEventWriter jsonWriter = null;
        try {
            if (JSON_VALUE.getLocalPart().equals(element.getLocalName())) {
                outputStream.write(element.getText().getBytes());
                outputStream.flush();
                return;
            }
            ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
            element.serialize((OutputStream)xmlStream);
            xmlStream.flush();
            xmlEventReader = xmlInputFactory.createXMLEventReader(new XmlReaderDelegate(xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(xmlStream.toByteArray())), jsonOutputFactory.getConfig().isProcessNCNames()));
            jsonWriter = encoding != null ? jsonOutputFactory.createXMLEventWriter(outputStream, encoding) : jsonOutputFactory.createXMLEventWriter(outputStream);
            jsonWriter.add(xmlEventReader);
            outputStream.flush();
        }
        catch (XMLStreamException e) {
            logger.error((Object)("#writeAsJson. Could not convert OMElement to JSON. Invalid XML payload. Error>>> " + e.getLocalizedMessage()));
            throw new AxisFault("Could not convert OMElement to JSON. Invalid XML payload.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("#writeAsJson. Could not convert OMElement to JSON. Error>>> " + e.getLocalizedMessage()));
            throw new AxisFault("Could not convert OMElement to JSON.", (Throwable)e);
        }
        finally {
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (jsonWriter != null) {
                try {
                    jsonWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static StringBuilder toJsonString(OMElement element) throws AxisFault {
        return JsonUtil.toJsonString(element, null);
    }

    public static StringBuilder toJsonString(OMElement element, JsonXMLOutputFactory jsonOutputFactory) throws AxisFault {
        if (element == null) {
            return new StringBuilder("{}");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        JsonUtil.writeAsJson(element.cloneOMElement(), (OutputStream)byteStream, null, jsonOutputFactory);
        return new StringBuilder(new String(byteStream.toByteArray()));
    }

    public static void transformElement(OMElement element, boolean processAttrbs) {
        JsonUtil.transformElement(element, processAttrbs, null, null);
    }

    public static void transformElement(OMElement element, boolean processAttrbs, Map properties, JsonXMLOutputFactory jsonOutputFactory) {
        boolean preserveNamespacesForJson;
        boolean bl = preserveNamespacesForJson = jsonOutputFactory != null && jsonOutputFactory.getConfig().isPreserverNamespacesForJson();
        if (element == null) {
            return;
        }
        if (properties == null) {
            JsonUtil.removeIndentations(element);
        } else {
            JsonUtil.removeIndentations(element, properties);
        }
        if (!preserveNamespacesForJson) {
            JsonUtil.removeNamespaces(element, processAttrbs);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#transformElement. Transformed OMElement. Result: " + element.toString()));
        }
    }

    private static void removeIndentations(OMElement elem) {
        Iterator children;
        try {
            children = elem.getChildren();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error while removing indentations from OMElement. Error>>> " + e.getLocalizedMessage()));
            }
            return;
        }
        while (children.hasNext()) {
            OMNode child = (OMNode)children.next();
            if (child instanceof OMText) {
                if (!((OMText)child).getText().trim().isEmpty()) continue;
                children.remove();
                continue;
            }
            if (!(child instanceof OMElement)) continue;
            JsonUtil.removeIndentations((OMElement)child);
        }
    }

    private static void removeIndentations(OMElement elem, Map properties) {
        boolean preserveSpaces;
        Iterator children;
        try {
            children = elem.getChildren();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error while removing indentations from OMElement. Error>>> " + e.getLocalizedMessage()));
            }
            return;
        }
        boolean bl = preserveSpaces = properties.get("PRESERVE_SPACES") != null && Boolean.parseBoolean((String)properties.get("PRESERVE_SPACES"));
        while (children.hasNext()) {
            OMNode child = (OMNode)children.next();
            if (child instanceof OMText) {
                if (preserveSpaces && child.getPreviousOMSibling() == null && child.getNextOMSibling() == null || !((OMText)child).getText().trim().isEmpty()) continue;
                children.remove();
                continue;
            }
            if (!(child instanceof OMElement)) continue;
            JsonUtil.removeIndentations((OMElement)child, properties);
        }
    }

    private static void removeNamespaces(OMElement element, boolean processAttrbs) {
        String prefix;
        OMNamespace ns = element.getNamespace();
        Iterator i = element.getAllDeclaredNamespaces();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        if (ns != null) {
            prefix = "";
            element.setNamespace(element.getOMFactory().createOMNamespace("", prefix));
        }
        Iterator children = element.getChildElements();
        while (children.hasNext()) {
            JsonUtil.removeNamespaces((OMElement)children.next(), processAttrbs);
        }
        if (!processAttrbs) {
            return;
        }
        Iterator attrbs = element.getAllAttributes();
        while (attrbs.hasNext()) {
            OMAttribute attrb = (OMAttribute)attrbs.next();
            prefix = "";
            attrb.setOMNamespace(attrb.getOMFactory().createOMNamespace("", prefix));
        }
    }

    @Deprecated
    public static OMElement newJsonPayload(MessageContext messageContext, InputStream inputStream, boolean removeChildren, boolean addAsNewFirstChild) {
        try {
            return JsonUtil.getNewJsonPayload(messageContext, inputStream, removeChildren, addAsNewFirstChild);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)"Payload provided is not an JSON payload.");
            return null;
        }
    }

    public static OMElement getNewJsonPayload(MessageContext messageContext, InputStream inputStream, boolean removeChildren, boolean addAsNewFirstChild) throws AxisFault {
        if (messageContext == null) {
            logger.error((Object)"#getNewJsonPayload. Could not save JSON stream. Message context is null.");
            return null;
        }
        boolean isObject = false;
        boolean isArray = false;
        boolean isValue = false;
        if (inputStream != null) {
            InputStream json = JsonUtil.setJsonStream(messageContext, inputStream);
            boolean isEmptyPayload = true;
            boolean valid = false;
            try {
                int character = json.read();
                while (character != -1 && character != 123 && character != 91 && character != 34 && character != 116 && character != 110 && character != 102 && character != 45 && character != 48 && character != 49 && character != 50 && character != 51 && character != 52 && character != 53 && character != 54 && character != 55 && character != 56 && character != 57) {
                    if (character != 32) {
                        isEmptyPayload = false;
                    }
                    character = json.read();
                }
                if (character != -1) {
                    valid = true;
                }
                if (character == 123) {
                    isObject = true;
                    isArray = false;
                    isValue = false;
                } else if (character == 91) {
                    isArray = true;
                    isObject = false;
                    isValue = false;
                } else if (character == 34 || character == 116 || character == 110 || character == 102 || character == 45 || character == 48 || character == 49 || character == 50 || character == 51 || character == 52 || character == 53 || character == 54 || character == 55 || character == 56 || character == 57) {
                    isArray = false;
                    isObject = false;
                    isValue = true;
                }
                json.reset();
            }
            catch (IOException e) {
                logger.error((Object)("#getNewJsonPayload. Could not determine availability of the JSON input stream. MessageID: " + messageContext.getMessageID() + ". Error>>> " + e.getLocalizedMessage()));
                return null;
            }
            if (!valid) {
                if (isEmptyPayload) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("#emptyJsonPayload found.MessageID: " + messageContext.getMessageID()));
                    }
                    logger.debug((Object)("#emptyJsonPayload found.MessageID: " + messageContext.getMessageID()));
                    return null;
                }
                if (JsonUtil.isValidPayloadRequired(messageContext)) {
                    throw new AxisFault("#getNewJsonPayload. Could not save JSON payload. Invalid input stream found. Payload is not a JSON string.");
                }
                return null;
            }
            QName jsonElement = null;
            if (isObject) {
                jsonElement = JSON_OBJECT;
                messageContext.setProperty(ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT, (Object)true);
            }
            if (isValue) {
                String jsonString = "";
                try {
                    jsonString = IOUtils.toString((InputStream)json, (String)"UTF-8");
                    messageContext.setProperty(ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT, (Object)false);
                    if (!(jsonString.startsWith("\"") && jsonString.endsWith("\"") || jsonString.equals("true") || jsonString.equals("false") || jsonString.equals("null") || jsonString.matches("-?\\d+(\\.\\d+)?"))) {
                        throw new AxisFault("#getNewJsonPayload. Could not save JSON payload. Invalid input stream found. Payload is not a JSON string.");
                    }
                    jsonElement = JSON_VALUE;
                    OMElement element = OMAbstractFactory.getOMFactory().createOMElement(jsonElement, null);
                    element.addChild((OMNode)OMAbstractFactory.getOMFactory().createOMText(jsonString));
                    if (removeChildren) {
                        JsonUtil.removeChildrenFromPayloadBody(messageContext);
                        if (addAsNewFirstChild) {
                            JsonUtil.addPayloadBody(messageContext, element);
                        }
                    }
                    return element;
                }
                catch (IOException e) {
                    throw new AxisFault("#Can not parse stream. MessageID: " + messageContext.getMessageID() + ". Error>>> " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (isArray) {
                jsonElement = JSON_ARRAY;
                messageContext.setProperty(ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT, (Object)false);
            }
            OMSourcedElementImpl elem = new OMSourcedElementImpl(jsonElement, OMAbstractFactory.getOMFactory(), (OMDataSource)new JsonDataSource((InputStream)messageContext.getProperty("org.apache.synapse.commons.json.JsonInputStream")));
            if (!removeChildren) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("#getNewJsonPayload. Not removing child elements from exiting message. Returning result. MessageID: " + messageContext.getMessageID()));
                }
                return elem;
            }
            JsonUtil.removeChildrenFromPayloadBody(messageContext);
            if (addAsNewFirstChild) {
                JsonUtil.addPayloadBody(messageContext, (OMElement)elem);
            }
            return elem;
        }
        return null;
    }

    private static void removeChildrenFromPayloadBody(MessageContext messageContext) {
        SOAPBody body;
        SOAPEnvelope envelope = messageContext.getEnvelope();
        if (envelope != null && (body = envelope.getBody()) != null) {
            try {
                JsonUtil.removeIndentations((OMElement)body);
            }
            catch (Exception exp) {
                body.getFirstElement().detach();
                throw new SynapseCommonsException("Existing json payload is malformed. MessageID : " + messageContext.getMessageID(), exp);
            }
            Iterator children = body.getChildren();
            while (children.hasNext()) {
                Object child = children.next();
                if (!(child instanceof OMNode)) continue;
                children.remove();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("#getNewJsonPayload. Removed child elements from exiting message. MessageID: " + messageContext.getMessageID()));
            }
        }
    }

    private static void addPayloadBody(MessageContext messageContext, OMElement elem) {
        SOAPEnvelope envelope = messageContext.getEnvelope();
        if (envelope != null) {
            SOAPBody body = envelope.getBody();
            body.addChild((OMNode)elem);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("#getNewJsonPayload. Added the new JSON sourced element as the first child. MessageID: " + messageContext.getMessageID()));
            }
        }
    }

    public static InputStream setJsonStream(MessageContext messageContext, InputStream inputStream) {
        InputStream json = JsonUtil.toReadOnlyStream(inputStream);
        messageContext.setProperty("org.apache.synapse.commons.json.JsonInputStream", (Object)json);
        return json;
    }

    public static void removeJsonStream(MessageContext messageContext) {
        messageContext.removeProperty("org.apache.synapse.commons.json.JsonInputStream");
    }

    @Deprecated
    public static OMElement newJsonPayload(MessageContext messageContext, String jsonString, boolean removeChildren, boolean addAsNewFirstChild) {
        try {
            return JsonUtil.getNewJsonPayload(messageContext, jsonString, removeChildren, addAsNewFirstChild);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)"Payload provided is not an JSON payload.");
            return null;
        }
    }

    public static OMElement getNewJsonPayload(MessageContext messageContext, String jsonString, boolean removeChildren, boolean addAsNewFirstChild) throws AxisFault {
        if (jsonString == null || jsonString.isEmpty()) {
            jsonString = "{}";
        }
        return JsonUtil.getNewJsonPayload(messageContext, new ByteArrayInputStream(jsonString.getBytes()), removeChildren, addAsNewFirstChild);
    }

    @Deprecated
    public static OMElement newJsonPayload(MessageContext messageContext, byte[] json, int offset, int length, boolean removeChildren, boolean addAsNewFirstChild) {
        try {
            return JsonUtil.getNewJsonPayload(messageContext, json, offset, length, removeChildren, addAsNewFirstChild);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)"Payload provided is not an JSON payload.");
            return null;
        }
    }

    public static OMElement getNewJsonPayload(MessageContext messageContext, byte[] json, int offset, int length, boolean removeChildren, boolean addAsNewFirstChild) throws AxisFault {
        ByteArrayInputStream is;
        if (json == null || json.length < 2) {
            json = new byte[]{123, 125};
            is = new ByteArrayInputStream(json);
        } else {
            is = new ByteArrayInputStream(json, offset, length);
        }
        return JsonUtil.getNewJsonPayload(messageContext, is, removeChildren, addAsNewFirstChild);
    }

    public static boolean removeJsonPayload(MessageContext messageContext) {
        SOAPBody b;
        messageContext.removeProperty("org.apache.synapse.commons.json.JsonInputStream");
        messageContext.removeProperty(ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT);
        boolean removeChildren = true;
        if (!removeChildren) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("#removeJsonPayload. Removed JSON stream. MessageID: " + messageContext.getMessageID()));
            }
            return true;
        }
        SOAPEnvelope e = messageContext.getEnvelope();
        if (e != null && (b = e.getBody()) != null) {
            Iterator children = b.getChildren();
            while (children.hasNext()) {
                Object o = children.next();
                if (!(o instanceof OMNode)) continue;
                children.remove();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("#removeJsonPayload. Removed JSON stream and child elements of payload. MessageID: " + messageContext.getMessageID()));
            }
        }
        return true;
    }

    private static InputStream jsonStream(MessageContext messageContext, boolean reset) {
        if (messageContext == null) {
            return null;
        }
        Object o = messageContext.getProperty("org.apache.synapse.commons.json.JsonInputStream");
        if (o instanceof InputStream) {
            InputStream is = (InputStream)o;
            if (reset && is.markSupported()) {
                try {
                    is.reset();
                }
                catch (IOException e) {
                    logger.error((Object)"#jsonStream. Could not reuse JSON Stream. Error>>>\n", (Throwable)e);
                    return null;
                }
            }
            return is;
        }
        return null;
    }

    public static InputStream getJsonPayload(MessageContext messageContext) {
        return JsonUtil.hasAJsonPayload(messageContext) ? JsonUtil.jsonStream(messageContext, true) : null;
    }

    private static InputStream copyOfJsonPayload(MessageContext messageContext, boolean closable) {
        if (messageContext == null) {
            logger.error((Object)"#copyOfJsonPayload. Cannot copy JSON stream from message context. [null].");
            return null;
        }
        InputStream jsonStream = JsonUtil.jsonStream(messageContext, true);
        if (jsonStream == null) {
            logger.error((Object)"#copyOfJsonPayload. Cannot copy JSON stream from message context. [null] stream.");
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)jsonStream, (OutputStream)out);
            out.flush();
            return closable ? new ByteArrayInputStream(out.toByteArray()) : JsonUtil.toReadOnlyStream(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            logger.error((Object)("#copyOfJsonPayload. Could not copy the JSON stream from message context. Error>>> " + e.getLocalizedMessage()));
            return null;
        }
    }

    private static void writeJsonStream(InputStream json, MessageContext messageContext, OutputStream out) throws AxisFault {
        try {
            if (json.markSupported()) {
                json.reset();
            }
            String outboundCharsetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            String contentType = (String)messageContext.getProperty("ContentType");
            String inboundCharsetEncoding = BuilderUtil.getCharSetEncoding((String)contentType);
            if (outboundCharsetEncoding == null || outboundCharsetEncoding.equalsIgnoreCase(inboundCharsetEncoding) && outboundCharsetEncoding.equalsIgnoreCase(Charset.defaultCharset().toString())) {
                IOUtils.copy((InputStream)json, (OutputStream)out);
            } else {
                byte[] inboundBuffer = IOUtils.toByteArray((InputStream)json);
                byte[] outboundBuffer = inboundCharsetEncoding == null || inboundCharsetEncoding.equalsIgnoreCase(Charset.defaultCharset().toString()) ? new String(inboundBuffer).getBytes(outboundCharsetEncoding) : new String(new String(inboundBuffer).getBytes(inboundCharsetEncoding), outboundCharsetEncoding).getBytes();
                out.write(outboundBuffer);
            }
            if (messageContext.getProperty(PRESERVE_JSON_STREAM) != null) {
                if (json.markSupported()) {
                    json.reset();
                }
                messageContext.removeProperty(PRESERVE_JSON_STREAM);
            }
        }
        catch (IOException e) {
            logger.error((Object)("#writeJsonStream. Could not write JSON stream. MessageID: " + messageContext.getMessageID() + ". Error>> " + e.getLocalizedMessage()));
            throw new AxisFault("Could not write JSON stream.", (Throwable)e);
        }
    }

    private static InputStream cachedCopyOfJsonPayload(MessageContext messageContext) {
        if (messageContext == null) {
            logger.error((Object)"#cachedCopyOfJsonPayload. Cannot copy JSON stream from message context. [null].");
            return null;
        }
        InputStream jsonStream = JsonUtil.jsonStream(messageContext, true);
        if (jsonStream == null) {
            logger.error((Object)"#cachedCopyOfJsonPayload. Cannot copy JSON stream from message context. [null] stream.");
            return null;
        }
        String inputStreamCache = Long.toString(jsonStream.hashCode());
        Object o = messageContext.getProperty(inputStreamCache);
        if (o instanceof InputStream) {
            InputStream inputStream = (InputStream)o;
            try {
                inputStream.reset();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"#cachedCopyOfJsonPayload. Cache HIT");
                }
                return inputStream;
            }
            catch (IOException e) {
                logger.warn((Object)("#cachedCopyOfJsonPayload. Could not reuse the cached input stream. Error>>> " + e.getLocalizedMessage()));
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)jsonStream, (OutputStream)out);
            out.flush();
            InputStream inputStream = JsonUtil.toReadOnlyStream(new ByteArrayInputStream(out.toByteArray()));
            messageContext.setProperty(inputStreamCache, (Object)inputStream);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#cachedCopyOfJsonPayload. Cache MISS");
            }
            return inputStream;
        }
        catch (IOException e) {
            logger.error((Object)("#cachedCopyOfJsonPayload. Could not copy the JSON stream from message context. Error>>> " + e.getLocalizedMessage()));
            return null;
        }
    }

    public static Reader newJsonPayloadReader(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        InputStream is = JsonUtil.jsonStream(messageContext, true);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }

    public static byte[] jsonPayloadToByteArray(MessageContext messageContext) {
        if (messageContext == null) {
            return new byte[0];
        }
        InputStream is = JsonUtil.jsonStream(messageContext, true);
        if (is == null) {
            return new byte[0];
        }
        try {
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            logger.warn((Object)"#jsonPayloadToByteArray. Could not convert JSON stream to byte array.");
            return new byte[0];
        }
    }

    public static String jsonPayloadToString(MessageContext messageContext) {
        if (messageContext == null) {
            return "{}";
        }
        InputStream is = JsonUtil.jsonStream(messageContext, true);
        if (is == null) {
            return "{}";
        }
        try {
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            logger.warn((Object)"#jsonPayloadToString. Could not convert JSON stream to String.");
            return "{}";
        }
    }

    public static boolean hasAJsonPayload(OMElement element) {
        return (element instanceof OMSourcedElementImpl || element instanceof OMElementImpl) && JsonUtil.isAJsonPayloadElement(element);
    }

    public static boolean isAJsonPayloadElement(OMElement element) {
        return element != null && (JSON_OBJECT.getLocalPart().equals(element.getLocalName()) || JSON_ARRAY.getLocalPart().equals(element.getLocalName()) || JSON_VALUE.getLocalPart().equals(element.getLocalName()));
    }

    public static boolean hasAJsonPayload(MessageContext messageContext) {
        if (messageContext == null || messageContext.getEnvelope() == null) {
            return false;
        }
        SOAPBody b = messageContext.getEnvelope().getBody();
        return b != null && JsonUtil.jsonStream(messageContext, false) != null && JsonUtil.hasAJsonPayload(b.getFirstElement());
    }

    public static boolean cloneJsonPayload(MessageContext sourceMc, MessageContext targetMc) {
        if (!JsonUtil.hasAJsonPayload(sourceMc)) {
            return false;
        }
        InputStream json = JsonUtil.jsonStream(sourceMc, true);
        try {
            byte[] stream = IOUtils.toByteArray((InputStream)json);
            JsonUtil.getNewJsonPayload(targetMc, new ByteArrayInputStream(stream), true, true);
        }
        catch (IOException e) {
            logger.error((Object)("#cloneJsonPayload. Could not clone JSON stream. Error>>> " + e.getLocalizedMessage()));
            return false;
        }
        return true;
    }

    public static void setContentType(MessageContext messageContext) {
        if (messageContext == null) {
            return;
        }
        messageContext.setProperty("messageType", (Object)"application/json");
    }

    public static InputStream toReadOnlyStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return new ReadOnlyBIS(inputStream);
    }

    public static InputStream toJsonStream(OMElement element) {
        if (element == null) {
            logger.error((Object)"#toJsonStream. Could not create input stream from XML element [null]");
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            JsonUtil.writeAsJson(element.cloneOMElement(), (OutputStream)bos);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("#toJsonStream. Could not create input stream from XML element [" + element.toString() + "]. Error>>> " + axisFault.getLocalizedMessage()));
            return null;
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static Reader newJavaScriptSourceReader(MessageContext messageContext) {
        InputStream jsonStream = JsonUtil.jsonStream(messageContext, true);
        if (jsonStream == null) {
            logger.error((Object)"#newJavaScriptSourceReader. Could not create a JavaScript source. Error>>> No JSON stream found.");
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(40);
            IOUtils.copy((InputStream)jsonStream, (OutputStream)out);
            out.write(41);
            out.flush();
        }
        catch (IOException e) {
            logger.error((Object)("#newJavaScriptSourceReader. Could not create a JavaScript source. Error>>> " + e.getLocalizedMessage()));
            return null;
        }
        return new InputStreamReader(new ByteArrayInputStream(out.toByteArray()));
    }

    public static boolean hasAJsonObject(MessageContext messageContext) {
        return JsonUtil.hasAJsonPayload(messageContext) && JsonUtil._hasAJsonObject(messageContext);
    }

    public static boolean hasAJsonArray(MessageContext messageContext) {
        return JsonUtil.hasAJsonPayload(messageContext) && !JsonUtil._hasAJsonObject(messageContext);
    }

    private static boolean _hasAJsonObject(MessageContext messageContext) {
        Object isObject = messageContext.getProperty(ORG_APACHE_SYNAPSE_COMMONS_JSON_IS_JSON_OBJECT);
        return isObject != null && (Boolean)isObject != false;
    }

    private static boolean isValidPayloadRequired(MessageContext msgCtx) {
        boolean isRequired = true;
        if ("GET".equals(msgCtx.getProperty("HTTP_METHOD_OBJECT")) || "DELETE".equals(msgCtx.getProperty("HTTP_METHOD_OBJECT"))) {
            isRequired = false;
        }
        return isRequired;
    }

    public static boolean isPiEnabled() {
        return isJsonToXmlPiEnabled;
    }

    static {
        xmlInputFactory = XMLInputFactory.newInstance();
        Properties properties = MiscellaneousUtil.loadProperties("synapse.properties");
        isJsonToXmlPiEnabled = Boolean.parseBoolean(properties.getProperty("synapse.json.to.xml.processing.instruction.enabled", "false").trim());
        jsonOutputFactory = JsonUtil.generateJSONOutputFactory(properties);
        jsonInputFactory = JsonUtil.generateJSONInputFactory(properties);
        xmlInputFactoryNoPIs = JsonUtil.generateJsonXMLInputFactory(properties);
    }

    private static class ReadOnlyBIS
    extends BufferedInputStream {
        private static final String LOG_STREAM = "org.apache.synapse.commons.json.JsonReadOnlyStream";
        private static final Log logger = LogFactory.getLog((String)"org.apache.synapse.commons.json.JsonReadOnlyStream");

        public ReadOnlyBIS(InputStream inputStream) {
            super(inputStream);
            super.mark(Integer.MAX_VALUE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"<init>");
            }
        }

        @Override
        public void close() throws IOException {
            super.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#close");
            }
        }

        @Override
        public void mark(int readlimit) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#mark");
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public long skip(long n) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#skip");
            }
            return 0L;
        }
    }
}

