/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.base;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public abstract class AbstractXMLOutputFactory
extends XMLOutputFactory {
    private boolean repairingNamespaces;

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            OutputStream output = streamResult.getOutputStream();
            if (output != null) {
                return this.createXMLStreamWriter(output);
            }
            Writer writer = streamResult.getWriter();
            if (writer != null) {
                return this.createXMLStreamWriter(writer);
            }
            if (result.getSystemId() != null) {
                throw new XMLStreamException("Cannot open system id as URL for writing: " + result.getSystemId());
            }
            throw new XMLStreamException("Invalid stream result: none of output, writer, systemId set");
        }
        throw new XMLStreamException("Unsupported result type: " + result.getClass());
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream stream) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream stream, String encoding) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream, encoding));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer stream) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream));
    }

    public abstract XMLEventWriter createXMLEventWriter(XMLStreamWriter var1) throws XMLStreamException;

    @Override
    public boolean isPropertySupported(String name) {
        return "javax.xml.stream.isRepairingNamespaces".equals(name);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            return this.repairingNamespaces;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (!"javax.xml.stream.isRepairingNamespaces".equals(name)) {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
        this.repairingNamespaces = (Boolean)value;
    }
}

