/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.event;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SimpleXMLEventWriter
implements XMLEventWriter {
    private final XMLStreamWriter delegate;

    public SimpleXMLEventWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 10: {
                Attribute attribute = (Attribute)event;
                QName attrName = attribute.getName();
                this.delegate.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attribute.getValue());
                break;
            }
            case 8: {
                this.delegate.writeEndDocument();
                break;
            }
            case 2: {
                this.delegate.writeEndElement();
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)event;
                this.delegate.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)event;
                if (startDocument.encodingSet()) {
                    this.delegate.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                    break;
                }
                this.delegate.writeStartDocument(startDocument.getVersion());
                break;
            }
            case 1: {
                StartElement startElement = event.asStartElement();
                QName elemName = startElement.getName();
                this.delegate.writeStartElement(elemName.getPrefix(), elemName.getLocalPart(), elemName.getNamespaceURI());
                Iterator<Namespace> namespaces = startElement.getNamespaces();
                while (namespaces.hasNext()) {
                    this.add(namespaces.next());
                }
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    this.add(attributes.next());
                }
                break;
            }
            case 4: 
            case 12: {
                Characters characters = event.asCharacters();
                if (characters.isCData()) {
                    this.delegate.writeCData(characters.getData());
                    break;
                }
                this.delegate.writeCharacters(characters.getData());
                break;
            }
            case 5: {
                this.delegate.writeComment(((Comment)event).getText());
                break;
            }
            case 11: {
                this.delegate.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                this.delegate.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)event;
                this.delegate.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new XMLStreamException("Cannot write event " + event);
            }
        }
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.peek() != null) {
            this.add(reader.nextEvent());
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        this.delegate.setNamespaceContext(ctxt);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }
}

