/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.synapse.commons.staxon.core.base.AbstractXMLStreamWriter;
import org.apache.synapse.commons.staxon.core.json.JsonXMLStreamScopeInfo;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;

public class JsonXMLStreamWriter
extends AbstractXMLStreamWriter<ScopeInfo> {
    private static final String XML_SCHEMA_NIL_VALUE = "org.apache.synapse.commons.staxon.core.json.JsonXMLStreamWriter.{http://www.w3.org/2001/XMLSchema-instance}#nil=true_";
    private static final String XSI_NIL = "nil";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private final JsonStreamTarget target;
    private final boolean multiplePI;
    private final boolean autoEndArray;
    private final boolean skipSpace;
    private final char namespaceSeparator;
    private final boolean namespaceDeclarations;
    private final boolean xmlNilReadWriteEnabled;
    private final boolean xmlWriteNullForEmptyElement;
    private boolean documentArray = false;

    static boolean isWhitespace(Object data) {
        if (data == null) {
            return false;
        }
        String text = data.toString();
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public JsonXMLStreamWriter(JsonStreamTarget target, boolean repairNamespaces, boolean multiplePI, char namespaceSeparator, boolean namespaceDeclarations) {
        super(new ScopeInfo(), repairNamespaces);
        this.target = target;
        this.multiplePI = multiplePI;
        this.namespaceSeparator = namespaceSeparator;
        this.namespaceDeclarations = namespaceDeclarations;
        this.autoEndArray = true;
        this.skipSpace = true;
        this.xmlNilReadWriteEnabled = false;
        this.xmlWriteNullForEmptyElement = true;
    }

    public JsonXMLStreamWriter(JsonStreamTarget target, boolean repairNamespaces, boolean multiplePI, char namespaceSeparator, boolean namespaceDeclarations, boolean xmlNilReadWriteEnabled, boolean xmlWriteNullForEmptyElement) {
        super(new ScopeInfo(), repairNamespaces);
        this.target = target;
        this.multiplePI = multiplePI;
        this.namespaceSeparator = namespaceSeparator;
        this.namespaceDeclarations = namespaceDeclarations;
        this.autoEndArray = true;
        this.skipSpace = true;
        this.xmlNilReadWriteEnabled = xmlNilReadWriteEnabled;
        this.xmlWriteNullForEmptyElement = xmlWriteNullForEmptyElement;
    }

    private String getFieldName(String prefix, String localName) {
        return "".equals(prefix) ? localName : prefix + this.namespaceSeparator + localName;
    }

    @Override
    protected ScopeInfo writeStartElementTag(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        ScopeInfo parentInfo = (ScopeInfo)this.getScope().getInfo();
        if (parentInfo.hasData()) {
            if (!this.skipSpace || !JsonXMLStreamWriter.isWhitespace(parentInfo.getData())) {
                throw new XMLStreamException("Mixed content is not supported: '" + parentInfo.getData() + "'");
            }
            parentInfo.setData(null);
        }
        String fieldName = this.getFieldName(prefix, localName);
        if (this.getScope().isRoot() && this.getScope().getLastChild() != null && !this.documentArray && !fieldName.equals(parentInfo.getArrayName())) {
            throw new XMLStreamException("Multiple roots within document");
        }
        if (parentInfo.pendingStartArray) {
            this.writeStartArray(fieldName);
        }
        try {
            if (!parentInfo.isArray()) {
                if (!parentInfo.startObjectWritten) {
                    this.target.startObject();
                    parentInfo.startObjectWritten = true;
                }
            } else if (this.autoEndArray && !fieldName.equals(parentInfo.getArrayName())) {
                this.writeEndArray();
            }
            if (!parentInfo.isArray()) {
                this.target.name(fieldName);
            } else {
                parentInfo.incArraySize();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write start element: " + fieldName, e);
        }
        return new ScopeInfo();
    }

    @Override
    protected void writeStartElementTagEnd() throws XMLStreamException {
        if (this.getScope().isEmptyElement()) {
            this.writeEndElementTag();
        }
    }

    @Override
    protected void writeEndElementTag() throws XMLStreamException {
        try {
            if (((ScopeInfo)this.getScope().getInfo()).hasData()) {
                if (this.xmlNilReadWriteEnabled && XML_SCHEMA_NIL_VALUE.equals(((ScopeInfo)this.getScope().getInfo()).getData())) {
                    this.target.value(null);
                    return;
                }
                if (((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                    this.target.name("$");
                }
                this.target.value(((ScopeInfo)this.getScope().getInfo()).getData());
            }
            if (this.autoEndArray && ((ScopeInfo)this.getScope().getInfo()).isArray()) {
                this.writeEndArray();
            }
            if (((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.endObject();
            } else if (!((ScopeInfo)this.getScope().getInfo()).hasData()) {
                if (this.xmlWriteNullForEmptyElement) {
                    this.target.value(null);
                } else {
                    this.target.value("");
                }
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write end element: " + this.getFieldName(this.getScope().getPrefix(), this.getScope().getLocalName()), e);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.xmlNilReadWriteEnabled && (XSI_NS.equals(namespaceURI) || "".equals(namespaceURI)) && XSI_NIL.equals(localName) && "true".equals(value)) {
            ((ScopeInfo)this.getScope().getInfo()).setData(XML_SCHEMA_NIL_VALUE);
            return;
        }
        super.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.xmlNilReadWriteEnabled && XSI_NS.equals(namespaceURI)) {
            return;
        }
        super.writeNamespace(prefix, namespaceURI);
    }

    @Override
    protected void writeAttr(String prefix, String localName, String namespaceURI, String value) throws XMLStreamException {
        String name = "".equals(prefix) ? localName : prefix + this.namespaceSeparator + localName;
        try {
            if (!((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.startObject();
                ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
            }
            this.target.name('@' + name);
            this.target.value(value);
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write attribute: " + name, e);
        }
    }

    @Override
    protected void writeNsDecl(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.namespaceDeclarations) {
            try {
                if (!((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                    this.target.startObject();
                    ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
                }
                if ("".equals(prefix)) {
                    this.target.name("@xmlns");
                } else {
                    this.target.name("@xmlns" + this.namespaceSeparator + prefix);
                }
                this.target.value(namespaceURI);
            }
            catch (IOException e) {
                throw new XMLStreamException("Cannot write namespace declaration: " + namespaceURI, e);
            }
        }
    }

    @Override
    protected void writeData(Object data, int type) throws XMLStreamException {
        switch (type) {
            case 4: 
            case 12: {
                if (this.getScope().isRoot() && !this.isStartDocumentWritten()) {
                    try {
                        this.target.value(data);
                        break;
                    }
                    catch (IOException e) {
                        throw new XMLStreamException("Cannot write data", e);
                    }
                }
                if (data == null) {
                    throw new XMLStreamException("Cannot write null data");
                }
                if (this.getScope().getLastChild() != null) {
                    if (this.skipSpace && JsonXMLStreamWriter.isWhitespace(data)) break;
                    throw new XMLStreamException("Mixed content is not supported: '" + data + "'");
                }
                if (((ScopeInfo)this.getScope().getInfo()).hasData()) {
                    if (data instanceof String) {
                        ((ScopeInfo)this.getScope().getInfo()).addText(data.toString());
                        break;
                    }
                    throw new XMLStreamException("Cannot append primitive data: " + data);
                }
                ((ScopeInfo)this.getScope().getInfo()).setData(data);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot write data of type " + type);
            }
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        try {
            this.target.startObject();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot start document", e);
        }
        ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        try {
            if (((ScopeInfo)this.getScope().getInfo()).isArray()) {
                this.target.endArray();
            }
            this.target.endObject();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot end document", e);
        }
        ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = false;
    }

    public void writeStartArray(String fieldName) throws XMLStreamException {
        if (this.autoEndArray && ((ScopeInfo)this.getScope().getInfo()).isArray()) {
            this.writeEndArray();
        }
        ((ScopeInfo)this.getScope().getInfo()).startArray(fieldName);
        ((ScopeInfo)this.getScope().getInfo()).pendingStartArray = false;
        try {
            if (!((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.startObject();
                ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
            }
            this.target.name(fieldName);
            this.target.startArray();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot start array: " + fieldName, e);
        }
    }

    public void writeEndArray() throws XMLStreamException {
        ((ScopeInfo)this.getScope().getInfo()).endArray();
        try {
            this.target.endArray();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot end array: " + ((ScopeInfo)this.getScope().getInfo()).getArrayName(), e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
        try {
            if (this.documentArray) {
                this.target.endArray();
            }
            this.target.close();
        }
        catch (IOException e) {
            throw new XMLStreamException("Close failed", e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.target.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException("Flush failed", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writePI(String target, String data) throws XMLStreamException {
        if (!this.multiplePI || !"xml-multiple".equals(target)) return;
        if (this.getScope().isRoot() && !this.isStartDocumentWritten()) {
            if (data != null && !data.trim().isEmpty()) throw new XMLStreamException("Cannot specify name in document array: " + data);
            try {
                this.target.startArray();
                this.documentArray = true;
                return;
            }
            catch (IOException e) {
                throw new XMLStreamException("Cannot start document array", e);
            }
        } else if (data == null || data.trim().isEmpty()) {
            ((ScopeInfo)this.getScope().getInfo()).pendingStartArray = true;
            return;
        } else {
            this.writeStartArray(data.trim());
        }
    }

    public void writeNumber(Number value) throws XMLStreamException {
        if (((ScopeInfo)this.getScope().getInfo()).hasData()) {
            throw new XMLStreamException("Cannot write number value");
        }
        super.writeCharacters(value, 4);
    }

    public void writeBoolean(Boolean value) throws XMLStreamException {
        if (((ScopeInfo)this.getScope().getInfo()).hasData()) {
            throw new XMLStreamException("Cannot write boolean value");
        }
        super.writeCharacters(value, 4);
    }

    static class ScopeInfo
    extends JsonXMLStreamScopeInfo {
        private Object leadData = null;
        private StringBuilder builder = null;
        boolean startObjectWritten = false;
        boolean pendingStartArray = false;

        ScopeInfo() {
        }

        void addText(String data) {
            if (this.leadData == null) {
                this.leadData = data;
            } else {
                if (this.builder == null) {
                    this.builder = new StringBuilder(this.leadData.toString());
                }
                this.builder.append(data);
            }
        }

        boolean hasData() {
            return this.leadData != null;
        }

        Object getData() {
            return this.builder == null ? (this.hasData() ? this.leadData : null) : this.builder.toString();
        }

        void setData(Object data) {
            this.leadData = data;
            this.builder = null;
        }
    }
}

