/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamSource;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.impl.Constants;

public abstract class JsonStreamFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMetaInfServicesClassName(Class<?> serviceInterface, ClassLoader classLoader) {
        String serviceId = "META-INF/services/" + serviceInterface.getName();
        InputStream input = classLoader.getResourceAsStream(serviceId);
        if (input == null) return null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            try {
                String string = reader.readLine();
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            try {
                input.close();
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJavaHomeLibClassName(Class<?> serviceInterface, String bundleName) {
        String home = System.getProperty("java.home");
        if (home != null) {
            InputStream input = null;
            String path = home + File.separator + "lib" + File.separator + bundleName + ".properties";
            File file = new File(path);
            try {
                if (file.exists()) {
                    input = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(input);
                    String string = props.getProperty(serviceInterface.getName());
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static JsonStreamFactory newFactory() throws FactoryConfigurationError {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            classLoader = JsonStreamFactory.class.getClassLoader();
        }
        String className = JsonStreamFactory.getMetaInfServicesClassName(JsonStreamFactory.class, classLoader);
        if (className == null || className.trim().length() == 0) {
            className = JsonStreamFactory.getJavaHomeLibClassName(JsonStreamFactory.class, "staxon");
        }
        if (className == null || className.trim().length() == 0) {
            try {
                className = System.getProperty(JsonStreamFactory.class.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (className == null || className.trim().length() == 0) {
            className = "org.apache.synapse.commons.staxon.core.json.stream.impl.JsonStreamFactoryImpl";
        }
        try {
            return (JsonStreamFactory)classLoader.loadClass(className).newInstance();
        }
        catch (Throwable e) {
            throw new FactoryConfigurationError("Error creating stream factory: " + e);
        }
    }

    public abstract JsonStreamSource createJsonStreamSource(InputStream var1) throws IOException;

    public abstract JsonStreamSource createJsonStreamSource(InputStream var1, Constants.SCANNER var2) throws IOException;

    public abstract JsonStreamSource createJsonStreamSource(Reader var1) throws IOException;

    public abstract JsonStreamSource createJsonStreamSource(Reader var1, Constants.SCANNER var2) throws IOException;

    public abstract JsonStreamTarget createJsonStreamTarget(OutputStream var1, boolean var2) throws IOException;

    public abstract JsonStreamTarget createJsonStreamTarget(Writer var1, boolean var2) throws IOException;
}

