/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import java.util.Map;

public abstract class Node {
    protected String token;
    protected Node next;
    protected boolean hasQueryTemplate = false;

    protected Node(String token) {
        this.token = token;
    }

    public void setNext(Node next) {
        this.next = next;
    }

    public String expandAll(Map<String, String> variables) {
        StringBuilder builder = new StringBuilder();
        Node currentNode = this;
        while (currentNode != null) {
            builder.append(currentNode.expand(variables));
            currentNode = currentNode.next;
        }
        return builder.toString();
    }

    public int matchAll(String uriFragment, Map<String, String> variables) {
        int matchLength = this.match(uriFragment, variables);
        if (matchLength < 0) {
            return -1;
        }
        if (matchLength < uriFragment.length()) {
            if (this.next != null) {
                uriFragment = uriFragment.substring(matchLength);
                return matchLength + this.next.matchAll(uriFragment, variables);
            }
            if (uriFragment.endsWith("/")) {
                ++matchLength;
            }
            return matchLength;
        }
        if (matchLength == uriFragment.length() && this.next != null) {
            if (this.next.getToken().equalsIgnoreCase("*")) {
                return matchLength;
            }
            if (this.next.getToken().equalsIgnoreCase("/*")) {
                return matchLength;
            }
            if (this.next.getToken().startsWith("{") && uriFragment.contains("=")) {
                uriFragment = uriFragment.substring(matchLength);
                return matchLength + this.next.matchAll(uriFragment, variables);
            }
            return -1;
        }
        return matchLength;
    }

    public boolean hasQueryTemplate() {
        return this.next != null ? this.hasQueryTemplate || this.next.hasQueryTemplate() : this.hasQueryTemplate;
    }

    abstract String expand(Map<String, String> var1);

    abstract int match(String var1, Map<String, String> var2);

    abstract String getToken();

    abstract char getFirstCharacter();
}

