/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.DistributedCounterManager;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class SharedParamManager {
    private static Map<String, Long> counters = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> timestamps = new ConcurrentHashMap<String, Long>();
    private static Log log = LogFactory.getLog((String)SharedParamManager.class.getName());

    private SharedParamManager() {
    }

    public static long getDistributedCounter(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET TIMESTAMP WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            return distributedCounterManager.getCounter(id);
        }
        Long counter = counters.get(id);
        if (counter != null) {
            return counter;
        }
        counters.put(id, 0L);
        return 0L;
    }

    public static void setDistributedCounter(String id, long value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.setCounter(id, value);
        } else {
            counters.put(id, value);
        }
    }

    public static void setDistributedCounterWithExpiry(String id, long value, long expiryTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.setCounterWithExpiry(id, value, expiryTime);
        } else {
            counters.put(id, value);
        }
    }

    public static void setSharedTimestampWithExpiry(String id, long timestamp, long expiryTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the shared timestamp of key " + id + " with value " + timestamp + " with an expiry time of " + expiryTime));
        }
        String key = "startedTime-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.setTimestampWithExpiry(key, timestamp, expiryTime);
        } else {
            timestamps.put(id, timestamp);
        }
    }

    public static long addAndGetDistributedCounter(String id, long value) {
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        id = "sharedCounter-" + id;
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            return distributedCounterManager.addAndGetCounter(id, value);
        }
        long currentCount = counters.get(id);
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return updatedCount;
    }

    public static long asyncGetAndAddDistributedCounter(String id, long value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ASYNC CREATING AND SETTING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            return distributedCounterManager.asyncGetAndAddCounter(id, value);
        }
        Long currentCount = counters.get(id);
        if (currentCount == null) {
            currentCount = 0L;
        }
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return currentCount;
    }

    public static long asyncGetAndAlterDistributedCounter(String id, long value) {
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            return distributedCounterManager.asyncGetAndAlterCounter(id, value);
        }
        Long currentCount = counters.get(id);
        if (currentCount == null) {
            currentCount = 0L;
        }
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return currentCount;
    }

    public static void removeCounter(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REMOVING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.removeCounter(id);
        } else {
            counters.remove(id);
        }
    }

    public static long getSharedTimestamp(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET TIMESTAMP WITH ID " + id));
        }
        String key = "startedTime-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            return distributedCounterManager.getTimestamp(key);
        }
        Long timestamp = timestamps.get(key);
        if (timestamp != null) {
            return timestamp;
        }
        timestamps.put(key, 0L);
        return 0L;
    }

    public static void setSharedTimestamp(String id, long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING TIMESTAMP WITH ID" + id));
        }
        String key = "startedTime-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.setTimestamp(key, timestamp);
        } else {
            timestamps.put(id, timestamp);
        }
    }

    public static void removeTimestamp(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REMOVING TIMESTAMP WITH ID " + id));
        }
        String key = "startedTime-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.removeTimestamp(key);
        } else {
            timestamps.remove(key);
        }
    }

    public static void setExpiryTime(String id, long expiryTimeStamp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING Expiry WITH ID " + id));
        }
        String sharedCounterKey = "sharedCounter-" + id;
        String sharedTimeStampKey = "startedTime-" + id;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Setting expiry time for key:" + sharedCounterKey + " value: " + expiryTimeStamp));
            }
            distributedCounterManager.setExpiry(sharedCounterKey, expiryTimeStamp);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Setting expiry time for key:" + sharedTimeStampKey + " value: " + expiryTimeStamp));
            }
            distributedCounterManager.setExpiry(sharedTimeStampKey, expiryTimeStamp);
        }
    }

    public static long getTtl(String key) {
        long ttl = 0L;
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            ttl = distributedCounterManager.getTtl(key);
        }
        return ttl;
    }

    public static boolean lockSharedKeys(String callerContextId, String lockValue) {
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            String lockKey = "lock-" + callerContextId;
            long startTime = System.currentTimeMillis();
            while (true) {
                boolean lockAcquired;
                if (lockAcquired = distributedCounterManager.setLockWithExpiry(lockKey, lockValue, System.currentTimeMillis() + distributedCounterManager.getKeyLockRetrievalTimeout() * 2L)) {
                    if (log.isTraceEnabled()) {
                        long timeNow = System.currentTimeMillis();
                        log.trace((Object)("current time:" + timeNow + "Lock acquired for key: " + lockKey + " within " + (timeNow - startTime) + " ms"));
                    }
                    return true;
                }
                long time = System.currentTimeMillis();
                long timeElapsed = time - startTime;
                if (timeElapsed > distributedCounterManager.getKeyLockRetrievalTimeout()) {
                    log.warn((Object)("current time:" + time + " Unable to acquire lock for key: " + lockKey + " within the configured timeout period. Elapsed time: " + timeElapsed + " ms"));
                    return false;
                }
                try {
                    Thread.sleep(5L);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("current time:" + time + "Retrying to get lock for key: " + lockKey));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    public static void releaseSharedKeys(String callerContextId) {
        DistributedCounterManager distributedCounterManager = ThrottleServiceDataHolder.getInstance().getDistributedCounterManager();
        if (distributedCounterManager != null && distributedCounterManager.isEnable()) {
            distributedCounterManager.removeLock(callerContextId);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current time:" + System.currentTimeMillis() + "Lock released for key: " + callerContextId));
            }
        }
    }
}

