/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.SharedParamManager;
import org.apache.synapse.commons.throttle.core.ThrottleDataHolder;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class ThrottleWindowReplicator {
    private static final Log log = LogFactory.getLog(ThrottleWindowReplicator.class);
    private static int replicatorPoolSize;
    private ConfigurationContext configContext;
    private ThrottleProperties throttleProperties;
    private int replicatorCount;
    private Set<String> set = new ConcurrentSkipListSet<String>();

    public ThrottleWindowReplicator() {
        this.throttleProperties = ThrottleServiceDataHolder.getInstance().getThrottleProperties();
        replicatorPoolSize = Integer.parseInt(this.throttleProperties.getWindowReplicatorPoolSize());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Throttle window replicator pool size set to " + replicatorPoolSize));
        }
        if (ThrottleServiceDataHolder.getInstance().getThrottleProperties().isThrottleSyncAsyncHybridModeEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Throttle Sync Async Hybrid Mode is enabled. So throttle window replicator task will not be scheduled.");
            }
            return;
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(replicatorPoolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Throttle window replicator - " + ThrottleWindowReplicator.this.replicatorCount++);
                return t;
            }
        });
        String windowReplicationFrequency = this.throttleProperties.getWindowReplicatorFrequency();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Throttling window replication frequency set to " + windowReplicationFrequency));
        }
        for (int i = 0; i < replicatorPoolSize; ++i) {
            executor.scheduleAtFixedRate(new ReplicatorTask(), Integer.parseInt(windowReplicationFrequency), Integer.parseInt(windowReplicationFrequency), TimeUnit.MILLISECONDS);
        }
    }

    public void setConfigContext(ConfigurationContext configContext) {
        if (this.configContext == null) {
            this.configContext = configContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key) {
        if (this.configContext == null) {
            throw new IllegalStateException("ConfigurationContext has not been set");
        }
        String string = key.intern();
        synchronized (string) {
            this.set.add(key);
        }
        if (log.isDebugEnabled()) {
            log.trace((Object)("Adding key " + key + " to replication list"));
        }
    }

    private class ReplicatorTask
    implements Runnable {
        private ReplicatorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                log.debug((Object)"Start running ThrottleWindowReplicatorTask.");
                if (ThrottleWindowReplicator.this.set.isEmpty()) return;
                for (String key : ThrottleWindowReplicator.this.set) {
                    String string = key.intern();
                    synchronized (string) {
                        ThrottleDataHolder dataHolder = (ThrottleDataHolder)ThrottleWindowReplicator.this.configContext.getProperty("throttle_info");
                        CallerContext callerContext = dataHolder.getCallerContext(key);
                        if (callerContext != null) {
                            String callerId = callerContext.getId();
                            long sharedTimestamp = SharedParamManager.getSharedTimestamp(callerContext.getId());
                            long sharedNextWindow = sharedTimestamp + callerContext.getUnitTime();
                            long localFirstAccessTime = callerContext.getFirstAccessTime();
                            if (localFirstAccessTime < sharedTimestamp) {
                                callerContext.setFirstAccessTime(sharedTimestamp);
                                callerContext.setNextTimeWindow(sharedNextWindow);
                                callerContext.setGlobalCounter(SharedParamManager.getDistributedCounter(callerId));
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Setting time windows of caller context when window already set=" + callerId));
                                }
                            } else if (localFirstAccessTime > sharedTimestamp && localFirstAccessTime < sharedNextWindow) {
                                callerContext.setFirstAccessTime(sharedTimestamp);
                                callerContext.setNextTimeWindow(sharedNextWindow);
                                callerContext.setGlobalCounter(SharedParamManager.getDistributedCounter(callerId));
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Setting time windows of caller context in intermediate interval=" + callerId));
                                }
                            } else {
                                SharedParamManager.setSharedTimestamp(callerId, localFirstAccessTime);
                                SharedParamManager.setDistributedCounter(callerId, 0L);
                                SharedParamManager.setExpiryTime(callerId, callerContext.getUnitTime() + localFirstAccessTime);
                                callerContext.resetGlobalCounter();
                                callerContext.setLocalCounter(1L);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Complete resetting time window of=" + callerId));
                                }
                            }
                        }
                        ThrottleWindowReplicator.this.set.remove(key);
                    }
                }
                return;
            }
            catch (Throwable t) {
                log.error((Object)"Could not replicate throttle data", t);
            }
        }
    }
}

