/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.DistributedCounterManager;
import org.apache.synapse.commons.throttle.core.ThrottleUtil;
import org.apache.synapse.commons.throttle.core.internal.DistributedThrottleProcessor;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="throttle.core.services", immediate=true)
public class ThrottleServiceComponent {
    private static final Log log = LogFactory.getLog((String)ThrottleServiceComponent.class.getName());

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating throttle core service component");
        if (ThrottleServiceDataHolder.getInstance().getThrottleProperties() == null) {
            ThrottleServiceDataHolder.getInstance().setThrottleProperties(ThrottleUtil.loadThrottlePropertiesFromConfigurations());
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        log.debug((Object)"Deactivating throttle core service component");
    }

    @Reference(name="distributedCounterManager.instance.service", service=DistributedCounterManager.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeDistributedCounterManagerInstance")
    protected void addDistributedCounterManagerInstance(DistributedCounterManager distributedCounterManager) {
        ThrottleServiceDataHolder.getInstance().addDistributedCounterManager(distributedCounterManager);
    }

    protected void removeDistributedCounterManagerInstance(DistributedCounterManager distributedCounterManager) {
        ThrottleServiceDataHolder.getInstance().removeDistributedCounterManager(distributedCounterManager);
    }

    @Reference(name="distributedThrottleProcessor.instance.service", service=DistributedThrottleProcessor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeDistributedThrottleProcessorInstance")
    protected void addDistributedThrottleProcessorInstance(DistributedThrottleProcessor distributedThrottleProcessor) {
        ThrottleServiceDataHolder.getInstance().addDistributedThrottleProcessor(distributedThrottleProcessor);
    }

    protected void removeDistributedThrottleProcessorInstance(DistributedThrottleProcessor distributedThrottleProcessor) {
        ThrottleServiceDataHolder.getInstance().removeDistributedThrottleProcessor(distributedThrottleProcessor);
    }
}

