/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonDataSource;
import org.apache.synapse.commons.json.JsonStreamFormatter;
import org.apache.synapse.commons.json.JsonUtil;

public final class JsonFormatter
implements MessageFormatter {
    private static final Log logger = LogFactory.getLog((String)JsonFormatter.class.getName());

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat omOutputFormat) throws AxisFault {
        byte[] json;
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        if (element == null) {
            json = new JsonStreamFormatter().getBytes(messageContext, omOutputFormat);
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonUtil.writeAsJson(element, (OutputStream)outputStream);
            json = outputStream.toByteArray();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#getBytes. Converted XML payload to JSON byte array. MessageID: " + messageContext.getMessageID()));
        }
        return json;
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat omOutputFormat, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        if (element == null) {
            if (preserve) {
                messageContext.setProperty("preserve.json.stream", (Object)true);
            }
            JsonUtil.writeAsJson(messageContext, outputStream);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("#writeTo. Wrote JSON stream to output stream. MessageID: " + messageContext.getMessageID()));
            }
            return;
        }
        if (element instanceof OMSourcedElementImpl) {
            try {
                OMDataSource dataSource = ((OMSourcedElementImpl)element).getDataSource();
                if (dataSource instanceof JsonDataSource) {
                    dataSource.serialize(outputStream, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("#writeTo. Wrote JSON DataSource to output stream. MessageID: " + messageContext.getMessageID()));
                    }
                    return;
                }
            }
            catch (XMLStreamException e) {
                logger.error((Object)("#writeTo. Could not write JSON message. MessageID: " + messageContext.getMessageID() + ". Error>>> " + e.getLocalizedMessage()));
                throw new AxisFault("Could not Write JSON message.", (Throwable)e);
            }
        }
        JsonUtil.writeAsJson(element, outputStream);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#writeTo. Converted XML payload to JSON output stream. MessageID: " + messageContext.getMessageID()));
        }
    }

    public static void toJson(OMElement element, OutputStream outputStream) throws AxisFault {
        JsonUtil.writeAsJson(element.cloneOMElement(), outputStream);
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapActionString) {
        String contentType = (String)messageContext.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)messageContext.getProperty("messageType");
        }
        String setEncoding = (String)messageContext.getProperty("setCharacterEncoding");
        if (encoding != null && !"false".equals(setEncoding) && contentType != null && !contentType.contains("charset")) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat omOutputFormat, URL url) throws AxisFault {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"#getTargetAddress. Not implemented. #getTargetAddress()");
        }
        return url;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"#formatSOAPAction. Not implemented. #formatSOAPAction()");
        }
        return null;
    }
}

