/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.validators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.DataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;

public class StringValidator {
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String STR_PATTERN = "pattern";

    private StringValidator() {
    }

    public static JsonPrimitive validateNominal(JsonObject inputObject, String value) throws ValidatorException, ParserException {
        JsonArray enumElements;
        String patternString;
        String minLengthString;
        String maxLengthString;
        if (value == null) {
            throw new ValidatorException("Expected a string in the schema " + inputObject.toString() + " but found null input");
        }
        if (inputObject.has(MAX_LENGTH) && !(maxLengthString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(MAX_LENGTH).getAsString())).isEmpty()) {
            int maxLength = DataTypeConverter.convertToInt(maxLengthString);
            if (value.length() > maxLength) {
                throw new ValidatorException("String \"" + value + "\" violated the max length constraint. Input string : " + value + " violated the maxLength constraint defined in : " + inputObject.toString());
            }
        }
        if (inputObject.has(MIN_LENGTH) && !(minLengthString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(MIN_LENGTH).getAsString())).isEmpty()) {
            int minLength = DataTypeConverter.convertToInt(minLengthString);
            if (value.length() < minLength) {
                throw new ValidatorException("String \"" + value + "\" violated the min length constraint. Input string : " + value + " violated the minLength constraint defined in : " + inputObject.toString());
            }
        }
        if (inputObject.has(STR_PATTERN) && !(patternString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(STR_PATTERN).getAsString())).isEmpty() && !value.matches(patternString)) {
            throw new ValidatorException("String \"" + value + "\" violated the regex constraint " + patternString + ". Input string : " + value + " not matching with any regex defined in : " + inputObject.toString());
        }
        if (inputObject.has("enum") && (enumElements = inputObject.getAsJsonArray("enum")).size() > 0 && !enumElements.contains((JsonElement)new JsonPrimitive(value))) {
            throw new ValidatorException("String \"" + value + "\" not contains any element from the enum. Input string : " + value + " not contains any value defined in the enum of : " + inputObject.toString());
        }
        if (inputObject.has("const") && !value.equals(inputObject.getAsJsonPrimitive("const").getAsString())) {
            throw new ValidatorException("String \"" + value + "\" is not equal to the const value. Input string : " + value + " not contains the const value defined in : " + inputObject.toString());
        }
        return new JsonPrimitive(value);
    }
}

