/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.base;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.synapse.commons.staxon.core.base.XMLStreamReaderScope;

public abstract class AbstractXMLStreamReader<T>
implements XMLStreamReader {
    private static final Location UNKNOWN_LOCATION = new Location(){

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };
    private final Queue<Event> queue = new LinkedList<Event>();
    private final Location locationProvider;
    private XMLStreamReaderScope<T> scope;
    private boolean moreTokens;
    private Event event;
    private boolean startDocumentRead;
    private String encodingScheme;
    private String version;
    private Boolean standalone;

    static String getEventName(int type) {
        switch (type) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return String.valueOf(type);
    }

    static boolean hasData(int type) {
        return type == 4 || type == 5 || type == 12 || type == 11 || type == 9 || type == 6;
    }

    public AbstractXMLStreamReader(T rootInfo) {
        this(rootInfo, UNKNOWN_LOCATION);
    }

    public AbstractXMLStreamReader(T rootInfo, Location locationProvider) {
        this.scope = new XMLStreamReaderScope<T>("", rootInfo);
        this.locationProvider = locationProvider;
    }

    private void ensureStartTagClosed() throws XMLStreamException {
        if (!this.scope.isStartTagClosed()) {
            this.scope.setStartTagClosed(true);
        }
    }

    protected XMLStreamReaderScope<T> getScope() {
        return this.scope;
    }

    protected boolean isStartDocumentRead() {
        return this.startDocumentRead;
    }

    protected void initialize() throws XMLStreamException {
        try {
            this.moreTokens = this.consume();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        this.event = this.hasNext() ? this.queue.remove() : new Event(8, this.scope);
    }

    protected abstract boolean consume() throws XMLStreamException, IOException;

    protected void readStartDocument(String version, String encodingScheme, Boolean standalone) throws XMLStreamException {
        if (this.startDocumentRead || !this.scope.isRoot()) {
            throw new XMLStreamException("Cannot start document", this.locationProvider);
        }
        this.queue.add(new Event(7, this.scope));
        this.startDocumentRead = true;
        this.version = version;
        this.encodingScheme = encodingScheme;
        this.standalone = standalone;
    }

    protected void readStartElementTag(String prefix, String localName, String namespaceURI, T scopeInfo) throws XMLStreamException {
        if (prefix == null && namespaceURI == null) {
            throw new IllegalArgumentException("at least one of prefix and namespaceURI must not be null!");
        }
        this.ensureStartTagClosed();
        this.scope = new XMLStreamReaderScope<T>(this.scope, prefix, localName, namespaceURI);
        this.scope.setInfo(scopeInfo);
        this.queue.add(new Event(1, this.scope));
    }

    protected void readAttr(String prefix, String localName, String namespaceURI, String value) throws XMLStreamException {
        if (prefix == null && namespaceURI == null) {
            throw new IllegalArgumentException("at least one of prefix and namespaceURI must not be null!");
        }
        this.scope.addAttribute(prefix, localName, namespaceURI, value);
    }

    protected void readNsDecl(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.scope.isStartTagClosed()) {
            throw new XMLStreamException("Cannot read namespace: element has children or text", this.locationProvider);
        }
        if (prefix == null || namespaceURI == null) {
            throw new IllegalArgumentException("at least one of prefix and namespaceURI must not be null!");
        }
        this.scope.addNamespaceURI(prefix, namespaceURI);
        this.scope.setPrefix(prefix, namespaceURI);
    }

    protected void readData(String text, Object data, int type) throws XMLStreamException {
        if (!AbstractXMLStreamReader.hasData(type)) {
            throw new XMLStreamException("Unexpected event type " + this.getEventName(), this.locationProvider);
        }
        this.queue.add(new Event(type, this.scope, text, data));
    }

    protected void readPI(String target, String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        String text = data == null ? target : target + ':' + data;
        this.queue.add(new Event(3, this.scope, text, null));
    }

    protected void readEndElementTag() throws XMLStreamException {
        this.ensureStartTagClosed();
        this.queue.add(new Event(2, this.scope));
        this.scope = this.scope.getParent();
    }

    protected void readEndDocument() throws XMLStreamException {
        if (!this.startDocumentRead || !this.scope.isRoot()) {
            throw new XMLStreamException("Cannot end document", this.locationProvider);
        }
        this.queue.add(new Event(8, this.scope));
        this.startDocumentRead = false;
    }

    @Override
    public void require(int eventType, String namespaceURI, String localName) throws XMLStreamException {
        if (eventType != this.getEventType()) {
            throw new XMLStreamException("Expected event type " + AbstractXMLStreamReader.getEventName(eventType) + ", was " + AbstractXMLStreamReader.getEventName(this.getEventType()), this.getLocation());
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Expected namespace " + namespaceURI + ", was " + this.getNamespaceURI(), this.getLocation());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("Expected local name " + localName + ", was " + this.getLocalName(), this.getLocation());
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        this.require(1, null, null);
        StringBuilder builder = null;
        String leadText = null;
        block5: while (true) {
            switch (this.next()) {
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    if (leadText == null) {
                        leadText = this.getText();
                        continue block5;
                    }
                    if (builder == null) {
                        builder = new StringBuilder(leadText);
                    }
                    builder.append(this.getText());
                    continue block5;
                }
                case 3: 
                case 5: {
                    continue block5;
                }
                case 2: {
                    return builder == null ? leadText : builder.toString();
                }
            }
            break;
        }
        throw new XMLStreamException("Unexpected event type " + this.getEventName(), this.getLocation());
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        try {
            while (this.queue.isEmpty() && this.moreTokens) {
                this.moreTokens = this.consume();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e.getMessage(), this.locationProvider, e);
        }
        return !this.queue.isEmpty();
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more events");
        }
        this.event = this.queue.remove();
        return this.event.getType();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (!this.isStartElement() && !this.isEndElement()) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public void close() throws XMLStreamException {
        this.scope = null;
        this.queue.clear();
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.getEventType() == 4 || this.getEventType() == 12) {
            for (char ch : this.getText().toCharArray()) {
                if (Character.isWhitespace(ch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getAttributeCount() {
        return this.event.getScope().getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.event.getScope().getAttributeName(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.getAttributeName(index).getLocalPart();
    }

    @Override
    public String getAttributeValue(int index) {
        return this.event.getScope().getAttributeValue(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.getAttributeName(index).getPrefix();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.getAttributeName(index).getNamespaceURI();
    }

    @Override
    public String getAttributeType(int index) {
        return null;
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return index < this.getAttributeCount();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.event.getScope().getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.event.getScope().getNamespaceURI(prefix);
    }

    @Override
    public int getNamespaceCount() {
        return this.hasName() ? this.event.getScope().getNamespaceCount() : 0;
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.hasName() ? this.event.getScope().getNamespacePrefix(index) : null;
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.hasName() ? this.event.getScope().getNamespaceURI(index) : null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.event.getScope();
    }

    @Override
    public int getEventType() {
        return this.event.getType();
    }

    protected String getEventName() {
        return AbstractXMLStreamReader.getEventName(this.getEventType());
    }

    protected final Object getEventData() {
        return this.event.getData();
    }

    @Override
    public Location getLocation() {
        return this.event.getLocation();
    }

    @Override
    public boolean hasText() {
        return AbstractXMLStreamReader.hasData(this.getEventType());
    }

    @Override
    public String getText() {
        return this.hasText() ? this.event.getText() : null;
    }

    @Override
    public char[] getTextCharacters() {
        return this.hasText() ? this.event.getText().toCharArray() : null;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        int count = Math.min(length, this.getTextLength());
        if (count > 0) {
            System.arraycopy(this.getTextCharacters(), sourceStart, target, targetStart, count);
        }
        return count;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.hasText() ? this.event.getText().length() : 0;
    }

    @Override
    public boolean hasName() {
        return this.getEventType() == 1 || this.getEventType() == 2;
    }

    @Override
    public QName getName() {
        return this.hasName() ? new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix()) : null;
    }

    @Override
    public String getLocalName() {
        return this.hasName() ? this.event.getScope().getLocalName() : null;
    }

    @Override
    public String getNamespaceURI() {
        return this.hasName() ? this.event.getScope().getNamespaceURI() : null;
    }

    @Override
    public String getPrefix() {
        return this.hasName() ? this.event.getScope().getPrefix() : null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return this.standaloneSet() ? this.standalone : false;
    }

    @Override
    public boolean standaloneSet() {
        return this.standalone != null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.encodingScheme;
    }

    @Override
    public String getPITarget() {
        if (this.event.getType() != 3) {
            return null;
        }
        int colon = this.event.getText().indexOf(58);
        return colon < 0 ? this.event.getText() : this.event.getText().substring(0, colon);
    }

    @Override
    public String getPIData() {
        if (this.event.getType() != 3) {
            return null;
        }
        int colon = this.event.getText().indexOf(58);
        return colon < 0 ? null : this.event.getText().substring(colon + 1);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getEventName() + ")";
    }

    class Event {
        private final int type;
        private final XMLStreamReaderScope<T> scope;
        private final String text;
        private final Object data;
        private final int lineNumber;
        private final int columnNumber;
        private final int characterOffset;

        Event(int type, XMLStreamReaderScope<T> scope) {
            this(type, scope, null, null);
        }

        Event(int type, XMLStreamReaderScope<T> scope, String text, Object data) {
            this.type = type;
            this.scope = scope;
            this.text = text;
            this.data = data;
            this.lineNumber = AbstractXMLStreamReader.this.locationProvider.getLineNumber();
            this.columnNumber = AbstractXMLStreamReader.this.locationProvider.getColumnNumber();
            this.characterOffset = AbstractXMLStreamReader.this.locationProvider.getCharacterOffset();
        }

        XMLStreamReaderScope<T> getScope() {
            return this.scope;
        }

        int getType() {
            return this.type;
        }

        String getText() {
            return this.text;
        }

        Object getData() {
            return this.data;
        }

        Location getLocation() {
            return new Location(){

                @Override
                public int getLineNumber() {
                    return Event.this.lineNumber;
                }

                @Override
                public int getColumnNumber() {
                    return Event.this.columnNumber;
                }

                @Override
                public int getCharacterOffset() {
                    return Event.this.characterOffset;
                }

                @Override
                public String getPublicId() {
                    return AbstractXMLStreamReader.this.locationProvider.getPublicId();
                }

                @Override
                public String getSystemId() {
                    return AbstractXMLStreamReader.this.locationProvider.getSystemId();
                }
            };
        }

        public String toString() {
            return AbstractXMLStreamReader.getEventName(this.type) + ": " + (this.getText() != null ? this.getText() : AbstractXMLStreamReader.this.getLocalName());
        }
    }
}

