/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.synapse.commons.staxon.core.base.AbstractXMLOutputFactory;
import org.apache.synapse.commons.staxon.core.event.SimpleXMLEventWriter;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfig;
import org.apache.synapse.commons.staxon.core.json.JsonXMLStreamWriter;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamFactory;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.AutoArrayTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.AutoPrimitiveTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.CustomRegexIgnoreAutoPrimitiveTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.CustomRegexMatchReplaceIgnoreAutoPrimitiveTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.RemoveRootTarget;

public class JsonXMLOutputFactory
extends AbstractXMLOutputFactory {
    public static final String PROP_AUTO_ARRAY = "JsonXMLOutputFactory.autoArray";
    public static final String PROP_AUTO_PRIMITIVE = "JsonXMLOutputFactory.autoPrimitive";
    public static final String PROP_MULTIPLE_PI = "JsonXMLOutputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLOutputFactory.virtualRoot";
    public static final String PROP_NAMESPACE_SEPARATOR = "JsonXMLOutputFactory.namespaceSeparator";
    public static final String PROP_NAMESPACE_DECLARATIONS = "JsonXMLOutputFactory.namespaceDeclarations";
    public static final String PROP_PRETTY_PRINT = "JsonXMLOutputFactory.prettyPrint";
    public static final String PROP_CUSTOM_REGEX = "JsonXMLOutputFactory.customRegex";
    public static final String PROP_CUSTOM_REPLACE_REGEX = "JsonXMLOutputFactory.customReplaceRegex";
    public static final String PROP_CUSTOM_REPLACE_SEQUENCE = "JsonXMLOutputFactory.customReplaceSequence";
    private JsonStreamFactory streamFactory;
    private boolean multiplePI;
    private QName virtualRoot;
    private boolean autoArray;
    private boolean autoPrimitive;
    private boolean prettyPrint;
    private char namespaceSeparator;
    private boolean namespaceDeclarations;
    private String customRegex;
    private String customReplaceRegex;
    private String customReplaceSequence;
    private boolean xmlNilReadWriteEnabled;
    private boolean xmlWriteNullForEmptyElement;
    private boolean preserverNamespacesForJson;
    private boolean processNCNames;
    private JsonXMLConfig config;

    public JsonXMLOutputFactory() throws FactoryConfigurationError {
        this(JsonXMLConfig.DEFAULT);
    }

    public JsonXMLOutputFactory(JsonStreamFactory streamFactory) {
        this(JsonXMLConfig.DEFAULT, streamFactory);
    }

    public JsonXMLOutputFactory(JsonXMLConfig config) throws FactoryConfigurationError {
        this(config, JsonStreamFactory.newFactory());
    }

    public JsonXMLOutputFactory(JsonXMLConfig config, JsonStreamFactory streamFactory) {
        this.config = config;
        this.multiplePI = config.isMultiplePI();
        this.virtualRoot = config.getVirtualRoot();
        this.autoArray = config.isAutoArray();
        this.autoPrimitive = config.isAutoPrimitive();
        this.prettyPrint = config.isPrettyPrint();
        this.namespaceSeparator = config.getNamespaceSeparator();
        this.namespaceDeclarations = config.isNamespaceDeclarations();
        this.streamFactory = streamFactory;
        this.customRegex = config.getCustomRegex();
        this.customReplaceRegex = config.getCustomReplaceRegex();
        this.customReplaceSequence = config.getCustomReplaceSequence();
        this.xmlNilReadWriteEnabled = config.isReadWriteXmlNil();
        this.xmlWriteNullForEmptyElement = config.isWriteNullForEmptyElements();
        this.preserverNamespacesForJson = config.isPreserverNamespacesForJson();
        this.processNCNames = config.isProcessNCNames();
        super.setProperty("javax.xml.stream.isRepairingNamespaces", config.isRepairingNamespaces());
    }

    private JsonStreamTarget decorate(JsonStreamTarget target) {
        if (this.virtualRoot != null) {
            target = new RemoveRootTarget(target, this.virtualRoot, this.namespaceSeparator);
        }
        if (this.autoArray) {
            target = new AutoArrayTarget(target);
        }
        if (this.autoPrimitive) {
            target = this.customRegex != null ? new CustomRegexIgnoreAutoPrimitiveTarget(target, false, this.customRegex) : (this.customReplaceRegex != null ? new CustomRegexMatchReplaceIgnoreAutoPrimitiveTarget(target, false, this.customReplaceRegex, this.customReplaceSequence) : new AutoPrimitiveTarget(target, false));
        }
        return target;
    }

    @Override
    public JsonXMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public JsonXMLStreamWriter createXMLStreamWriter(Writer stream) throws XMLStreamException {
        boolean repairNamespaces = Boolean.TRUE.equals(this.getProperty("javax.xml.stream.isRepairingNamespaces"));
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), repairNamespaces, this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations, this.xmlNilReadWriteEnabled, this.xmlWriteNullForEmptyElement);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public JsonXMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
        boolean repairNamespaces = Boolean.TRUE.equals(this.getProperty("javax.xml.stream.isRepairingNamespaces"));
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), repairNamespaces, this.multiplePI, this.namespaceSeparator, this.namespaceDeclarations, this.xmlNilReadWriteEnabled, this.xmlWriteNullForEmptyElement);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventWriter createXMLEventWriter(XMLStreamWriter writer) throws XMLStreamException {
        return new SimpleXMLEventWriter(writer);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return super.isPropertySupported(name) || Arrays.asList(PROP_AUTO_ARRAY, PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT, PROP_NAMESPACE_SEPARATOR, PROP_NAMESPACE_DECLARATIONS, PROP_PRETTY_PRINT, PROP_CUSTOM_REPLACE_REGEX, PROP_CUSTOM_REPLACE_SEQUENCE).contains(name);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            return super.getProperty(name);
        }
        if (PROP_AUTO_ARRAY.equals(name)) {
            return this.autoArray;
        }
        if (PROP_AUTO_PRIMITIVE.equals(name)) {
            return this.autoPrimitive;
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        if (PROP_PRETTY_PRINT.equals(name)) {
            return this.prettyPrint;
        }
        if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            return Character.valueOf(this.namespaceSeparator);
        }
        if (PROP_NAMESPACE_DECLARATIONS.equals(name)) {
            return this.namespaceDeclarations;
        }
        if (PROP_CUSTOM_REGEX.equals(name)) {
            return this.customRegex;
        }
        if (PROP_CUSTOM_REPLACE_REGEX.equals(name)) {
            return this.customReplaceRegex;
        }
        if (PROP_CUSTOM_REPLACE_SEQUENCE.equals(name)) {
            return this.customReplaceSequence;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            super.setProperty(name, value);
        } else if (PROP_AUTO_ARRAY.equals(name)) {
            this.autoArray = (Boolean)value;
        } else if (PROP_AUTO_PRIMITIVE.equals(name)) {
            this.autoPrimitive = (Boolean)value;
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = value instanceof String ? QName.valueOf((String)value) : (QName)value;
        } else if (PROP_PRETTY_PRINT.equals(name)) {
            this.prettyPrint = (Boolean)value;
        } else if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            this.namespaceSeparator = ((Character)value).charValue();
        } else if (PROP_NAMESPACE_DECLARATIONS.equals(name)) {
            this.namespaceDeclarations = (Boolean)value;
        } else if (PROP_CUSTOM_REGEX.equals(name) && value instanceof String) {
            this.customRegex = (String)value;
        } else if (PROP_CUSTOM_REPLACE_REGEX.equals(name) && value instanceof String) {
            this.customReplaceRegex = (String)value;
        } else if (PROP_CUSTOM_REPLACE_SEQUENCE.equals(name) && value instanceof String) {
            this.customReplaceSequence = (String)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }

    public JsonXMLConfig getConfig() {
        return this.config;
    }
}

