/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.util;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamSource;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamToken;
import org.apache.synapse.commons.staxon.core.json.stream.util.StreamSourceDelegate;

public class AddRootSource
extends StreamSourceDelegate {
    private final QName root;
    private final char namespaceSeparator;
    private State state = State.START_DOC;
    private int depth = 0;

    public AddRootSource(JsonStreamSource delegate, QName root, char namespaceSeparator) {
        super(delegate);
        this.root = root;
        this.namespaceSeparator = namespaceSeparator;
    }

    @Override
    public String name() throws IOException {
        if (this.state == State.ROOT_NAME) {
            this.state = State.DELEGATE;
            if ("".equals(this.root.getPrefix())) {
                return this.root.getLocalPart();
            }
            return this.root.getPrefix() + this.namespaceSeparator + this.root.getLocalPart();
        }
        if (this.state == State.ROOT_XMLNS_NAME) {
            this.state = State.ROOT_XMLNS_VALUE;
            if ("".equals(this.root.getPrefix())) {
                return "@xmlns";
            }
            return "@xmlns" + this.namespaceSeparator + this.root.getLocalPart();
        }
        return super.name();
    }

    @Override
    public JsonStreamSource.Value value() throws IOException {
        if (this.state == State.ROOT_XMLNS_VALUE) {
            this.state = State.DELEGATE;
            return new JsonStreamSource.Value(this.root.getNamespaceURI());
        }
        return super.value();
    }

    @Override
    public void startObject() throws IOException {
        if (this.state == State.START_DOC) {
            this.state = State.ROOT_NAME;
        } else {
            if (this.depth == 1 && !"".equals(this.root.getNamespaceURI())) {
                this.state = State.ROOT_XMLNS_NAME;
            }
            super.startObject();
        }
        ++this.depth;
    }

    @Override
    public void endObject() throws IOException {
        if (this.state == State.END_DOC) {
            this.state = null;
            return;
        }
        if (this.depth == 1 && this.state == State.DELEGATE && super.peek() == JsonStreamToken.NONE) {
            this.state = State.END_DOC;
        }
        if (this.state != State.END_DOC) {
            super.endObject();
        }
        --this.depth;
    }

    @Override
    public JsonStreamToken peek() throws IOException {
        if (this.state == null) {
            return JsonStreamToken.NONE;
        }
        switch (this.state) {
            case START_DOC: {
                return JsonStreamToken.START_OBJECT;
            }
            case ROOT_NAME: {
                return JsonStreamToken.NAME;
            }
            case ROOT_XMLNS_NAME: {
                return JsonStreamToken.NAME;
            }
            case ROOT_XMLNS_VALUE: {
                return JsonStreamToken.VALUE;
            }
            case END_DOC: {
                return JsonStreamToken.END_OBJECT;
            }
            case DELEGATE: {
                JsonStreamToken result = super.peek();
                if (this.depth == 1 && result == JsonStreamToken.NONE) {
                    result = JsonStreamToken.END_OBJECT;
                }
                return result;
            }
        }
        throw new IllegalStateException("Unexpected state: " + (Object)((Object)this.state));
    }

    private static enum State {
        START_DOC,
        ROOT_NAME,
        ROOT_XMLNS_NAME,
        ROOT_XMLNS_VALUE,
        DELEGATE,
        END_DOC;

    }
}

