/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.StreamTargetDelegate;

public class CustomRegexIgnoreAutoPrimitiveTarget
extends StreamTargetDelegate {
    private final Pattern number = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?$");
    private final boolean convertAttributes;
    private final Pattern customRegex;
    private String lastName;

    public CustomRegexIgnoreAutoPrimitiveTarget(JsonStreamTarget delegate, boolean convertAttributes, String customRegex) {
        super(delegate);
        this.convertAttributes = convertAttributes;
        this.customRegex = Pattern.compile(customRegex);
    }

    @Override
    public void name(String name) throws IOException {
        this.lastName = name;
        super.name(name);
    }

    @Override
    public void value(Object value) throws IOException {
        if (value instanceof String && (this.convertAttributes || !this.lastName.startsWith("@"))) {
            if (this.customRegex != null && this.customRegex.matcher(value.toString()).matches()) {
                super.value(value);
            } else if (this.number.matcher(value.toString()).matches()) {
                super.value(new BigDecimal(value.toString()));
            } else if ("true".equals(value)) {
                super.value(Boolean.TRUE);
            } else if ("false".equals(value)) {
                super.value(Boolean.FALSE);
            } else if ("null".equals(value)) {
                super.value(null);
            } else {
                super.value(value);
            }
        } else {
            super.value(value);
        }
    }
}

