/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri;

import java.util.Map;
import org.apache.synapse.commons.templates.uri.URITemplateException;
import org.apache.synapse.commons.templates.uri.parser.Node;
import org.apache.synapse.commons.templates.uri.parser.URITemplateParser;

public class URITemplate {
    private Node syntaxTree;
    private boolean allowOptionalQuery;

    public URITemplate(String template) throws URITemplateException {
        if (!"/".equals(template) && template.endsWith("/")) {
            template = template.substring(0, template.length() - 1);
        }
        URITemplateParser parser = new URITemplateParser();
        this.syntaxTree = parser.parse(template);
        this.allowOptionalQuery = !this.syntaxTree.hasQueryTemplate();
    }

    public String expand(Map<String, String> variables) {
        return null;
    }

    public boolean matches(String uri, Map<String, String> variables) {
        int matchLength = this.syntaxTree.matchAll(uri, variables);
        if (matchLength == uri.length()) {
            return true;
        }
        return this.allowOptionalQuery && matchLength > 0 && '?' == uri.charAt(matchLength);
    }
}

