/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.commons.templates.uri.URITemplateException;
import org.apache.synapse.commons.templates.uri.parser.Expression;
import org.apache.synapse.commons.templates.uri.parser.Variable;

public class SimpleStringExpression
extends Expression {
    private static final String ESCAPE_GEN_DELIMS_ONLY = "synapse.allow.subdelims";
    private static final char[] reserved;

    public SimpleStringExpression(String token) throws URITemplateException {
        super(token);
    }

    @Override
    String expand(Map<String, String> variables) {
        boolean emptyString = false;
        StringBuffer buffer = new StringBuffer();
        for (Variable var : this.variableList) {
            String value;
            String name = var.getName();
            if (!variables.containsKey(name)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.getSeparator());
            }
            if ("".equals(value = var.modify(variables.get(name)))) {
                emptyString = true;
            }
            buffer.append(this.encodeValue(value));
        }
        if (buffer.length() == 0 && !emptyString) {
            return null;
        }
        return buffer.toString();
    }

    protected char getSeparator() {
        return ',';
    }

    @Override
    int match(String uriFragment, Map<String, String> variables) {
        int length = uriFragment.length();
        for (int i = 0; i < length; ++i) {
            char ch = uriFragment.charAt(i);
            if (this.isReserved(ch) || this.next != null && ch == this.next.getFirstCharacter()) {
                if (ch == this.getSeparator() && this.variableList.size() > 1) continue;
                if (!this.setVariables(uriFragment.substring(0, i), variables)) {
                    return -1;
                }
                return i;
            }
            if (i != length - 1) continue;
            if (!this.setVariables(uriFragment, variables)) {
                return -1;
            }
            return length;
        }
        return 0;
    }

    protected boolean setVariables(String expressionValue, Map<String, String> variables) {
        String finalValue;
        String name;
        Variable var;
        int i;
        String separator = Pattern.quote(String.valueOf(this.getSeparator()));
        String[] values = expressionValue.split(separator);
        int length = values.length;
        if (length > this.variableList.size()) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            var = (Variable)this.variableList.get(i);
            name = var.getName();
            finalValue = this.decodeValue(values[i]);
            if (variables.containsKey(name) && !finalValue.equals(variables.get(name))) {
                return false;
            }
            if (!var.checkModifier(finalValue)) {
                return false;
            }
            variables.put(name, finalValue);
        }
        if (this.variableList.size() > length) {
            for (i = length; i < this.variableList.size(); ++i) {
                var = (Variable)this.variableList.get(i);
                name = var.getName();
                finalValue = "";
                if (variables.containsKey(name) && !finalValue.equals(variables.get(name))) {
                    return false;
                }
                if (!var.checkModifier(finalValue)) {
                    return false;
                }
                variables.put(name, finalValue);
            }
        }
        return true;
    }

    @Override
    char getFirstCharacter() {
        return '\u0001';
    }

    protected boolean isReserved(char ch) {
        for (char reservedChar : reserved) {
            if (ch != reservedChar) continue;
            return true;
        }
        return false;
    }

    static {
        String genDelimsOnly = System.getProperty(ESCAPE_GEN_DELIMS_ONLY);
        reserved = !StringUtils.isEmpty((String)genDelimsOnly) && Boolean.parseBoolean(genDelimsOnly) ? new char[]{':', '/', '?', '#', '[', ']', '@'} : new char[]{':', '/', '?', '#', '[', ']', '@', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};
    }
}

