/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.AccessInformation;
import org.apache.synapse.commons.throttle.core.CallerConfiguration;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.core.factory.CallerContextFactory;

public class AccessRateController {
    private static Log log = LogFactory.getLog((String)AccessRateController.class.getName());
    private static final String ACCESS_DENIED_TEMPORALLY = "You cannot access this service since you have exceeded the allocated quota.";
    private static final String ACCESS_DENIED = "You cannot access this service since you have been prohibited permanently.";
    private final Object lock = new Object();
    private boolean debugOn = log.isDebugEnabled();
    private static final String SYMBOL_UNDERSCORE = "_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessInformation canAccess(ThrottleContext throttleContext, String callerID, int callerType) throws ThrottleException {
        String type = 0 == callerType ? "IP address" : "domain";
        ThrottleConfiguration throttleConfigurationBean = throttleContext.getThrottleConfiguration();
        AccessInformation accessInformation = new AccessInformation();
        if (throttleConfigurationBean == null) {
            if (this.debugOn) {
                log.debug((Object)"Throttle Configuration couldn't find - Throttling will not occur");
            }
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (callerID == null) {
            String msg = "Caller host or ip  couldn't find !! - Access will be denied ";
            if (this.debugOn) {
                log.debug((Object)msg);
            }
            accessInformation.setAccessAllowed(false);
            accessInformation.setFaultReason(msg);
            return accessInformation;
        }
        String callerAddress = callerID.substring(callerID.lastIndexOf(SYMBOL_UNDERSCORE) + 1);
        CallerConfiguration configuration = throttleConfigurationBean.getCallerConfiguration(callerAddress);
        if (configuration == null) {
            if (this.debugOn) {
                log.debug((Object)("Caller configuration couldn't find for " + type + " and for caller " + callerID));
            }
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (configuration.getAccessState() == 1) {
            log.info((Object)ACCESS_DENIED);
            accessInformation.setAccessAllowed(false);
            accessInformation.setFaultReason(ACCESS_DENIED);
            return accessInformation;
        }
        if (configuration.getAccessState() == 2) {
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (configuration.getAccessState() == 0) {
            Object object = this.lock;
            synchronized (object) {
                CallerContext caller = throttleContext.getCallerContext(callerID);
                if (caller == null) {
                    caller = CallerContextFactory.createCaller(callerType, callerID);
                }
                if (caller != null) {
                    long currentTime = System.currentTimeMillis();
                    if (!caller.canAccess(throttleContext, configuration, currentTime)) {
                        log.info((Object)ACCESS_DENIED_TEMPORALLY);
                        throttleContext.processCleanList(currentTime);
                        accessInformation.setAccessAllowed(false);
                        accessInformation.setFaultReason(ACCESS_DENIED_TEMPORALLY);
                        return accessInformation;
                    }
                    if (this.debugOn) {
                        log.debug((Object)("Access  from " + type + " " + callerID + " is successful."));
                    }
                    accessInformation.setAccessAllowed(true);
                    return accessInformation;
                }
                if (this.debugOn) {
                    log.debug((Object)("Caller " + type + " not found! " + callerID));
                }
                accessInformation.setAccessAllowed(true);
                return accessInformation;
            }
        }
        accessInformation.setAccessAllowed(true);
        return accessInformation;
    }
}

