/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ThrottleDataHolder;

public class ConcurrentAccessUpdateClusterMessage
extends ClusteringMessage {
    private static final Log log = LogFactory.getLog(ConcurrentAccessUpdateClusterMessage.class);
    private String key;
    private Boolean action;

    public ConcurrentAccessUpdateClusterMessage(String key, Boolean action) {
        this.key = key;
        this.action = action;
        log.debug((Object)("Initializing with ConcurrentAccessController : " + key + " " + this.getUuid()));
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        ThrottleDataHolder throttleDataHolder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received ConcurrentAccessUpdateClusterMessage : " + this.getUuid()));
        }
        if ((throttleDataHolder = (ThrottleDataHolder)configContext.getProperty("throttle_info")) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Start executing ClusterMessage : " + this.getUuid()));
            }
            ConcurrentAccessController localAccessController = throttleDataHolder.getConcurrentAccessController(this.key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting local ConcurrentAccessController for key : " + this.key));
            }
            if (localAccessController != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local ConcurrentAccessController for key : " + this.key + " is already present in ThrottleDataHolder"));
                }
                String string = this.key.intern();
                synchronized (string) {
                    localAccessController = throttleDataHolder.getConcurrentAccessController(this.key);
                    if (localAccessController != null) {
                        localAccessController.updateCounter(this.action);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replicated the ConcurrentAccessController for key : " + this.key + " in ThrottleDataHolder"));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Finished executing ClusterMessage : " + this.getUuid()));
            }
        }
    }
}

