/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.AccessInformation;
import org.apache.synapse.commons.throttle.core.CallerConfiguration;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.core.factory.CallerContextFactory;

public class RoleBasedAccessRateController {
    private static Log log = LogFactory.getLog((String)RoleBasedAccessRateController.class.getName());
    private static final String ACCESS_DENIED_TEMPORALLY = "You cannot access this service since you have exceeded the allocated quota.";
    private static final String ACCESS_DENIED = "You cannot access this service since you have been prohibited permanently.";
    private final Object lock = new Object();
    private boolean debugOn = log.isDebugEnabled();

    public AccessInformation canAccess(ThrottleContext throttleContext, String consumerKey, String roleID) throws ThrottleException {
        return this.canAccess(throttleContext, consumerKey, roleID, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessInformation canAccess(ThrottleContext throttleContext, String consumerKey, String roleID, Long eventCount) throws ThrottleException {
        String type = "role";
        ThrottleConfiguration throttleConfigurationBean = throttleContext.getThrottleConfiguration();
        AccessInformation accessInformation = new AccessInformation();
        if (throttleConfigurationBean == null) {
            if (this.debugOn) {
                log.debug((Object)"Couldn't find Throttle Configuration!! - Throttling will not occur");
            }
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (roleID == null) {
            String msg = "Couldn't find consumer role!! - Access will be denied ";
            if (this.debugOn) {
                log.debug((Object)msg);
            }
            accessInformation.setAccessAllowed(false);
            accessInformation.setFaultReason(msg);
            return accessInformation;
        }
        CallerConfiguration configuration = throttleConfigurationBean.getCallerConfiguration(roleID);
        if (configuration == null) {
            if (this.debugOn) {
                log.debug((Object)("Caller configuration couldn't find for " + type + " and for caller " + roleID));
            }
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (configuration.getAccessState() == 1) {
            log.info((Object)ACCESS_DENIED);
            accessInformation.setAccessAllowed(false);
            accessInformation.setFaultReason(ACCESS_DENIED);
            return accessInformation;
        }
        if (configuration.getAccessState() == 2) {
            accessInformation.setAccessAllowed(true);
            return accessInformation;
        }
        if (configuration.getAccessState() == 0) {
            String string = consumerKey.intern();
            synchronized (string) {
                CallerContext caller = throttleContext.getCallerContext(consumerKey);
                if (caller == null) {
                    log.debug((Object)("Caller for " + consumerKey + " is not present , Thread : " + Thread.currentThread().getName()));
                    caller = throttleContext.getCallerContext(consumerKey);
                    if (caller == null) {
                        log.debug((Object)("Caller for " + consumerKey + " is not present for a second time , Thread : " + Thread.currentThread().getName()));
                        caller = CallerContextFactory.createCaller(2, consumerKey);
                    }
                }
                if (caller != null) {
                    long currentTime = System.currentTimeMillis();
                    if (!caller.canAccess(throttleContext, configuration, currentTime, eventCount)) {
                        log.info((Object)ACCESS_DENIED_TEMPORALLY);
                        throttleContext.processCleanList(currentTime);
                        accessInformation.setAccessAllowed(false);
                        accessInformation.setFaultReason(ACCESS_DENIED_TEMPORALLY);
                        return accessInformation;
                    }
                    if (this.debugOn) {
                        log.debug((Object)("Access  from " + type + " " + roleID + " is successful."));
                    }
                    accessInformation.setAccessAllowed(true);
                    return accessInformation;
                }
                if (this.debugOn) {
                    log.debug((Object)("Caller " + type + " not found! " + roleID));
                }
                accessInformation.setAccessAllowed(true);
                return accessInformation;
            }
        }
        accessInformation.setAccessAllowed(true);
        return accessInformation;
    }
}

