/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class ThrottleContextCleanupTask {
    private static final Log log = LogFactory.getLog(ThrottleContextCleanupTask.class);
    private List<ThrottleContext> throttleContexts = new ArrayList<ThrottleContext>();

    public ThrottleContextCleanupTask() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Throttle Cleanup Task");
                return t;
            }
        });
        String throttleFrequency = ThrottleServiceDataHolder.getInstance().getThrottleProperties().getThrottleFrequency();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Throttling Cleanup Task Frequency set to " + throttleFrequency));
        }
        executor.scheduleAtFixedRate(new CleanupTask(), Integer.parseInt(throttleFrequency), Integer.parseInt(throttleFrequency), TimeUnit.MILLISECONDS);
    }

    public void addThrottleContext(ThrottleContext throttleContext) {
        this.throttleContexts.add(throttleContext);
    }

    private class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Running the cleanup task");
            }
            for (ThrottleContext throttleContext : ThrottleContextCleanupTask.this.throttleContexts) {
                throttleContext.cleanupCallers(System.currentTimeMillis());
            }
        }
    }
}

