/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ThrottleContext;

public class ThrottleDataHolder {
    private static final Log log = LogFactory.getLog(ThrottleDataHolder.class);
    private UUID uuid = null;
    private ConcurrentHashMap<String, CallerContext> callerContextMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ThrottleContext> applicationThrottleContexts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentAccessController> concurrentAccessControllerMap = new ConcurrentHashMap();

    public ThrottleDataHolder() {
        if (log.isDebugEnabled()) {
            this.uuid = UUID.randomUUID();
        }
        log.debug((Object)("Created new ThrottleDataHolder " + this.uuid));
    }

    public ConcurrentAccessController getConcurrentAccessController(String key) {
        return this.concurrentAccessControllerMap.get(key);
    }

    public void setConcurrentAccessController(String key, ConcurrentAccessController concurrentAccessController) {
        this.concurrentAccessControllerMap.put(key, concurrentAccessController);
    }

    public void removeConcurrentAccessController(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing ConcurrentAccessController for " + key));
        }
        this.concurrentAccessControllerMap.remove(key);
    }

    public ThrottleContext getThrottleContext(String applicationId) {
        return this.applicationThrottleContexts.get(applicationId);
    }

    public void addThrottleContext(String applicationId, ThrottleContext applicationThrottleContext) {
        this.applicationThrottleContexts.put(applicationId, applicationThrottleContext);
    }

    public void addCallerContext(String id, CallerContext callerContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ADD CALLER CONTEXT WITH ID" + id));
        }
        this.callerContextMap.put(id, callerContext);
    }

    public CallerContext getCallerContext(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET CALLER CONTEXT WITH ID" + id));
        }
        return this.callerContextMap.get(id);
    }

    public void removeCaller(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REMOVING CALLER CONTEXT WITH ID " + id));
        }
        this.callerContextMap.remove(id);
    }
}

