/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class ThrottleUtil {
    private static Log log = LogFactory.getLog((String)ThrottleUtil.class.getName());
    public static final String THROTTLING_CACHE_MANAGER = "throttling.cache.manager";
    private static final String CONF_LOCATION = "conf.location";
    public static final String THROTTLING_CACHE = "throttling.cache";

    public static ThrottleProperties loadThrottlePropertiesFromConfigurations() {
        ThrottleProperties throttleProperties = new ThrottleProperties();
        Properties properties = new Properties();
        if (System.getProperty(CONF_LOCATION) != null) {
            String throttlePropertiesFileLocation = System.getProperty(CONF_LOCATION) + File.separator + "throttle.properties";
            try {
                properties.load(new FileInputStream(throttlePropertiesFileLocation));
                SecretResolver secretResolver = SecretResolverFactory.create((Properties)properties);
                Set<String> keys = properties.stringPropertyNames();
                for (String key : keys) {
                    String localQuotaBufferPercentage;
                    String hybridThrottleProcessorWindowType;
                    String throttleSyncAsyncHybridModeEnabled;
                    String distributedCounterType;
                    String windowReplicatorFrequency;
                    String windowReplicatorPoolSize;
                    String throttlingKeysToReplicate;
                    String throttlingReplicationFrequency;
                    String throttlingPoolSize;
                    String maxNonAssociatedCounterCleanupAmount;
                    String throttleDistributedCleanupTaskEnable;
                    String throttleDistributedCleanupAmount;
                    String throttleDistributedCleanupPoolSize;
                    String throttleContextDistributedExpiredInstanceTime;
                    String throttleContextDistributedCleanupTaskFrequency;
                    String throttleFrequency;
                    if ("throttling.context.cleanup.frequency".equals(key) && !StringUtils.isEmpty((String)(throttleFrequency = properties.getProperty(key)))) {
                        throttleProperties.setThrottleFrequency(throttleFrequency);
                    }
                    if ("throttling.context.distributed.cleanup.frequency".equals(key) && (throttleContextDistributedCleanupTaskFrequency = properties.getProperty(key)) != null && !throttleContextDistributedCleanupTaskFrequency.equals("")) {
                        throttleProperties.setThrottleContextDistributedCleanupTaskFrequency(throttleContextDistributedCleanupTaskFrequency);
                    }
                    if ("throttling.context.distributed.expired.instance.time".equals(key) && (throttleContextDistributedExpiredInstanceTime = properties.getProperty(key)) != null && !throttleContextDistributedExpiredInstanceTime.equals("")) {
                        throttleProperties.setThrottleContextDistributedExpiredInstanceTime(throttleContextDistributedExpiredInstanceTime);
                    }
                    if ("throttling.context.distributed.cleanup.pool.size".equals(key) && (throttleDistributedCleanupPoolSize = properties.getProperty(key)) != null && throttleDistributedCleanupPoolSize != "") {
                        throttleProperties.setThrottleDistributedCleanupPoolSize(throttleDistributedCleanupPoolSize);
                    }
                    if ("throttling.context.distributed.cleanup.amount".equals(key) && (throttleDistributedCleanupAmount = properties.getProperty(key)) != null && throttleDistributedCleanupAmount != "") {
                        throttleProperties.setThrottleDistributedCleanupAmount(throttleDistributedCleanupAmount);
                    }
                    if ("throttling.context.distributed.cleanup.task.enabled".equals(key) && (throttleDistributedCleanupTaskEnable = properties.getProperty(key)) != null && throttleDistributedCleanupTaskEnable != "") {
                        throttleProperties.setThrottleDistributedCleanupTaskEnable(throttleDistributedCleanupTaskEnable);
                    }
                    if ("stale.counter.references".equals(key) && (maxNonAssociatedCounterCleanupAmount = properties.getProperty(key)) != null && maxNonAssociatedCounterCleanupAmount != "") {
                        throttleProperties.setMaxNonAssociatedCounterCleanupAmount(maxNonAssociatedCounterCleanupAmount);
                    }
                    if ("throttling.pool.size".equals(key) && (throttlingPoolSize = properties.getProperty(key)) != null && throttlingPoolSize != "") {
                        throttleProperties.setThrottlingPoolSize(throttlingPoolSize);
                    }
                    if ("throttling.replication.frequency".equals(key) && (throttlingReplicationFrequency = properties.getProperty(key)) != null && throttlingReplicationFrequency != "") {
                        throttleProperties.setThrottlingReplicationFrequency(throttlingReplicationFrequency);
                    }
                    if ("throttling.keys.to.replicate".equals(key) && (throttlingKeysToReplicate = properties.getProperty(key)) != null && throttlingKeysToReplicate != "") {
                        throttleProperties.setThrottlingKeysToReplicates(throttlingKeysToReplicate);
                    }
                    if ("throttlingWindowReplicator.pool.size".equals(key) && (windowReplicatorPoolSize = properties.getProperty(key)) != null && windowReplicatorPoolSize != "") {
                        throttleProperties.setWindowReplicatorPoolSize(windowReplicatorPoolSize);
                    }
                    if ("throttlingWindowReplicator.replication.frequency".equals(key) && (windowReplicatorFrequency = properties.getProperty(key)) != null && windowReplicatorFrequency != "") {
                        throttleProperties.setWindowReplicatorFrequency(windowReplicatorFrequency);
                    }
                    if ("throttling.distributed.counter.type".equals(key) && (distributedCounterType = properties.getProperty(key)) != null && !distributedCounterType.equals("")) {
                        throttleProperties.setDistributedCounterType(distributedCounterType);
                    }
                    if (key.contains("throttling.distributed.counter.configurations.")) {
                        String distributedConfiguration = properties.getProperty(key);
                        String configuration = key.split("throttling.distributed.counter.configurations.")[1];
                        if (StringUtils.isNotEmpty((String)distributedConfiguration)) {
                            throttleProperties.getDistributedCounterConfigurations().put(configuration, ThrottleUtil.getResolvedValue(secretResolver, distributedConfiguration));
                        }
                    }
                    if (key.contains("throttling.sync-async_hybrid_mode.enable") && StringUtils.isNotEmpty((String)(throttleSyncAsyncHybridModeEnabled = properties.getProperty(key)))) {
                        throttleProperties.setThrottleSyncAsyncHybridModeEnabled(Boolean.parseBoolean(throttleSyncAsyncHybridModeEnabled));
                    }
                    if (key.contains("throttling.hybrid_throttle_processor_window.type") && StringUtils.isNotEmpty((String)(hybridThrottleProcessorWindowType = properties.getProperty(key)))) {
                        throttleProperties.setHybridThrottleProcessorWindowType(hybridThrottleProcessorWindowType);
                    }
                    if (!key.contains("throttling.local_quota_buffer_percentage") || !StringUtils.isNotEmpty((String)(localQuotaBufferPercentage = properties.getProperty(key)))) continue;
                    throttleProperties.setLocalQuotaBufferPercentage(localQuotaBufferPercentage);
                }
            }
            catch (IOException e) {
                log.debug((Object)"Setting the Default Throttle Properties");
            }
        } else {
            log.debug((Object)"Setting the Default Throttle Properties");
        }
        return throttleProperties;
    }

    private static String getResolvedValue(SecretResolver secretResolver, String value) {
        if (secretResolver.isInitialized()) {
            return MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
        }
        return value;
    }

    public static Cache<String, CallerContext> getThrottleCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(THROTTLING_CACHE_MANAGER);
        Cache cache = cacheManager != null ? cacheManager.getCache(THROTTLING_CACHE) : Caching.getCacheManager().getCache(THROTTLING_CACHE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created throttling cache : " + cache));
        }
        return cache;
    }
}

