/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.DistributedCounterManager;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;
import org.apache.synapse.commons.throttle.core.ThrottleUtil;
import org.apache.synapse.commons.throttle.core.internal.DistributedThrottleProcessor;

public class ThrottleServiceDataHolder {
    private static final Log log = LogFactory.getLog((String)ThrottleServiceDataHolder.class.getName());
    private Map<String, DistributedCounterManager> distributedCounterManagerMap = new HashMap<String, DistributedCounterManager>();
    private Map<String, DistributedThrottleProcessor> distributedThrottleProcessorMap = new HashMap<String, DistributedThrottleProcessor>();
    private ThrottleProperties throttleProperties = null;
    private static ThrottleServiceDataHolder thisInstance = new ThrottleServiceDataHolder();

    private ThrottleServiceDataHolder() {
    }

    public ThrottleProperties getThrottleProperties() {
        return this.throttleProperties;
    }

    public void setThrottleProperties(ThrottleProperties throttleProperties) {
        this.throttleProperties = throttleProperties;
    }

    public static ThrottleServiceDataHolder getInstance() {
        if (thisInstance != null && thisInstance.getThrottleProperties() == null) {
            thisInstance.setThrottleProperties(ThrottleUtil.loadThrottlePropertiesFromConfigurations());
        }
        return thisInstance;
    }

    public void addDistributedCounterManager(DistributedCounterManager distributedCounterManager) {
        this.distributedCounterManagerMap.put(distributedCounterManager.getType(), distributedCounterManager);
    }

    public void removeDistributedCounterManager(DistributedCounterManager distributedCounterManager) {
        if (distributedCounterManager != null) {
            this.distributedCounterManagerMap.remove(distributedCounterManager.getType());
        }
    }

    public DistributedCounterManager getDistributedCounterManager() {
        String distributedCounterType = this.throttleProperties.getDistributedCounterType();
        return this.distributedCounterManagerMap.get(distributedCounterType);
    }

    public void addDistributedThrottleProcessor(DistributedThrottleProcessor distributedThrottleProcessor) {
        this.distributedThrottleProcessorMap.put(distributedThrottleProcessor.getType(), distributedThrottleProcessor);
    }

    public void removeDistributedThrottleProcessor(DistributedThrottleProcessor distributedThrottleProcessor) {
        if (distributedThrottleProcessor != null) {
            this.distributedThrottleProcessorMap.remove(distributedThrottleProcessor.getType());
        }
    }

    public DistributedThrottleProcessor getDistributedThrottleProcessor() {
        String distributedThrottleProcessorType = this.throttleProperties.getDistributedThrottleProcessorType();
        return this.distributedThrottleProcessorMap.get(distributedThrottleProcessorType);
    }
}

