/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;

public class FilePropertyLoader {
    private static final Log LOG = LogFactory.getLog(FilePropertyLoader.class);
    private static final String CONF_LOCATION = "conf.location";
    private static final String FILE_PROPERTY_PATH = "properties.file.path";
    private static final String DEFAULT_PROPERTY_FILE = "file.properties";
    private static final String FILE_SYNC_INTERVAL = "file.properties.sync.interval";
    private static final String FILE_CANNOT_BE_FOUND_ERROR = "File cannot found in ";
    private String propertiesFilePath;
    private long lastModifiedTimestamp;
    private Map<String, String> propertyMap;
    private static FilePropertyLoader fileLoaderInstance;

    private FilePropertyLoader() {
        this.init();
        this.loadPropertiesFile();
        String fileSyncIntervalString = System.getProperty(FILE_SYNC_INTERVAL);
        if (StringUtils.isNotEmpty((String)fileSyncIntervalString)) {
            try {
                int syncInterval = Integer.parseInt(fileSyncIntervalString);
                if (syncInterval > 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File syncing enabled with interval " + syncInterval));
                    }
                    Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FilePropertySyncTask-%d").build()).scheduleAtFixedRate(() -> {
                        try {
                            this.loadPropertiesFile();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"File property sync task completed");
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while syncing properties file ", (Throwable)e);
                        }
                    }, syncInterval, syncInterval, TimeUnit.SECONDS);
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Dropping system property file.properties.sync.interval with incorrect value specified. File property syncing will be disabled. ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilePropertyLoader getInstance() {
        if (Objects.nonNull(fileLoaderInstance)) {
            return fileLoaderInstance;
        }
        Class<FilePropertyLoader> clazz = FilePropertyLoader.class;
        synchronized (FilePropertyLoader.class) {
            if (Objects.isNull(fileLoaderInstance)) {
                fileLoaderInstance = new FilePropertyLoader();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileLoaderInstance;
        }
    }

    public String getValue(String input) {
        return this.propertyMap.get(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadPropertiesFile() throws SynapseCommonsException {
        File file = new File(this.propertiesFilePath);
        if (!file.exists()) throw new SynapseCommonsException(FILE_CANNOT_BE_FOUND_ERROR + this.propertiesFilePath);
        if (file.lastModified() <= this.lastModifiedTimestamp) return;
        try (InputStream in = Files.newInputStream(Paths.get(this.propertiesFilePath, new String[0]), new OpenOption[0]);){
            Properties rawProps = new Properties();
            HashMap<String, String> tempPropertyMap = new HashMap<String, String>();
            rawProps.load(in);
            for (Map.Entry<Object, Object> propertyEntry : rawProps.entrySet()) {
                String strValue = (String)propertyEntry.getValue();
                tempPropertyMap.put((String)propertyEntry.getKey(), strValue);
            }
            this.propertyMap = tempPropertyMap;
            this.lastModifiedTimestamp = file.lastModified();
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("Synced properties from " + this.propertiesFilePath));
            return;
        }
        catch (IOException ex) {
            throw new SynapseCommonsException("Failed to read " + this.propertiesFilePath, ex);
        }
    }

    private void init() {
        String filePath = System.getProperty(FILE_PROPERTY_PATH);
        if (null == filePath || filePath.isEmpty()) {
            throw new SynapseCommonsException("properties.file.path is empty or null");
        }
        this.propertiesFilePath = "default".equals(filePath) ? System.getProperty(CONF_LOCATION) + File.separator + DEFAULT_PROPERTY_FILE : filePath;
        File file = new File(this.propertiesFilePath);
        if (!file.exists()) {
            throw new SynapseCommonsException(FILE_CANNOT_BE_FOUND_ERROR + filePath);
        }
        this.propertyMap = new HashMap<String, String>();
    }
}

