/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;

public class MTOMSwAClient {
    private static final int BUFFER = 2048;

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    private static ServiceClient createServiceClient() throws AxisFault {
        String repo = MTOMSwAClient.getProperty("repository", "client_repo");
        if (repo != null && !"null".equals(repo)) {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            return new ServiceClient(configContext, null);
        }
        return new ServiceClient();
    }

    public static void main(String[] args) throws Exception {
        String targetEPR = MTOMSwAClient.getProperty("opt_url", "http://localhost:8280/services/MTOMSwASampleService");
        String fileName = MTOMSwAClient.getProperty("opt_file", "./../../repository/samples/resources/mtom/asf-logo.gif");
        String mode = MTOMSwAClient.getProperty("opt_mode", "mtom");
        if (args.length > 0) {
            mode = args[0];
        }
        if (args.length > 1) {
            targetEPR = args[1];
        }
        if (args.length > 2) {
            fileName = args[2];
        }
        if ("mtom".equals(mode)) {
            MTOMSwAClient.sendUsingMTOM(fileName, targetEPR);
        } else if ("swa".equals(mode)) {
            MTOMSwAClient.sendUsingSwA(fileName, targetEPR);
        }
        Thread.sleep(1000L);
        System.exit(0);
    }

    public static MessageContext sendUsingSwA(String fileName, String targetEPR) throws IOException {
        Options options = new Options();
        options.setTo(new EndpointReference(targetEPR));
        options.setAction("urn:uploadFileUsingSwA");
        options.setProperty("enableSwA", (Object)"true");
        ServiceClient sender = MTOMSwAClient.createServiceClient();
        sender.setOptions(options);
        OperationClient mepClient = sender.createClient(ServiceClient.ANON_OUT_IN_OP);
        MessageContext mc = new MessageContext();
        System.out.println("Sending file : " + fileName + " as SwA");
        FileDataSource fileDataSource = new FileDataSource(new File(fileName));
        DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
        String attachmentID = mc.addAttachment(dataHandler);
        SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope env = factory.getDefaultEnvelope();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "m0");
        OMElement payload = factory.createOMElement("uploadFileUsingSwA", ns);
        OMElement request = factory.createOMElement("request", ns);
        OMElement imageId = factory.createOMElement("imageId", ns);
        imageId.setText(attachmentID);
        request.addChild((OMNode)imageId);
        payload.addChild((OMNode)request);
        env.getBody().addChild((OMNode)payload);
        mc.setEnvelope(env);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
        MessageContext response = mepClient.getMessageContext("In");
        SOAPBody body = response.getEnvelope().getBody();
        String imageContentId = body.getFirstChildWithName(new QName("http://services.samples", "uploadFileUsingSwAResponse")).getFirstChildWithName(new QName("http://services.samples", "response")).getFirstChildWithName(new QName("http://services.samples", "imageId")).getText();
        Attachments attachment = response.getAttachmentMap();
        dataHandler = attachment.getDataHandler(imageContentId);
        File tempFile = File.createTempFile("swa-", ".gif");
        FileOutputStream fos = new FileOutputStream(tempFile);
        dataHandler.writeTo((OutputStream)fos);
        fos.flush();
        fos.close();
        System.out.println("Saved response to file : " + tempFile.getAbsolutePath());
        return response;
    }

    public static OMElement sendUsingMTOM(String fileName, String targetEPR) throws IOException {
        int count;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "m0");
        OMElement payload = factory.createOMElement("uploadFileUsingMTOM", ns);
        OMElement request = factory.createOMElement("request", ns);
        OMElement image = factory.createOMElement("image", ns);
        System.out.println("Sending file : " + fileName + " as MTOM");
        FileDataSource fileDataSource = new FileDataSource(new File(fileName));
        DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
        OMText textData = factory.createOMText((Object)dataHandler, true);
        image.addChild((OMNode)textData);
        request.addChild((OMNode)image);
        payload.addChild((OMNode)request);
        ServiceClient serviceClient = MTOMSwAClient.createServiceClient();
        Options options = new Options();
        options.setTo(new EndpointReference(targetEPR));
        options.setAction("urn:uploadFileUsingMTOM");
        options.setProperty("enableMTOM", (Object)"true");
        serviceClient.setOptions(options);
        OMElement response = serviceClient.sendReceive(payload);
        OMText binaryNode = (OMText)response.getFirstChildWithName(new QName("http://services.samples", "response")).getFirstChildWithName(new QName("http://services.samples", "image")).getFirstOMChild();
        dataHandler = (DataHandler)binaryNode.getDataHandler();
        InputStream is = dataHandler.getInputStream();
        File tempFile = File.createTempFile("mtom-", ".gif");
        FileOutputStream fos = new FileOutputStream(tempFile);
        BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
        byte[] data = new byte[2048];
        while ((count = is.read(data, 0, 2048)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        System.out.println("Saved response to file : " + tempFile.getAbsolutePath());
        return response;
    }
}

